/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.pluginutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeSorter {
    public static <N> List<N> sort(Collection<N> toSort, NodeHandler<N> nodeHandler) {
        if (toSort.size() < 2) {
            return new ArrayList<N>(toSort);
        }
        HashMap<N, Counter> predecessorCounts = new HashMap<N, Counter>(toSort.size());
        for (N vertex : toSort) {
            predecessorCounts.put(vertex, new Counter());
        }
        for (N vertex : toSort) {
            Collection<N> successors = nodeHandler.next(vertex);
            for (N successor : successors) {
                Counter predecessorCount = (Counter)predecessorCounts.get(successor);
                if (predecessorCount == null) continue;
                ++predecessorCount.count;
            }
        }
        ArrayList sorted = new ArrayList(toSort.size());
        int i = 0;
        while (i < toSort.size()) {
            for (Map.Entry it : predecessorCounts.entrySet()) {
                if (((Counter)it.getValue()).count != 0) continue;
                ((Counter)it.getValue()).count = -1;
                sorted.add(it.getKey());
                if (sorted.size() == toSort.size()) {
                    return sorted;
                }
                for (N successor : nodeHandler.next(it.getKey())) {
                    Counter predecessorCount = (Counter)predecessorCounts.get(successor);
                    if (predecessorCount == null) continue;
                    --predecessorCount.count;
                }
            }
            ++i;
        }
        throw new IllegalArgumentException("Cycle found");
    }

    static class Counter {
        int count = 0;

        Counter() {
        }

        public String toString() {
            return "" + this.count;
        }
    }

    public static interface NodeHandler<T> {
        public Collection<T> next(T var1);
    }
}

