/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.exception.UnrecoverableException;
import pcal.exception.UnrecoverablePositionedException;
import util.ToolIO;

public class PcalDebug {
    public static final String UNRECOVERABLE_ERROR = "\nUnrecoverable error:\n -- ";
    public static final String WARNING = "Warning: ";
    public static final String ERROR_POSTFIX = ".\n";

    public static void reportError(UnrecoverableException e) {
        if (e instanceof UnrecoverablePositionedException) {
            PcalDebug.reportError(e.getMessage(), ((UnrecoverablePositionedException)e).getPosition());
        } else {
            PcalDebug.reportError(e.getMessage());
        }
    }

    public static void reportWarning(String warningText) {
        ToolIO.out.println(new StringBuffer(WARNING).append(warningText));
    }

    public static void reportInfo(String infoText) {
        ToolIO.out.println(infoText);
    }

    public static void reportError(String message) {
        ToolIO.out.println(new StringBuffer(UNRECOVERABLE_ERROR).append(message).append(ERROR_POSTFIX).toString());
    }

    public static void reportError(String message, AST ast) {
        if (ast == null || ast.line == 0) {
            PcalDebug.reportError(message);
        } else {
            PcalDebug.reportError(message + "\n    at " + ast.location());
        }
    }

    public static void Assert(boolean val) {
        if (!val) {
            PcalDebug.ReportBug("Assertion failure");
        }
    }

    public static void Assert(boolean val, String msg) {
        if (!val) {
            PcalDebug.ReportBug("Failure of assertion: " + msg);
        }
    }

    public static void ReportBug(String msg) {
        StringBuilder sb = new StringBuilder("You have discovered a bug in pcal.trans.\n");
        sb.append("Send the following information and the\ninput file to the current maintainer(s).\n\n -- ");
        sb.append(msg).append(".");
        ToolIO.out.println("");
        ToolIO.out.println(sb.toString());
        ToolIO.out.println("");
        throw new Error(sb.toString());
    }

    public static void printObjectArray(Object[] array, String name) {
        if (array == null) {
            ToolIO.out.println(name + " == null");
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                ToolIO.out.println(name + "[" + i + "] = null");
                continue;
            }
            ToolIO.out.println(name + "[" + i + "] = " + array[i].toString());
        }
        if (array.length == 0) {
            ToolIO.out.println(name + " = zero-length array");
        }
    }

    public static void printIntArray(int[] array, String name) {
        if (array == null) {
            ToolIO.out.println(name + " == null");
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            ToolIO.out.println(name + "[" + i + "] = " + array[i]);
        }
        if (array.length == 0) {
            ToolIO.out.println(name + " = zero-length array");
        }
    }

    public static void print2DArray(Object[][] array, String name) {
        if (array == null) {
            ToolIO.out.println(name + " == null");
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                ToolIO.out.println(name + "[" + i + "][" + j + "] = " + array[i][j].toString());
            }
            if (array[i].length != 0) continue;
            ToolIO.out.println(name + "[" + i + "] = null");
        }
        if (array.length == 0) {
            ToolIO.out.println(name + " = zero-length array");
        }
    }

    public static void printVector(Vector vec, String name) {
        if (vec == null) {
            ToolIO.out.println(name + " == null");
            return;
        }
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.elementAt(i) == null) {
                ToolIO.out.println(name + "[" + i + "] = null");
                continue;
            }
            ToolIO.out.println(name + "[" + i + "] = " + vec.elementAt(i).toString());
        }
        if (vec.size() == 0) {
            ToolIO.out.println(name + " = zero-length vec");
        }
    }

    public static void print2DVector(Vector vec, String name) {
        if (vec == null) {
            ToolIO.out.println(name + " == null");
            return;
        }
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.elementAt(i) == null) {
                ToolIO.out.println(name + "[" + i + "] = null");
                continue;
            }
            PcalDebug.printVector((Vector)vec.elementAt(i), name + "[" + i + "]");
        }
        if (vec.size() == 0) {
            ToolIO.out.println(name + " = zero-length vec");
        }
    }

    public static String pair(int i, int j) {
        return "(" + i + ", " + j + ")";
    }

    public static void printPair(int i, int j) {
        ToolIO.out.println(PcalDebug.pair(i, j));
    }
}

