/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.BuiltInOperators;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import util.UniqueString;

public class Context
implements ExploreNode {
    private static Context initialContext = new Context(null);
    private ExternalModuleTable exMT;
    private Hashtable<Object, Pair> table = new Hashtable();
    private Pair lastPair;

    public Context(ExternalModuleTable mt) {
        this.exMT = mt;
        this.lastPair = null;
    }

    public static void reInit() {
        initialContext = new Context(null);
        Context.initialize();
    }

    public static Context getGlobalContext() {
        return initialContext;
    }

    public static boolean isBuiltIn(ExploreNode exploreNode) {
        Collection<Pair> pairs = Context.initialContext.table.values();
        for (Pair p : pairs) {
            if (exploreNode != p.info) continue;
            return true;
        }
        return false;
    }

    private static void addGlobalSymbol(UniqueString name, SymbolNode sn) {
        if (initialContext.occurSymbol(name)) {
            throw new RuntimeException("Error building initial context: Multiply-defined builtin operator " + String.valueOf(name) + " at " + String.valueOf(sn));
        }
        initialContext.addSymbolToContext(name, sn);
    }

    public SymbolNode getSymbol(Object name) {
        Pair r = this.table.get(name);
        if (r != null) {
            return r.info;
        }
        return null;
    }

    public void addSymbolToContext(Object name, SymbolNode s) {
        this.table.put(name, new Pair(s));
    }

    public boolean occurSymbol(Object name) {
        return this.table.containsKey(name);
    }

    Enumeration<Pair> content() {
        return this.table.elements();
    }

    public ContextSymbolEnumeration getContextSymbolEnumeration() {
        return new ContextSymbolEnumeration();
    }

    public <T> Vector<T> getByClass(Class<T> template) {
        Vector<T> result = new Vector<T>();
        Enumeration<Pair> list = this.table.elements();
        while (list.hasMoreElements()) {
            Pair elt = list.nextElement();
            if (!template.isInstance(elt.info)) continue;
            result.addElement(template.cast(elt.info));
        }
        return result;
    }

    public Vector<OpDefNode> getOpDefs() {
        Pair nextPair = this.lastPair;
        Vector<OpDefNode> result = new Vector<OpDefNode>();
        while (nextPair != null) {
            if (nextPair.info instanceof OpDefNode && ((OpDefNode)nextPair.info).getKind() != 6 && ((OpDefNode)nextPair.info).getKind() != 7) {
                result.addElement((OpDefNode)nextPair.info);
            }
            nextPair = nextPair.link;
        }
        return result;
    }

    public Vector<ThmOrAssumpDefNode> getThmOrAssDefs() {
        Pair nextPair = this.lastPair;
        Vector<ThmOrAssumpDefNode> result = new Vector<ThmOrAssumpDefNode>();
        while (nextPair != null) {
            if (nextPair.info instanceof ThmOrAssumpDefNode) {
                result.addElement((ThmOrAssumpDefNode)nextPair.info);
            }
            nextPair = nextPair.link;
        }
        return result;
    }

    public Vector<OpDeclNode> getConstantDecls() {
        Class<OpDeclNode> templateClass = OpDeclNode.class;
        Enumeration<Pair> list = this.table.elements();
        Vector<OpDeclNode> result = new Vector<OpDeclNode>();
        while (list.hasMoreElements()) {
            Pair elt = list.nextElement();
            if (!templateClass.isInstance(elt.info) || ((OpDeclNode)elt.info).getKind() != 2) continue;
            result.addElement((OpDeclNode)elt.info);
        }
        return result;
    }

    public Vector<OpDeclNode> getVariableDecls() {
        Class<OpDeclNode> templateClass = OpDeclNode.class;
        Enumeration<Pair> list = this.table.elements();
        Vector<OpDeclNode> result = new Vector<OpDeclNode>();
        while (list.hasMoreElements()) {
            Pair elt = list.nextElement();
            if (!templateClass.isInstance(elt.info) || ((OpDeclNode)elt.info).getKind() != 3) continue;
            result.addElement((OpDeclNode)elt.info);
        }
        return result;
    }

    public Vector<ModuleNode> getModDefs() {
        Class<ModuleNode> template = ModuleNode.class;
        Enumeration<Pair> list = this.table.elements();
        Vector<ModuleNode> result = new Vector<ModuleNode>();
        while (list.hasMoreElements()) {
            Pair elt = list.nextElement();
            if (!template.isInstance(elt.info)) continue;
            result.addElement((ModuleNode)elt.info);
        }
        return result;
    }

    public boolean mergeExtendContext(Context ct, Errors errors) {
        if (ct.lastPair == null) {
            return true;
        }
        boolean erc = true;
        Pair p = ct.lastPair.reversePairList();
        while (p != null) {
            SymbolNode sn = p.info;
            if (!sn.isLocal()) {
                Object sName = sn instanceof ModuleNode ? new SymbolTable.ModuleName(sn.getName()) : sn.getName();
                if (!this.table.containsKey(sName)) {
                    this.table.put(sName, new Pair(sn));
                } else {
                    SymbolNode symbol = this.table.get((Object)sName).info;
                    if (symbol != sn) {
                        if (symbol.getClass() == sn.getClass()) {
                            if (!symbol.sameOriginallyDefinedInModule(sn)) {
                                errors.addWarning(ErrorCode.EXTENDED_MODULES_SYMBOL_UNIFICATION_AMBIGUITY, sn.getTreeNode().getLocation(), "Warning: the " + Context.kindOfNode(symbol) + " of '" + sName.toString() + "' conflicts with \nits " + Context.kindOfNode(symbol) + " at " + String.valueOf(symbol.getTreeNode().getLocation()) + ".");
                            }
                        } else {
                            errors.addError(ErrorCode.EXTENDED_MODULES_SYMBOL_UNIFICATION_CONFLICT, sn.getTreeNode().getLocation(), "The " + Context.kindOfNode(symbol) + " of '" + sName.toString() + "' conflicts with \nits " + Context.kindOfNode(symbol) + " at " + String.valueOf(symbol.getTreeNode().getLocation()) + ".");
                            erc = false;
                        }
                    }
                }
            }
            p = p.link;
        }
        return erc;
    }

    private static String kindOfNode(SymbolNode symbol) {
        if (symbol instanceof OpDefNode) {
            return "definition";
        }
        if (symbol instanceof FormalParamNode) {
            return "definition";
        }
        return "declaration";
    }

    public Context duplicate(ExternalModuleTable exMT) {
        Context dup = new Context(exMT);
        Pair p = this.lastPair;
        Pair current = null;
        boolean firstTime = true;
        while (p != null) {
            if (firstTime) {
                dup.lastPair = current = new Pair(null, p.info);
                firstTime = false;
            } else {
                current = current.link = new Pair(null, p.info);
            }
            dup.table.put(current.info.getName(), current);
            p = p.link;
        }
        return dup;
    }

    @Override
    public String levelDataToString() {
        return "Dummy level string";
    }

    @Override
    public String toString(int depth, Errors errors) {
        return "Please use Context.getContextEntryStringVector() instead of Context.toString()";
    }

    public Vector<String> getContextEntryStringVector(int depth, boolean b, Errors errors) {
        Vector<String> ctxtEntries = new Vector<String>(100);
        Context naturalsContext = this.exMT.getContext(UniqueString.uniqueStringOf("Naturals"));
        if (depth <= 0) {
            return ctxtEntries;
        }
        Pair p = this.lastPair;
        while (p != null) {
            UniqueString key = p.info.getName();
            if (b || !Context.initialContext.table.containsKey(key) && (naturalsContext == null || !naturalsContext.table.containsKey(key))) {
                SymbolNode symbNode = this.table.get((Object)key).info;
                ctxtEntries.addElement("\nContext Entry: " + key.toString() + "  " + String.valueOf(symbNode.myUID).toString() + " " + Strings.indentSB(2, symbNode.toString(depth - 1, errors)));
            }
            p = p.link;
        }
        int n = ctxtEntries.size();
        for (int i = 0; i < n / 2; ++i) {
            String obj = ctxtEntries.elementAt(i);
            ctxtEntries.setElementAt(ctxtEntries.elementAt(n - 1 - i), i);
            ctxtEntries.setElementAt(obj, n - 1 - i);
        }
        return ctxtEntries;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        visitor.preVisit(this);
        Enumeration<Object> e = this.table.keys();
        while (e.hasMoreElements()) {
            UniqueString key;
            Object next = e.nextElement();
            if (next instanceof SymbolTable.ModuleName) {
                key = ((SymbolTable.ModuleName)next).name;
                System.out.println("Bug in debugging caused by inner module " + key.toString());
                System.out.println("SANY will throw a null pointer exception.");
            } else {
                key = (UniqueString)next;
                this.table.get((Object)key).info.walkGraph(semNodesTable, visitor);
            }
            visitor.postVisit(this);
        }
    }

    private static void initialize() {
        for (BuiltInOperators.BuiltInOperator op : BuiltInOperators.Properties) {
            Context.addGlobalSymbol(op.Name, new OpDefNode(op));
        }
    }

    static {
        Context.initialize();
    }

    class Pair {
        Pair link;
        SymbolNode info;

        Pair(Pair lnk, SymbolNode inf) {
            this.link = lnk;
            this.info = inf;
        }

        Pair(SymbolNode inf) {
            this.link = Context.this.lastPair;
            this.info = inf;
            Context.this.lastPair = this;
        }

        public SymbolNode getSymbol() {
            return this.info;
        }

        private Pair reversePairList() {
            Pair curResult = new Pair(null, this.info);
            Pair nextOriginal = this.link;
            while (nextOriginal != null) {
                curResult = new Pair(curResult, nextOriginal.info);
                nextOriginal = nextOriginal.link;
            }
            return curResult;
        }
    }

    public class ContextSymbolEnumeration {
        Enumeration<Pair> e;

        public ContextSymbolEnumeration() {
            this.e = Context.this.content();
        }

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public SymbolNode nextElement() {
            return this.e.nextElement().getSymbol();
        }
    }

    public class InitialSymbolEnumeration {
        Enumeration<Pair> e = initialContext.content();

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public SymbolNode nextElement() {
            return this.e.nextElement().getSymbol();
        }
    }
}

