/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.ErrorCode;
import tla2sany.st.Location;

public class Errors {
    private final List<ErrorDetails> messages = new ArrayList<ErrorDetails>();

    public List<ErrorDetails> getMessagesOfLevel(ErrorCode.ErrorLevel level) {
        return this.messages.stream().filter(msg -> msg.getCode().getSeverityLevel().equals((Object)level)).collect(Collectors.toList());
    }

    public List<ErrorDetails> getMessages() {
        return new ArrayList<ErrorDetails>(this.messages);
    }

    public List<ErrorDetails> getErrorDetails() {
        return this.getMessagesOfLevel(ErrorCode.ErrorLevel.ERROR);
    }

    public String[] getErrors() {
        return (String[])this.getErrorDetails().stream().map(ErrorDetails::toString).toArray(String[]::new);
    }

    public List<ErrorDetails> getWarningDetails() {
        return this.getMessagesOfLevel(ErrorCode.ErrorLevel.WARNING);
    }

    public String[] getWarnings() {
        return (String[])this.getWarningDetails().stream().map(ErrorDetails::toString).toArray(String[]::new);
    }

    public final AbortException addMessage(ErrorCode code, Location loc, String format, Object ... parameters) {
        ErrorDetails message = new ErrorDetails(code, loc = null == loc ? Location.nullLoc : loc, format, parameters);
        if (!this.messages.contains(message)) {
            this.messages.add(message);
        }
        return new AbortException(message, this);
    }

    @Deprecated
    public final void addWarning(ErrorCode code, Location loc, String str) {
        this.addMessage(code, loc, str, new Object[0]);
    }

    @Deprecated
    public final AbortException addError(ErrorCode code, Location loc, String str) {
        return this.addMessage(code, loc, str, new Object[0]);
    }

    public final boolean isSuccess() {
        return this.getErrorDetails().isEmpty();
    }

    public final boolean isFailure() {
        return !this.isSuccess();
    }

    public final int getNumErrors() {
        return this.getErrorDetails().size();
    }

    public final int getNumMessages() {
        return this.messages.size();
    }

    public final String toString() {
        StringBuffer ret = new StringBuffer("");
        List<ErrorDetails> errors = this.getErrorDetails();
        ret.append((String)(errors.size() > 0 ? "*** Errors: " + errors.size() + "\n\n" : ""));
        for (ErrorDetails error : errors) {
            ret.append(error.toString() + "\n\n\n");
        }
        List<ErrorDetails> warnings = this.getWarningDetails();
        ret.append((String)(warnings.size() > 0 ? "*** Warnings: " + warnings.size() + "\n\n" : ""));
        for (ErrorDetails error : warnings) {
            ret.append(error.toString() + "\n\n\n");
        }
        return ret.toString();
    }

    public static final class ErrorDetails {
        private final ErrorCode code;
        private final Location location;
        private final String format;
        private final Object[] parameters;

        ErrorDetails(ErrorCode code, Location location, String format, Object ... parameters) {
            this.code = code;
            this.location = location;
            this.format = format;
            this.parameters = parameters;
        }

        public ErrorCode getCode() {
            return this.code;
        }

        public Location getLocation() {
            return this.location;
        }

        public String getMessage() {
            return String.format(this.format, this.parameters);
        }

        public List<Object> getParameters() {
            return List.of(this.parameters);
        }

        public String toString() {
            return this.location.toString() + "\n\n" + this.getMessage();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ErrorDetails)) {
                return false;
            }
            ErrorDetails other = (ErrorDetails)o;
            return this.code.equals((Object)other.code) && this.location.equals(other.location) && this.format.equals(other.format) && Arrays.equals(this.parameters, other.parameters);
        }
    }
}

