/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class TheoremNode
extends LevelNode {
    ModuleNode module;
    LevelNode theoremExprOrAssumeProve;
    private ThmOrAssumpDefNode def;
    boolean suffices = false;
    ProofNode proof;
    int levelChecked = 0;

    public TheoremNode(TreeNode stn, LevelNode theorem, ModuleNode mn, ProofNode pf, ThmOrAssumpDefNode opd) {
        super(12, stn);
        this.theoremExprOrAssumeProve = theorem;
        this.module = mn;
        this.def = opd;
        this.proof = pf;
        if (opd != null) {
            opd.thmOrAssump = this;
        }
        if (this.def != null) assert (this.def.getBody() == this.theoremExprOrAssumeProve);
    }

    public final LevelNode getTheorem() {
        return this.theoremExprOrAssumeProve;
    }

    public final ThmOrAssumpDefNode getDef() {
        return this.def;
    }

    public final boolean isSuffices() {
        return this.suffices;
    }

    public final ProofNode getProof() {
        return this.proof;
    }

    public final UniqueString getName() {
        if (this.def == null) {
            return null;
        }
        return this.def.getName();
    }

    @Override
    public final boolean levelCheck(int iter, Errors errors) {
        LevelNode[] sub;
        if (this.levelChecked >= iter) {
            return true;
        }
        this.levelChecked = iter;
        if (this.proof != null) {
            sub = new LevelNode[2];
            sub[1] = this.proof;
        } else {
            sub = new LevelNode[]{this.def != null ? this.def : this.theoremExprOrAssumeProve};
        }
        boolean retVal = this.levelCheckSubnodes(iter, sub, errors);
        if (this.theoremExprOrAssumeProve == null) {
            return retVal;
        }
        OpApplNode oan = null;
        SymbolNode oanOp = null;
        if (this.theoremExprOrAssumeProve instanceof OpApplNode) {
            oan = (OpApplNode)this.theoremExprOrAssumeProve;
            oanOp = oan.operator;
        }
        if (oanOp != null && oanOp.getName() == OP_pick && oan.ranges != null && this.theoremExprOrAssumeProve.level == 3) {
            for (int i = 0; i < oan.ranges.length; ++i) {
                if (oan.ranges[i].getLevel() == 0) continue;
                errors.addError(ErrorCode.QUANTIFIED_TEMPORAL_PICK_FORMULA_WITH_NON_CONSTANT_BOUND, oan.ranges[i].stn.getLocation(), "Non-constant bound of temporal PICK.");
            }
        }
        if (this.theoremExprOrAssumeProve.level == 3) {
            TheoremNode.LevelCheckTemporal(this.proof, errors);
        }
        return retVal;
    }

    private static final void LevelCheckTemporal(ProofNode pn, Errors errors) {
        if (pn == null || pn.getKind() != 34) {
            return;
        }
        NonLeafProofNode pnode = (NonLeafProofNode)pn;
        for (int i = 0; i < pnode.getSteps().length; ++i) {
            LevelNode node = pnode.getSteps()[i];
            OpApplNode oanode = null;
            TheoremNode tnode = null;
            if (node.getKind() == 12) {
                tnode = (TheoremNode)node;
                if (tnode.theoremExprOrAssumeProve instanceof OpApplNode) {
                    oanode = (OpApplNode)tnode.theoremExprOrAssumeProve;
                }
            }
            if (oanode == null) continue;
            UniqueString name = oanode.operator.getName();
            if ((name == OP_take || name == OP_witness || name == OP_have) && oanode.getLevel() != 0) {
                errors.addError(ErrorCode.TEMPORAL_PROOF_GOAL_WITH_NON_CONSTANT_TAKE_WITNESS_HAVE, oanode.stn.getLocation(), "Non-constant TAKE, WITNESS, or HAVE for temporal goal.");
                continue;
            }
            if (name == OP_pfcase) {
                if (oanode.getLevel() != 0) {
                    errors.addError(ErrorCode.TEMPORAL_PROOF_GOAL_WITH_NON_CONSTANT_CASE, oanode.stn.getLocation(), "Non-constant CASE for temporal goal.");
                }
                TheoremNode.LevelCheckTemporal(tnode.getProof(), errors);
                continue;
            }
            if (name != OP_qed) continue;
            TheoremNode.LevelCheckTemporal(tnode.getProof(), errors);
        }
    }

    @Override
    public final String levelDataToString() {
        return "Level: " + this.getLevel() + "\nLevelParameters: " + String.valueOf(this.getLevelParams()) + "\nLevelConstraints: " + String.valueOf(this.getLevelConstraints()) + "\nArgLevelConstraints: " + String.valueOf(this.getArgLevelConstraints()) + "\nArgLevelParams: " + String.valueOf(this.getArgLevelParams()) + "\n";
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String res = "\n*TheoremNode " + super.toString(depth, errors) + (this.theoremExprOrAssumeProve != null ? Strings.indent(2, this.theoremExprOrAssumeProve.toString(depth - 1, errors)) : "");
        if (this.def != null) {
            res = res + Strings.indent(2, "\n def: " + Strings.indent(2, this.def.toString(depth - 1, errors)));
        }
        if (this.suffices) {
            res = res + Strings.indent(2, "\n SUFFICES step");
        }
        if (this.proof != null) {
            res = res + Strings.indent(2, "\n proof: " + Strings.indent(2, this.proof.toString(depth - 1, errors)));
        }
        return res;
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.proof == null) {
            return new SemanticNode[]{this.theoremExprOrAssumeProve};
        }
        return new SemanticNode[]{this.theoremExprOrAssumeProve, this.proof};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.theoremExprOrAssumeProve != null) {
            this.theoremExprOrAssumeProve.walkGraph(semNodesTable, visitor);
        }
        if (this.proof != null) {
            this.proof.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    public Element exportDefinition(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        if (!context.isTop_level_entry()) {
            throw new IllegalArgumentException("Exporting theorem ref " + this.getNodeRef() + " twice!");
        }
        context.resetTop_level_entry();
        try {
            Element e = this.getLevelElement(doc, context, filter);
            try {
                Element l = this.appendText(doc, "level", Integer.toString(this.getLevel()));
                e.insertBefore(l, e.getFirstChild());
            }
            catch (RuntimeException l) {
                // empty catch block
            }
            try {
                Element loc = this.getLocationElement(doc);
                e.insertBefore(loc, e.getFirstChild());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return e;
        }
        catch (RuntimeException ee) {
            System.err.println("failed for node.toString(): " + this.toString() + "\n with error ");
            ee.printStackTrace();
            throw ee;
        }
    }

    protected String getNodeRef() {
        return "TheoremNodeRef";
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("TheoremNode");
        Element n = doc.createElement("body");
        if (this.def != null) {
            Element d = doc.createElement("definition");
            d.appendChild(this.def.export(doc, context, filter));
            e.appendChild(d);
            assert (this.def.getBody() == this.getTheorem());
        }
        n.appendChild(this.getTheorem().export(doc, context, filter));
        e.appendChild(n);
        if (this.getProof() != null) {
            e.appendChild(this.getProof().export(doc, context, filter));
        }
        if (this.isSuffices()) {
            e.appendChild(doc.createElement("suffices"));
        }
        return e;
    }

    @Override
    public Element export(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        context.put(this, doc, filter);
        Element e = doc.createElement(this.getNodeRef());
        e.appendChild(this.appendText(doc, "UID", Integer.toString(this.myUID)));
        return e;
    }
}

