/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.Serializable;
import tlc2.tool.ToolGlobals;
import util.UniqueString;

public class Defns
implements ToolGlobals,
Serializable {
    private int defnIdx;
    private Object[] table;

    public Defns(int initialSize) {
        this.defnIdx = initialSize;
        this.table = new Object[this.defnIdx + 32];
    }

    public Defns() {
        this.table = new Object[this.defnIdx + 32];
    }

    Defns(Defns other) {
        this.defnIdx = other.defnIdx;
        this.table = new Object[other.table.length];
        System.arraycopy(other.table, 0, this.table, 0, other.table.length);
    }

    public Object get(UniqueString key) {
        int loc = key.getDefnLoc();
        if (loc < 0 || loc >= this.table.length) {
            return null;
        }
        return this.table[loc];
    }

    public Object get(String key) {
        UniqueString var = UniqueString.uniqueStringOf(key);
        return this.get(var);
    }

    public void put(UniqueString key, Object val) {
        int loc = key.getDefnLoc();
        if (loc == -1) {
            loc = this.defnIdx++;
            key.setLoc(loc);
        }
        if (loc >= this.table.length) {
            int oldSize = this.table.length;
            int newSize = Math.max(2 * oldSize, loc + 1);
            Object[] old = this.table;
            this.table = new Object[newSize];
            System.arraycopy(old, 0, this.table, 0, old.length);
        }
        this.table[loc] = val;
    }

    public void put(String key, Object val) {
        this.put(UniqueString.uniqueStringOf(key), val);
    }

    public void setDefnCount(int index) {
        this.defnIdx = index;
    }

    public Defns snapshot() {
        return new Defns(this);
    }
}

