/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import tlc2.tool.TLCTrace;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.fp.MultiFPSetConfiguration;
import util.Assert;

public class MultiFPSet
extends FPSet {
    private static final int MEM_DEFAULT = -1;
    public static final int MAX_FPBITS = 30;
    public static final int MIN_FPBITS = 0;
    protected final List<FPSet> sets;
    protected int fpbits;

    public MultiFPSet(FPSetConfiguration fpSetConfiguration) throws RemoteException {
        super(fpSetConfiguration);
        int bits = fpSetConfiguration.getFpBits();
        long fpMemSize = fpSetConfiguration.getMemoryInBytes();
        Assert.check(bits > 0 && bits <= 30, "Illegal number of FPSets found.");
        if (fpMemSize == -1L) {
            fpMemSize = 26214L;
        }
        this.sets = this.getNestedFPSets(fpSetConfiguration);
        this.fpbits = 64 - bits;
    }

    protected List<FPSet> getNestedFPSets(FPSetConfiguration fpSetConfiguration) throws RemoteException {
        ArrayList<FPSet> s = new ArrayList<FPSet>(fpSetConfiguration.getMultiFPSetCnt());
        for (int i = 0; i < fpSetConfiguration.getMultiFPSetCnt(); ++i) {
            s.add(FPSetFactory.getFPSet(new MultiFPSetConfiguration(fpSetConfiguration)));
        }
        return s;
    }

    @Override
    public final FPSet init(int numThreads, String metadir, String filename) throws IOException {
        IntStream.range(0, this.sets.size()).parallel().forEach(i -> {
            try {
                this.sets.get(i).init(numThreads, metadir, filename + "_" + i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return this;
    }

    @Override
    public void incWorkers(int num) {
        this.sets.stream().forEach(s -> s.incWorkers(num));
    }

    @Override
    public final long size() {
        return this.sets.parallelStream().mapToLong(FPSet::size).sum();
    }

    protected FPSet getFPSet(long fp) {
        int idx = (int)(fp >>> this.fpbits);
        return this.sets.get(idx);
    }

    @Override
    public final boolean put(long fp) throws IOException {
        return this.getFPSet(fp).put(fp);
    }

    @Override
    public final boolean contains(long fp) throws IOException {
        return this.getFPSet(fp).contains(fp);
    }

    @Override
    public final void close() {
        for (FPSet fpSet : this.sets) {
            fpSet.close();
        }
    }

    @Override
    public void unexportObject(boolean force) {
        for (FPSet fpSet : this.sets) {
            fpSet.unexportObject(force);
        }
    }

    @Override
    public final long checkFPs() throws IOException {
        return this.sets.parallelStream().mapToLong(s -> {
            try {
                return s.checkFPs();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).min().orElse(Long.MAX_VALUE);
    }

    @Override
    public boolean checkInvariant() throws IOException {
        return this.sets.parallelStream().allMatch(s -> {
            try {
                return s.checkInvariant();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        super.exit(cleanup);
        for (FPSet fpSet : this.sets) {
            fpSet.exit(cleanup);
        }
    }

    @Override
    public final void beginChkpt() throws IOException {
        for (FPSet fpSet : this.sets) {
            fpSet.beginChkpt();
        }
    }

    @Override
    public final void commitChkpt() throws IOException {
        for (FPSet fpSet : this.sets) {
            fpSet.commitChkpt();
        }
    }

    @Override
    public final void recover(TLCTrace trace) throws IOException {
        TLCTrace.Enumerator elements = trace.elements();
        while (elements.nextPos() != -1L) {
            long fp = elements.nextFP();
            this.getFPSet(fp).recoverFP(fp);
        }
        elements.close();
    }

    @Override
    public final void recoverFP(long fp) throws IOException {
        Assert.check(!this.put(fp), 2133);
    }

    @Override
    public final void beginChkpt(String filename) throws IOException {
        IntStream.range(0, this.sets.size()).parallel().forEach(i -> {
            try {
                this.sets.get(i).beginChkpt(filename + "_" + i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public final void commitChkpt(String filename) throws IOException {
        IntStream.range(0, this.sets.size()).parallel().forEach(i -> {
            try {
                this.sets.get(i).commitChkpt(filename + "_" + i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public final void recover(String filename) throws IOException {
        IntStream.range(0, this.sets.size()).parallel().forEach(i -> {
            try {
                this.sets.get(i).recover(filename + "_" + i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public FPSet[] getFPSets() {
        return this.sets.toArray(new FPSet[this.sets.size()]);
    }
}

