/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.TestMPRecorder;
import tlc2.output.EC;
import tlc2.output.MP;
import tlc2.tool.CommonTestCase;
import tlc2.tool.ModelChecker;
import tlc2.tool.liveness.TTraceModelCheckerTestCase;
import tlc2.util.IStateWriter;
import util.FileUtil;
import util.FilenameToStream;
import util.SimpleFilenameToStream;
import util.ToolIO;

public abstract class ModelCheckerTestCase
extends CommonTestCase {
    protected String path = "";
    protected String spec;
    protected String[] extraArguments = new String[0];
    protected TLC tlc;
    protected int actualExitStatus = -1;
    protected int expectedExitStatus = 0;

    public ModelCheckerTestCase(String spec) {
        this(spec, 0);
    }

    public ModelCheckerTestCase(String spec, int exitStatus) {
        this(spec, "", exitStatus);
    }

    public ModelCheckerTestCase(String spec, String path) {
        this(spec, path, 0);
    }

    public ModelCheckerTestCase(String spec, String[] extraArguments) {
        this(spec, "", extraArguments, 0);
    }

    public ModelCheckerTestCase(String spec, String[] extraArguments, int exitStatus) {
        this(spec, "", extraArguments, exitStatus);
    }

    public ModelCheckerTestCase(String spec, String path, String[] extraArguments) {
        this(spec, path, extraArguments, 0);
    }

    public ModelCheckerTestCase(String spec, String path, String[] extraArguments, int exitStatus) {
        this(spec, path, exitStatus);
        this.extraArguments = extraArguments;
    }

    public ModelCheckerTestCase(String spec, String path, int exitStatus) {
        super(new TestMPRecorder());
        this.spec = spec;
        this.path = path;
        this.expectedExitStatus = exitStatus;
    }

    protected void beforeSetUp() {
    }

    @Before
    public void setUp() {
        this.beforeSetUp();
        System.setProperty(ModelChecker.class.getName() + ".vetoCleanup", "true");
        try {
            ToolIO.setUserDir(BASE_PATH + this.path);
            MP.setRecorder(this.recorder);
            TLCGlobals.livenessThreshold = this.getLivenessThreshold();
            this.tlc = new TLC();
            this.tlc.setResolver(this.getResolver());
            ArrayList<Object> args = new ArrayList<Object>(6);
            args.add("-metadir");
            args.add(this.getMetaDir());
            if (!this.checkDeadLock()) {
                args.add("-deadlock");
            }
            if (this.getNumberOfThreads() == 1 && this.runWithDebugger()) {
                args.add("-debugger");
                args.add(String.format("nosuspend,port=%s,nohalt", 1025 + new Random().nextInt(64540)));
            }
            if (this.noGenerateSpec()) {
                args.add("-noGenerateSpecTE");
            } else {
                args.add("-generateSpecTE");
                args.add("-teSpecOutDir");
                args.add(this.getTESpecOutDir());
            }
            if (this.noRandomFPandSeed()) {
                args.add("-fp");
                args.add("0");
                args.add("-seed");
                args.add("1");
            }
            if (this.doCoverage()) {
                args.add("-coverage");
                args.add("1");
            }
            args.add("-workers");
            args.add(Integer.toString(this.getNumberOfThreads()));
            args.add("-checkpoint");
            args.add(Integer.toString(this.doCheckpoint()));
            if (this.doDump()) {
                args.add("-dump");
                args.add("dot");
                args.add("${metadir}" + FileUtil.separator + this.getClass().getCanonicalName() + ".dot");
            }
            if (this.doDumpTrace()) {
                args.add("-dumpTrace");
                args.add("json");
                args.add("states" + FileUtil.separator + this.getClass().getCanonicalName() + ".json");
            }
            args.addAll(Arrays.asList(this.extraArguments));
            args.add(this.spec);
            this.tlc.handleParameters(args.toArray(new String[args.size()]));
            this.tlc.setStateWriter(this.getStateWriter(this.tlc.getStateWriter()));
            int errorCode = this.tlc.process();
            this.actualExitStatus = EC.ExitStatus.errorConstantToExitStatus(errorCode);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected IStateWriter getStateWriter(IStateWriter sw) {
        return sw;
    }

    protected String getMetaDir() {
        return "states" + FileUtil.separator + this.getClass().getCanonicalName();
    }

    protected boolean noRandomFPandSeed() {
        return true;
    }

    protected boolean runWithDebugger() {
        return true;
    }

    protected double getLivenessThreshold() {
        return Double.MAX_VALUE;
    }

    protected FilenameToStream getResolver() {
        return new SimpleFilenameToStream();
    }

    protected boolean noGenerateSpec() {
        return false;
    }

    protected String getTESpecOutDir() {
        return TTraceModelCheckerTestCase.getPath(this.getClass());
    }

    protected void beforeTearDown() {
    }

    @After
    public void tearDown() {
        this.beforeTearDown();
        this.assertExitStatus();
    }

    protected void assertExitStatus() {
        Assert.assertEquals((long)this.expectedExitStatus, (long)this.actualExitStatus);
    }

    protected boolean doCoverage() {
        return true;
    }

    protected boolean checkDeadLock() {
        return false;
    }

    protected boolean doDump() {
        return true;
    }

    protected boolean doDumpTrace() {
        return true;
    }

    protected int doCheckpoint() {
        return 0;
    }

    protected int getNumberOfThreads() {
        return 1;
    }

    protected void setExitStatus(int exitStatus) {
        this.expectedExitStatus = exitStatus;
    }

    protected Object getField(Class<?> targetClass, String fieldName, Object instance) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

