/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class BufferedRandomAccessFile
extends RandomAccessFile {
    static final int LogBuffSz = 13;
    public static final int BuffSz = 8192;
    static final int BuffMask = -8192;
    private boolean dirty;
    private boolean closed;
    private long length;
    private long curr;
    private long lo;
    private final byte[] buff;
    private long diskPos;
    private long mark;
    private static final Object mu = new Object();
    private static byte[][] availBuffs = new byte[100][];
    private static int numAvailBuffs = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedRandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
        Object object = mu;
        synchronized (object) {
            this.buff = numAvailBuffs > 0 ? availBuffs[--numAvailBuffs] : new byte[8192];
        }
        this.closed = false;
        this.init();
    }

    @Deprecated
    public BufferedRandomAccessFile(String name, String mode) throws IOException {
        this(new File(name), mode);
    }

    private void init() throws IOException {
        this.dirty = false;
        this.lo = 0L;
        this.curr = 0L;
        this.diskPos = 0L;
        this.length = super.length();
        this.fillBuffer();
    }

    private void requireOpenFile() throws IOException {
        if (this.closed) {
            throw new IOException("File handle closed");
        }
    }

    public void invalidateBufferedData() throws IOException {
        this.flush();
        this.fillBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            try {
                if (this.closed) break block7;
                this.flush();
                Object object = mu;
                synchronized (object) {
                    if (numAvailBuffs >= availBuffs.length) {
                        byte[][] newBuffs = new byte[numAvailBuffs + 10][];
                        System.arraycopy(availBuffs, 0, newBuffs, 0, numAvailBuffs);
                        availBuffs = newBuffs;
                    }
                    BufferedRandomAccessFile.availBuffs[BufferedRandomAccessFile.numAvailBuffs++] = this.buff;
                }
            }
            finally {
                this.closed = true;
                super.close();
            }
        }
    }

    public void flush() throws IOException {
        this.requireOpenFile();
        this.flushBuffer();
    }

    private boolean flushBuffer() throws IOException {
        if (this.dirty) {
            int len = (int)Math.min(this.length - this.lo, 8192L);
            if (len > 0) {
                assert (super.getFilePointer() == this.diskPos);
                if (this.diskPos != this.lo) {
                    super.seek(this.lo);
                }
                super.write(this.buff, 0, len);
                this.diskPos = this.lo + (long)len;
            }
            this.dirty = false;
            return true;
        }
        return false;
    }

    private void fillBuffer() throws IOException {
        int n;
        assert (!this.dirty && this.diskPos == super.getFilePointer());
        if (this.diskPos != this.lo) {
            super.seek(this.lo);
            this.diskPos = this.lo;
        }
        int cnt = 0;
        for (int rem = this.buff.length; rem > 0 && (n = super.read(this.buff, cnt, rem)) >= 0; rem -= n) {
            cnt += n;
        }
        this.diskPos += (long)cnt;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.requireOpenFile();
        this.seeek(pos);
    }

    public boolean seeek(long pos) throws IOException {
        this.curr = pos;
        if (pos < this.lo || pos >= this.lo + 8192L) {
            this.flushBuffer();
            this.lo = pos & 0xFFFFFFFFFFFFE000L;
            this.fillBuffer();
            return true;
        }
        return false;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.requireOpenFile();
        return this.curr;
    }

    @Override
    public long length() throws IOException {
        this.requireOpenFile();
        return this.length;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.requireOpenFile();
        super.setLength(newLength);
        this.length = newLength;
        this.diskPos = super.getFilePointer();
        if (this.curr > newLength) {
            this.seek(newLength);
        }
    }

    private void restoreInvariantsAfterIncreasingCurr() throws IOException {
        if (this.curr >= this.lo + 8192L) {
            this.seeek(this.curr);
        }
    }

    @Override
    public int read() throws IOException {
        this.requireOpenFile();
        if (this.curr >= this.length) {
            return -1;
        }
        int result = Byte.toUnsignedInt(this.buff[(int)(this.curr - this.lo)]);
        ++this.curr;
        this.restoreInvariantsAfterIncreasingCurr();
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.requireOpenFile();
        if (len == 0) {
            return 0;
        }
        long numReadableWithoutSeeking = Math.min(this.lo + 8192L, this.length) - this.curr;
        if (numReadableWithoutSeeking <= 0L) {
            return -1;
        }
        int numToRead = Math.min(len, (int)numReadableWithoutSeeking);
        int buffOff = (int)(this.curr - this.lo);
        System.arraycopy(this.buff, buffOff, b, off, numToRead);
        this.curr += (long)numToRead;
        this.restoreInvariantsAfterIncreasingCurr();
        return numToRead;
    }

    public final int readShortNat() throws IOException {
        int res = this.readByte();
        if (res >= 0) {
            return res;
        }
        res = res << 16 | this.readByte() & 0xFF;
        return -res;
    }

    public final int readNat() throws IOException {
        int res = this.readShort();
        if (res >= 0) {
            return res;
        }
        res = res << 16 | this.readShort() & 0xFFFF;
        return -res;
    }

    public final long readLongNat() throws IOException {
        long res = this.readInt();
        if (res >= 0L) {
            return res;
        }
        res = res << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        return -res;
    }

    @Override
    public void write(int b) throws IOException {
        this.requireOpenFile();
        this.buff[(int)(this.curr - this.lo)] = (byte)b;
        ++this.curr;
        this.dirty = true;
        this.length = Math.max(this.length, this.curr);
        this.restoreInvariantsAfterIncreasingCurr();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.requireOpenFile();
        assert (super.getFilePointer() == this.diskPos);
        while (len > 0) {
            int n = this.writeAtMost(b, off, len);
            off += n;
            len -= n;
            assert (super.getFilePointer() == this.diskPos);
        }
    }

    public final void writeShortNat(int x) throws IOException {
        if (x <= 127) {
            this.writeByte((short)x);
        } else {
            this.writeShort(-x);
        }
    }

    public final void writeNat(int x) throws IOException {
        if (x <= Short.MAX_VALUE) {
            this.writeShort((short)x);
        } else {
            this.writeInt(-x);
        }
    }

    public final void writeLongNat(long x) throws IOException {
        if (x <= Integer.MAX_VALUE) {
            this.writeInt((int)x);
        } else {
            this.writeLong(-x);
        }
    }

    private int writeAtMost(byte[] b, int off, int len) throws IOException {
        int numWriteableWithoutSeeking = Math.min(len, (int)(this.lo + 8192L - this.curr));
        assert (numWriteableWithoutSeeking > 0);
        int buffOff = (int)(this.curr - this.lo);
        System.arraycopy(b, off, this.buff, buffOff, numWriteableWithoutSeeking);
        this.dirty = true;
        this.curr += (long)numWriteableWithoutSeeking;
        this.length = Math.max(this.length, this.curr);
        this.restoreInvariantsAfterIncreasingCurr();
        return numWriteableWithoutSeeking;
    }

    public void reset() throws IOException {
        this.setLength(0L);
        this.init();
    }

    public long getMark() {
        return this.mark;
    }

    public long mark() {
        long oldMark = this.mark;
        this.mark = this.curr;
        return oldMark;
    }

    public void seekAndMark(long pos) throws IOException {
        this.mark = pos;
        this.seek(pos);
    }
}

