/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import tla2sany.semantic.FormalParamNode;
import tlc2.value.IFcnParams;
import tlc2.value.IValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import util.Assert;

public class FcnParams
implements IFcnParams {
    public FormalParamNode[][] formals;
    public boolean[] isTuples;
    public Value[] domains;
    public int argLen;

    public FcnParams(FormalParamNode[][] formals, boolean[] isTuples, Value[] domains) {
        this.formals = formals;
        this.isTuples = isTuples;
        this.domains = domains;
        this.argLen = 0;
        for (int i = 0; i < formals.length; ++i) {
            this.argLen += isTuples[i] ? 1 : formals[i].length;
        }
    }

    @Override
    public final int length() {
        return this.argLen;
    }

    public final int size() {
        long sz = 1L;
        for (int i = 0; i < this.domains.length; ++i) {
            int sz1 = this.domains[i].size();
            if (!this.isTuples[i]) {
                int len1 = this.formals[i].length;
                for (int j = 1; j < len1; ++j) {
                    if ((sz *= (long)sz1) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
                    Assert.fail(2178, "the number of elements in:\n" + this.toString());
                }
            }
            if ((sz *= (long)sz1) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
            Assert.fail(2178, "the number of elements in:\n" + this.toString());
        }
        return (int)sz;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.domains.length != 0) {
            FormalParamNode[] ids = this.formals[0];
            if (this.isTuples[0]) {
                sb.append("<<");
                if (ids.length != 0) {
                    sb.append(ids[0].getName());
                }
                for (int j = 1; j < ids.length; ++j) {
                    sb.append(", " + String.valueOf(ids[j].getName()));
                }
                sb.append(">>");
            } else {
                sb.append(ids[0].getName());
            }
            sb.append(" \\in " + this.domains[0].toString());
        }
        for (int i = 1; i < this.domains.length; ++i) {
            sb.append(", ");
            FormalParamNode[] ids = this.formals[i];
            if (this.isTuples[i]) {
                sb.append("<<");
                if (ids.length != 0) {
                    sb.append(ids[0].getName());
                }
                for (int j = 1; j < ids.length; ++j) {
                    sb.append(", " + String.valueOf(ids[j].getName()));
                }
                sb.append(">>");
            } else {
                sb.append(ids[0].getName());
            }
            sb.append(" \\in " + this.domains[i].toString());
        }
        return sb.toString();
    }

    public final ValueEnumeration elements() {
        if (this.argLen == 1) {
            if (!(this.domains[0] instanceof Enumerable)) {
                Assert.fail("The domains of formal parameters must be enumerable.");
            }
            return ((Enumerable)((Object)this.domains[0])).elements();
        }
        return new Enumerator();
    }

    @Override
    public FormalParamNode[][] getFormals() {
        return this.formals;
    }

    @Override
    public IValue[] getDomains() {
        return this.domains;
    }

    @Override
    public boolean[] isTuples() {
        return this.isTuples;
    }

    final class Enumerator
    implements ValueEnumeration {
        private ValueEnumeration[] enums;
        private Value[] currentElems;

        public Enumerator() {
            this.enums = new ValueEnumeration[FcnParams.this.argLen];
            this.currentElems = new Value[FcnParams.this.argLen];
            int idx = 0;
            for (int i = 0; i < FcnParams.this.domains.length; ++i) {
                if (!(FcnParams.this.domains[i] instanceof Enumerable)) {
                    Assert.fail("The domains of the parameters must be enumerable.");
                }
                if (FcnParams.this.isTuples[i]) {
                    this.enums[idx] = ((Enumerable)((Object)FcnParams.this.domains[i])).elements();
                    this.currentElems[idx] = this.enums[i].nextElement();
                    if (this.currentElems[idx] == null) {
                        this.enums = null;
                        this.currentElems = null;
                        return;
                    }
                    ++idx;
                    continue;
                }
                int maxIdx = idx + FcnParams.this.formals[i].length;
                while (idx < maxIdx) {
                    this.enums[idx] = ((Enumerable)((Object)FcnParams.this.domains[i])).elements();
                    this.currentElems[idx] = this.enums[idx].nextElement();
                    if (this.currentElems[idx] == null) {
                        this.enums = null;
                        this.currentElems = null;
                        return;
                    }
                    ++idx;
                }
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                for (int i = 0; i < this.enums.length; ++i) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                }
            }
        }

        @Override
        public final Value nextElement() {
            int i;
            if (this.enums == null) {
                return null;
            }
            Value[] elems = new Value[FcnParams.this.argLen];
            for (i = 0; i < FcnParams.this.argLen; ++i) {
                elems[i] = this.currentElems[i];
            }
            for (i = 0; i < FcnParams.this.argLen; ++i) {
                this.currentElems[i] = this.enums[i].nextElement();
                if (this.currentElems[i] != null) break;
                if (i == FcnParams.this.argLen - 1) {
                    this.enums = null;
                    this.currentElems = null;
                    break;
                }
                this.enums[i].reset();
                this.currentElems[i] = this.enums[i].nextElement();
            }
            return new TupleValue(elems);
        }
    }
}

