/*
 * Decompiled with CFR 0.152.
 */
package util;

import tla2sany.semantic.SemanticNode;
import tlc2.output.MP;
import tlc2.tool.StatefulRuntimeException;
import tlc2.util.Context;

public class Assert {
    public static void fail(String reason) throws RuntimeException {
        throw new TLCRuntimeException(reason);
    }

    public static void fail(String reason, SemanticNode expr) throws RuntimeException {
        if (expr != null) {
            throw new TLCDetailedRuntimeException(reason, expr, Context.Empty);
        }
        Assert.fail(reason);
    }

    public static void fail(String reason, SemanticNode expr, Context ctxt) throws RuntimeException {
        if (expr != null) {
            throw new TLCDetailedRuntimeException(reason, expr, ctxt);
        }
        Assert.fail(reason);
    }

    public static void fail(int errorCode, String[] parameters) {
        throw new TLCRuntimeException(errorCode, parameters, MP.getMessage(errorCode, parameters));
    }

    public static void fail(int errorCode, String[] parameters, SemanticNode expr) {
        if (expr != null) {
            throw new TLCDetailedRuntimeException(errorCode, parameters, MP.getMessage(errorCode, parameters), expr, Context.Empty);
        }
        Assert.fail(errorCode, parameters);
    }

    public static void fail(int errorCode, String[] parameters, SemanticNode expr, Context ctxt) {
        if (expr != null) {
            throw new TLCDetailedRuntimeException(errorCode, parameters, MP.getMessage(errorCode, parameters), expr, ctxt);
        }
        Assert.fail(errorCode, parameters);
    }

    public static void fail(int errorCode, String parameter) {
        throw new TLCRuntimeException(errorCode, new String[]{parameter}, MP.getMessage(errorCode, parameter));
    }

    public static void fail(int errorCode, String parameter, SemanticNode expr, Context ctxt) {
        if (expr != null) {
            throw new TLCDetailedRuntimeException(errorCode, new String[]{parameter}, MP.getMessage(errorCode, parameter), expr, ctxt);
        }
        Assert.fail(errorCode, parameter);
    }

    public static void fail(int errorCode, Throwable cause) {
        throw new TLCRuntimeException(errorCode, MP.getMessage(errorCode, cause.getMessage()), cause);
    }

    public static void fail(int errorCode) {
        throw new TLCRuntimeException(errorCode, MP.getMessage(errorCode));
    }

    public static void check(boolean condition, String reason, SemanticNode expr, Context ctxt) throws RuntimeException {
        if (!condition) {
            if (expr == null) {
                Assert.fail(reason);
            } else {
                throw new TLCDetailedRuntimeException(reason, expr, ctxt);
            }
        }
    }

    public static void check(boolean condition, int errorCode, String[] parameters) throws RuntimeException {
        if (!condition) {
            throw new TLCRuntimeException(errorCode, parameters, MP.getMessage(errorCode, parameters));
        }
    }

    public static void check(boolean condition, int errorCode, String parameter) throws RuntimeException {
        if (!condition) {
            throw new TLCRuntimeException(errorCode, new String[]{parameter}, MP.getMessage(errorCode, parameter));
        }
    }

    public static void check(boolean condition, int errorCode) throws RuntimeException {
        if (!condition) {
            throw new TLCRuntimeException(errorCode, MP.getMessage(errorCode));
        }
    }

    public static void check(boolean condition, String errorMsg) throws RuntimeException {
        if (!condition) {
            throw new TLCRuntimeException(errorMsg);
        }
    }

    public static class TLCRuntimeException
    extends StatefulRuntimeException {
        public final int errorCode;
        public String[] parameters = null;

        public TLCRuntimeException(String errorMsg) {
            super(errorMsg);
            this.errorCode = 1000;
        }

        public TLCRuntimeException(int errorCode, String message) {
            super(message);
            this.errorCode = errorCode;
        }

        public TLCRuntimeException(int errorCode, String message, Throwable cause) {
            super(message, cause);
            this.errorCode = errorCode;
        }

        public TLCRuntimeException(int errorCode, String[] parameters, String message) {
            this(errorCode, message);
            this.parameters = parameters;
        }
    }

    public static class TLCDetailedRuntimeException
    extends TLCRuntimeException {
        public final SemanticNode expr;
        public final Context ctxt;

        public TLCDetailedRuntimeException(String errorMsg, SemanticNode expr, Context ctxt) {
            this(1000, errorMsg, expr, ctxt);
        }

        public TLCDetailedRuntimeException(int errorCode, String message, SemanticNode expr, Context ctxt) {
            super(errorCode, message);
            this.expr = expr;
            this.ctxt = ctxt;
        }

        public TLCDetailedRuntimeException(int errorCode, String[] parameters, String message, SemanticNode expr, Context ctxt) {
            super(errorCode, parameters, message);
            this.expr = expr;
            this.ctxt = ctxt;
        }
    }
}

