/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import util.IDataOutputStream;

public final class BufferedDataOutputStream
extends FilterOutputStream
implements IDataOutputStream {
    private byte[] buff;
    private int len;
    private byte[] temp;

    public BufferedDataOutputStream() {
        super(null);
        this.initFields();
    }

    public BufferedDataOutputStream(OutputStream os) {
        super(os);
        this.initFields();
    }

    public BufferedDataOutputStream(String name) throws IOException {
        this(new FileOutputStream(name));
    }

    public BufferedDataOutputStream(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    private void initFields() {
        this.buff = new byte[8192];
        this.len = 0;
        this.temp = new byte[8];
    }

    public void open(OutputStream os) throws IOException {
        this.out = os;
        this.len = 0;
    }

    public void open(String name) throws IOException {
        this.open(new FileOutputStream(name));
    }

    public void open(File file) throws IOException {
        this.open(new FileOutputStream(file));
    }

    @Override
    public final void flush() throws IOException {
        this.out.write(this.buff, 0, this.len);
        this.out.flush();
        this.len = 0;
    }

    @Override
    public final void close() throws IOException {
        this.flush();
        this.out.close();
        this.out = null;
    }

    public final void write(byte b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int n) throws IOException {
        while (n > 0) {
            int toCopy = Math.min(n, this.buff.length - this.len);
            System.arraycopy(b, off, this.buff, this.len, toCopy);
            this.len += toCopy;
            off += toCopy;
            n -= toCopy;
            if (this.buff.length != this.len) continue;
            this.out.write(this.buff, 0, this.len);
            this.len = 0;
        }
    }

    public final void writeByte(byte b) throws IOException {
        this.buff[this.len++] = b;
        if (this.buff.length == this.len) {
            this.out.write(this.buff, 0, this.len);
            this.len = 0;
        }
    }

    public final void writeBoolean(boolean bool) throws IOException {
        byte b = bool ? (byte)1 : 0;
        this.writeByte(b);
    }

    public final void writeShort(short s) throws IOException {
        this.temp[0] = (byte)(s >>> 8 & 0xFF);
        this.temp[1] = (byte)(s & 0xFF);
        this.write(this.temp, 0, 2);
    }

    @Override
    public final void writeInt(int i) throws IOException {
        this.temp[0] = (byte)(i >>> 24 & 0xFF);
        this.temp[1] = (byte)(i >>> 16 & 0xFF);
        this.temp[2] = (byte)(i >>> 8 & 0xFF);
        this.temp[3] = (byte)(i & 0xFF);
        this.write(this.temp, 0, 4);
    }

    public final void writeLong(long l) throws IOException {
        this.temp[0] = (byte)(l >>> 56 & 0xFFL);
        this.temp[1] = (byte)(l >>> 48 & 0xFFL);
        this.temp[2] = (byte)(l >>> 40 & 0xFFL);
        this.temp[3] = (byte)(l >>> 32 & 0xFFL);
        this.temp[4] = (byte)(l >>> 24 & 0xFFL);
        this.temp[5] = (byte)(l >>> 16 & 0xFFL);
        this.temp[6] = (byte)(l >>> 8 & 0xFFL);
        this.temp[7] = (byte)(l & 0xFFL);
        this.write(this.temp, 0, 8);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeString(String s) throws IOException {
        int toCopy;
        int off = 0;
        for (int n = s.length(); n > 0; n -= toCopy) {
            toCopy = Math.min(n, this.buff.length - this.len);
            s.getBytes(off, off + toCopy, this.buff, this.len);
            this.len += toCopy;
            off += toCopy;
            if (this.buff.length != this.len) continue;
            this.out.write(this.buff, 0, this.len);
            this.len = 0;
        }
    }

    public final void writeChars(char[] chars, int off, int n) throws IOException {
        int finOff = off + n;
        while (off < finOff) {
            int endOff = Math.min(finOff, off + this.buff.length - this.len);
            while (off < endOff) {
                this.buff[this.len++] = (byte)chars[off++];
            }
            if (this.buff.length != this.len) continue;
            this.out.write(this.buff, 0, this.len);
            this.len = 0;
        }
    }

    public final void writeAnyString(String s) throws IOException {
        if (s == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(s.length());
            this.writeString(s);
        }
    }

    public final void writeLine(String s) throws IOException {
        this.writeString(s);
        this.writeByte((byte)10);
    }
}

