/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer;
import org.lamport.tla.toolbox.editor.basic.pcal.PCalTranslator;
import org.lamport.tla.toolbox.ui.handler.SaveDirtyEditorAbstractHandler;

public class PCalTranslateModuleHandler
extends SaveDirtyEditorAbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.saveDirtyEditor(event)) {
            return null;
        }
        TLAEditor tlaEditor = PCalTranslateModuleHandler.getTLAEditor(this.activeEditor);
        if (tlaEditor == null || !tlaEditor.hasPlusCal()) {
            return null;
        }
        try {
            new PCalTranslator().translate(tlaEditor, HandlerUtil.getActiveShell((ExecutionEvent)event));
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static TLAEditor getTLAEditor(IEditorPart anEditor) {
        if (anEditor instanceof TLAEditorAndPDFViewer) {
            TLAEditorAndPDFViewer editor = (TLAEditorAndPDFViewer)anEditor;
            return editor.getTLAEditor();
        }
        if (anEditor instanceof TLAEditor) {
            return (TLAEditor)anEditor;
        }
        return null;
    }
}

