/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexEntry2;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IIndexSubpath;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;
import org.eclipse.osgi.util.NLS;

public class IndexFragmentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Map<String, String> locale2Response = new WeakHashMap<String, String>();
    private String startParameter;
    private String sizeParameter;
    private String entryParameter;
    private String modeParameter;
    private String showAllParameter;
    private int size;
    private int entry;
    private static final String NEXT = "next";
    private static final String PREVIOUS = "previous";
    private static final String SIZE = "size";
    private static final String MODE = "mode";
    private static final String ENTRY = "entry";
    private static final String SHOW_ALL = "showAll";
    private Collator collator = Collator.getInstance();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/xml; charset=UTF-8");
        resp.getWriter().write(this.processRequest(req, resp));
    }

    protected String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String locale = UrlUtil.getLocale(req, resp);
        this.startParameter = req.getParameter("start");
        if (this.startParameter != null) {
            this.startParameter = this.startParameter.toLowerCase();
        }
        this.size = 30;
        this.sizeParameter = req.getParameter(SIZE);
        if (this.sizeParameter != null) {
            try {
                this.size = Integer.parseInt(this.sizeParameter);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.entry = -1;
        this.entryParameter = req.getParameter(ENTRY);
        if (this.entryParameter != null) {
            try {
                this.entry = Integer.parseInt(this.entryParameter);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.modeParameter = req.getParameter(MODE);
        this.showAllParameter = req.getParameter(SHOW_ALL);
        if (this.showAllParameter != null) {
            new ActivitiesData(this.getServletContext(), req, resp);
        }
        req.setCharacterEncoding("UTF-8");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        AbstractHelpScope scope = RequestScope.getScope(req, resp, false);
        Serializer serializer = new Serializer(locale, scope);
        String response = serializer.generateIndexXml();
        locale2Response.put(locale, response);
        return response;
    }

    private class Serializer {
        private IIndex index;
        private StringBuilder buf;
        private int count = 0;
        private String locale;
        private List<Integer> entryList;
        private IIndexEntry[] entries;
        private boolean enablePrevious = true;
        private boolean enableNext = true;
        private AbstractHelpScope scope;

        public Serializer(String locale, AbstractHelpScope scope) {
            this.locale = locale;
            this.scope = scope;
            this.index = HelpPlugin.getIndexManager().getIndex(locale);
            this.buf = new StringBuilder();
        }

        private String generateIndexXml() {
            this.entries = this.index.getEntries();
            if (this.entries.length == 0) {
                this.generateEmptyIndexMessage();
            } else {
                this.entryList = new ArrayList<Integer>();
                int nextEntry = this.findFirstEntry(this.entries);
                if (IndexFragmentServlet.PREVIOUS.equals(IndexFragmentServlet.this.modeParameter)) {
                    remaining = this.getPreviousEntries(nextEntry, IndexFragmentServlet.this.size);
                    this.getNextEntries(nextEntry, remaining);
                } else {
                    remaining = this.getNextEntries(nextEntry, IndexFragmentServlet.this.size);
                    if (remaining == IndexFragmentServlet.this.size) {
                        IndexFragmentServlet.this.size = 1;
                        this.getPreviousEntries(nextEntry, 1);
                    }
                }
                for (Integer entryId : this.entryList) {
                    this.generateEntry(this.entries[entryId], 0, "e" + entryId);
                }
            }
            String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tree_data enableNext = \"" + Boolean.toString(this.enableNext) + "\" enablePrevious = \"" + Boolean.toString(this.enablePrevious) + "\">\n";
            this.buf.append("</tree_data>\n");
            return header + this.buf.toString();
        }

        private int getCategory(String keyword) {
            if (keyword != null && keyword.length() > 0) {
                char c = keyword.charAt(0);
                if (Character.isDigit(c)) {
                    return 2;
                }
                if (Character.isLetter(c)) {
                    return 3;
                }
                return 1;
            }
            return 4;
        }

        private int compare(String left, String right) {
            int catRight;
            int catLeft = this.getCategory(left);
            if (catLeft != (catRight = this.getCategory(right))) {
                return catLeft - catRight;
            }
            return IndexFragmentServlet.this.collator.compare(left, right);
        }

        private int findFirstEntry(IIndexEntry[] entries) {
            if (IndexFragmentServlet.NEXT.equals(IndexFragmentServlet.this.modeParameter)) {
                if (IndexFragmentServlet.this.entry >= entries.length - 1) {
                    return entries.length - 1;
                }
                return IndexFragmentServlet.this.entry + 1;
            }
            if (IndexFragmentServlet.PREVIOUS.equals(IndexFragmentServlet.this.modeParameter)) {
                if (IndexFragmentServlet.this.entry <= 0) {
                    return 0;
                }
                return IndexFragmentServlet.this.entry - 1;
            }
            if (IndexFragmentServlet.this.startParameter == null) {
                return 0;
            }
            int nextEntry = 0;
            while (nextEntry < entries.length) {
                String keyword = entries[nextEntry].getKeyword().toLowerCase();
                if (keyword != null && this.compare(IndexFragmentServlet.this.startParameter, keyword) <= 0) break;
                ++nextEntry;
            }
            return nextEntry;
        }

        private int getNextEntries(int nextEntry, int remaining) {
            while (nextEntry < this.entries.length) {
                int entrySize = this.enabledEntryCount(this.entries[nextEntry]);
                if (remaining != IndexFragmentServlet.this.size && remaining <= entrySize) break;
                this.entryList.add(nextEntry);
                this.setFlags(nextEntry);
                remaining -= entrySize;
                ++nextEntry;
            }
            return remaining;
        }

        private int getPreviousEntries(int nextEntry, int remaining) {
            --nextEntry;
            while (nextEntry >= 0) {
                int entrySize = this.enabledEntryCount(this.entries[nextEntry]);
                if (remaining != IndexFragmentServlet.this.size && remaining <= entrySize) break;
                this.entryList.add(0, nextEntry);
                this.setFlags(nextEntry);
                remaining -= entrySize;
                --nextEntry;
            }
            return remaining;
        }

        private void setFlags(int nextEntry) {
            if (nextEntry == 0) {
                this.enablePrevious = false;
            }
            if (nextEntry == this.entries.length - 1) {
                this.enableNext = false;
            }
        }

        /*
         * WARNING - void declaration
         */
        private int enabledEntryCount(IIndexEntry entry) {
            IIndexSee[] sees;
            IIndexSee[] iIndexSeeArray;
            if (!ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)this.scope)) {
                return 0;
            }
            if (entry.getKeyword() == null || entry.getKeyword().length() == 0) {
                return 0;
            }
            int count = 1;
            int topicCount = this.enabledTopicCount(entry);
            IIndexEntry[] subentries = entry.getSubentries();
            int subentryCount = 0;
            IIndexEntry[] iIndexEntryArray = subentries;
            int n = subentries.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexEntry subentrie = iIndexEntryArray[n2];
                count += this.enabledEntryCount(subentrie);
                ++n2;
            }
            int seeCount = 0;
            IIndexEntry iIndexEntry = entry;
            if (iIndexEntry instanceof IIndexEntry2) {
                void entry2;
                IIndexEntry2 iIndexEntry2 = (IIndexEntry2)iIndexEntry;
                IIndexEntry2 cfr_ignored_0 = (IIndexEntry2)iIndexEntry;
                iIndexSeeArray = entry2.getSees();
            } else {
                iIndexSeeArray = new IIndexSee[]{};
            }
            IIndexSee[] iIndexSeeArray2 = sees = iIndexSeeArray;
            int n3 = sees.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexSee see = iIndexSeeArray2[n4];
                if (ScopeUtils.showInTree((IIndexSee)see, (AbstractHelpScope)this.scope)) {
                    ++seeCount;
                }
                ++n4;
            }
            if (topicCount + subentryCount + seeCount > 1) {
                count += topicCount;
            }
            count += subentryCount;
            return count += seeCount;
        }

        private int enabledTopicCount(IIndexEntry entry) {
            ITopic[] topics;
            int topicCount = 0;
            ITopic[] iTopicArray = topics = entry.getTopics();
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                ITopic topic = iTopicArray[n2];
                if (this.scope.inScope(topic)) {
                    ++topicCount;
                }
                ++n2;
            }
            return topicCount;
        }

        private void generateEmptyIndexMessage() {
            this.buf.append("<node");
            this.buf.append("\n      title=\"" + XMLGenerator.xmlEscape(WebappResources.getString("IndexEmpty", UrlUtil.getLocale(this.locale))) + "\"");
            this.buf.append("\n      id=\"no_index\"");
            this.buf.append(">\n");
            this.buf.append("</node>\n");
            this.enableNext = false;
            this.enablePrevious = false;
        }

        /*
         * WARNING - void declaration
         */
        private void generateEntry(IIndexEntry entry, int level, String id) {
            if (!ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)this.scope)) {
                return;
            }
            if (entry.getKeyword() != null && entry.getKeyword().length() > 0) {
                IIndexSee[] sees;
                ITopic[] topics = ScopeUtils.inScopeTopics((ITopic[])entry.getTopics(), (AbstractHelpScope)this.scope);
                IIndexEntry[] subentries = ScopeUtils.inScopeEntries((IIndexEntry[])entry.getSubentries(), (AbstractHelpScope)this.scope);
                IIndexEntry iIndexEntry = entry;
                if (iIndexEntry instanceof IIndexEntry2) {
                    void entry2;
                    IIndexEntry2 iIndexEntry2 = (IIndexEntry2)iIndexEntry;
                    IIndexEntry2 cfr_ignored_0 = (IIndexEntry2)iIndexEntry;
                    sees = entry2.getSees();
                } else {
                    sees = new IIndexSee[]{};
                }
                boolean multipleTopics = topics.length > 1;
                boolean singleTopic = topics.length == 1;
                this.buf.append("<node");
                if (entry.getKeyword() != null) {
                    this.buf.append("\n      title=\"" + XMLGenerator.xmlEscape(entry.getKeyword()) + "\"");
                }
                this.buf.append("\n      id=\"" + id + "\"");
                if (singleTopic) {
                    String href = UrlUtil.getHelpURL(topics[0].getHref());
                    this.buf.append("\n      href=\"" + XMLGenerator.xmlEscape(href) + "\"");
                }
                this.buf.append(">\n");
                if (multipleTopics || subentries.length > 0 || sees.length > 0) {
                    if (multipleTopics) {
                        this.generateTopicList(entry);
                    }
                    this.generateSubentries(entry, level + 1);
                    this.generateSees(sees);
                }
                this.buf.append("</node>\n");
            }
        }

        private void generateSubentries(IIndexEntry entry, int level) {
            IIndexEntry[] subentries;
            IIndexEntry[] iIndexEntryArray = subentries = entry.getSubentries();
            int n = subentries.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexEntry subentrie = iIndexEntryArray[n2];
                this.generateEntry(subentrie, level, "s" + this.count++);
                ++n2;
            }
        }

        private void generateTopicList(IIndexEntry entry) {
            ITopic[] topics;
            ITopic[] iTopicArray = topics = entry.getTopics();
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                ITopic topic = iTopicArray[n2];
                if (ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)this.scope)) {
                    String label = UrlUtil.htmlEncode(topic.getLabel());
                    if (label == null) {
                        label = UrlUtil.htmlEncode(topic.getLabel());
                    }
                    this.buf.append("<node");
                    if (entry.getKeyword() != null) {
                        this.buf.append("\n      title=\"" + label + "\"");
                    }
                    ++this.count;
                    this.buf.append("\n      id=\"i" + this.count + "\"");
                    String href = UrlUtil.getHelpURL(topic.getHref());
                    this.buf.append("\n      href=\"" + XMLGenerator.xmlEscape(href) + "\"");
                    this.buf.append(">\n");
                    this.buf.append("</node>\n");
                }
                ++n2;
            }
        }

        private void generateSees(IIndexSee[] sees) {
            IIndexSee[] iIndexSeeArray = sees;
            int n = sees.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexSee see = iIndexSeeArray[n2];
                if (ScopeUtils.showInTree((IIndexSee)see, (AbstractHelpScope)this.scope)) {
                    IIndexSubpath[] subpathElements;
                    String key = see.isSeeAlso() ? "SeeAlso" : "See";
                    String seePrefix = WebappResources.getString(key, UrlUtil.getLocale(this.locale));
                    Object seeTarget = see.getKeyword();
                    IIndexSubpath[] iIndexSubpathArray = subpathElements = see.getSubpathElements();
                    int n3 = subpathElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IIndexSubpath subpathElement = iIndexSubpathArray[n4];
                        seeTarget = (String)seeTarget + ", ";
                        seeTarget = (String)seeTarget + subpathElement.getKeyword();
                        ++n4;
                    }
                    String label = NLS.bind((String)seePrefix, (Object)seeTarget);
                    String encodedLabel = UrlUtil.htmlEncode(label);
                    this.buf.append("<node");
                    this.buf.append("\n      title=\"" + encodedLabel + "\"");
                    ++this.count;
                    this.buf.append("\n      id=\"i" + this.count + "\"");
                    String href = "see:" + (String)seeTarget;
                    this.buf.append("\n      href=\"" + XMLGenerator.xmlEscape(href) + "\"");
                    this.buf.append(">\n");
                    this.buf.append("</node>\n");
                }
                ++n2;
            }
        }
    }
}

