/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.IBrowserViewerContainer;
import org.eclipse.ui.internal.browser.ImageResourceManager;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.TextAction;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.part.EditorPart;

public class WebBrowserEditor
extends EditorPart
implements IBrowserViewerContainer {
    public static final String WEB_BROWSER_EDITOR_ID = "org.eclipse.ui.browser.editor";
    protected BrowserViewer webBrowser;
    protected String initialURL;
    protected ImageDescriptor imageDescriptor;
    protected TextAction cutAction;
    protected TextAction copyAction;
    protected TextAction pasteAction;
    private boolean disposed;
    private boolean lockName;

    public void createPartControl(Composite parent) {
        WebBrowserEditorInput input = this.getWebBrowserEditorInput();
        int style = 0;
        if (input == null || input.isLocationBarLocal()) {
            style += 2;
        }
        if (input == null || input.isToolbarLocal()) {
            style += 4;
        }
        this.webBrowser = new BrowserViewer(parent, style);
        this.webBrowser.setURL(this.initialURL);
        this.webBrowser.setContainer(this);
        ImageResourceManager manager = new ImageResourceManager((Control)this.webBrowser);
        this.setTitleImage(manager.getImage(this.imageDescriptor));
        if (input == null || input.isLocationBarLocal()) {
            this.cutAction = new TextAction(this.webBrowser, 0);
            this.copyAction = new TextAction(this.webBrowser, 1);
            this.pasteAction = new TextAction(this.webBrowser, 2);
        }
        if (!this.lockName) {
            PropertyChangeListener propertyChangeListener = event -> {
                if ("title".equals(event.getPropertyName())) {
                    this.setPartName((String)event.getNewValue());
                }
            };
            this.webBrowser.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void dispose() {
        super.dispose();
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public IAction getCopyAction() {
        return this.copyAction;
    }

    public IAction getCutAction() {
        return this.cutAction;
    }

    protected WebBrowserEditorInput getWebBrowserEditorInput() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof WebBrowserEditorInput) {
            return (WebBrowserEditorInput)input;
        }
        return null;
    }

    public IAction getPasteAction() {
        return this.pasteAction;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Trace.trace(Trace.FINEST, "Opening browser: " + String.valueOf(input));
        if (input instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)input;
            IPath path = pei.getPath();
            URL url = null;
            try {
                if (path != null) {
                    this.setPartName(path.lastSegment());
                    url = path.toFile().toURI().toURL();
                }
                if (url != null) {
                    this.initialURL = url.toExternalForm();
                }
            }
            catch (Exception exception) {
                Trace.trace(Trace.SEVERE, "Error getting URL to file");
            }
            if (this.webBrowser != null) {
                if (this.initialURL != null) {
                    this.webBrowser.setURL(this.initialURL);
                }
                site.getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
            }
            if (url != null) {
                this.setTitleToolTip(url.getFile());
            }
            this.imageDescriptor = ImageResourceManager.getImageDescriptor("$nl$/icons/obj16/internal_browser.png");
        } else if (input instanceof WebBrowserEditorInput) {
            WebBrowserEditorInput wbei = (WebBrowserEditorInput)input;
            this.initialURL = null;
            if (wbei.getURL() != null) {
                this.initialURL = wbei.getURL().toExternalForm();
            }
            if (this.webBrowser != null) {
                this.webBrowser.setURL(this.initialURL);
                site.getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
            }
            this.setPartName(wbei.getName());
            this.setTitleToolTip(wbei.getToolTipText());
            this.lockName = wbei.isNameLocked();
            this.imageDescriptor = wbei.getImageDescriptor();
        } else {
            IPathEditorInput pinput = (IPathEditorInput)Adapters.adapt((Object)input, IPathEditorInput.class);
            if (pinput != null) {
                this.init(site, (IEditorInput)pinput);
            } else {
                throw new PartInitException(NLS.bind((String)Messages.errorInvalidEditorInput, (Object)input.getName()));
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public static void open(WebBrowserEditorInput input) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            IEditorReference[] editors = page.getEditorReferences();
            int size = editors.length;
            int i = 0;
            while (i < size) {
                WebBrowserEditor webEditor;
                WebBrowserEditorInput input2;
                IEditorPart editor;
                if (WEB_BROWSER_EDITOR_ID.equals(editors[i].getId()) && (editor = editors[i].getEditor(true)) != null && editor instanceof WebBrowserEditor && ((input2 = (webEditor = (WebBrowserEditor)editor).getWebBrowserEditorInput()) == null || input.canReplaceInput(input2))) {
                    editor.init(editor.getEditorSite(), (IEditorInput)input);
                    return;
                }
                ++i;
            }
            page.openEditor((IEditorInput)input, WEB_BROWSER_EDITOR_ID);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error opening Web browser", e);
        }
    }

    public void setFocus() {
        if (this.webBrowser != null) {
            this.webBrowser.setFocus();
        }
    }

    @Override
    public boolean close() {
        boolean[] result = new boolean[1];
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
        });
        return result[0];
    }

    @Override
    public IActionBars getActionBars() {
        return this.getEditorSite().getActionBars();
    }

    @Override
    public void openInExternalBrowser(String url) {
        IEditorInput input = this.getEditorInput();
        String id = this.getEditorSite().getId();
        Runnable runnable = () -> this.doOpenExternalEditor(id, input);
        Display display = this.getSite().getShell().getDisplay();
        this.close();
        display.asyncExec(runnable);
    }

    protected void doOpenExternalEditor(String id, IEditorInput input) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        String name = input.getName();
        IEditorDescriptor[] editors = registry.getEditors(name);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String editorId = null;
        IEditorDescriptor[] iEditorDescriptorArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editor = iEditorDescriptorArray[n2];
            if (!editor.getId().equals(id)) {
                editorId = editor.getId();
                break;
            }
            ++n2;
        }
        IEditorDescriptor ddesc = registry.getDefaultEditor(name);
        if (ddesc != null && ddesc.getId().equals(id)) {
            int dot = name.lastIndexOf(46);
            Object ext = name;
            if (dot != -1) {
                ext = "*." + name.substring(dot + 1);
            }
            registry.setDefaultEditor((String)ext, null);
        }
        if (editorId == null && registry.isSystemExternalEditorAvailable(name)) {
            editorId = "org.eclipse.ui.systemExternalEditor";
        }
        if (editorId != null) {
            try {
                page.openEditor(input, editorId);
                return;
            }
            catch (PartInitException partInitException) {}
        }
        try {
            URL theURL = new URL(this.webBrowser.getURL());
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(theURL);
        }
        catch (MalformedURLException | PartInitException throwable) {}
    }
}

