/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.RadialTreeLayout;
import org.jungrapht.visualization.layout.algorithms.TidierTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.PolarPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TidierRadialTreeLayoutAlgorithm<V, E>
extends TidierTreeLayoutAlgorithm<V, E>
implements RadialTreeLayout<V> {
    private static final Logger log = LoggerFactory.getLogger(TidierRadialTreeLayoutAlgorithm.class);
    protected Map<V, PolarPoint> polarLocations = new HashMap<V, PolarPoint>();

    public static <V, E> Builder<V, E, ?, ?> edgeAwareBuilder() {
        return (Builder)new Builder().expandLayout(false);
    }

    public TidierRadialTreeLayoutAlgorithm() {
        this(TidierRadialTreeLayoutAlgorithm.edgeAwareBuilder());
    }

    protected TidierRadialTreeLayoutAlgorithm(Builder<V, E, ?, ?> builder) {
        super(builder);
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        super.visit(layoutModel);
        log.trace("roots are {}", (Object)this.roots);
        this.setRadialLocations(this.roots, layoutModel);
        this.putRadialPointsInModel(layoutModel);
        int diameter = this.diameter(layoutModel);
        int offsetDeltaX = diameter - layoutModel.getWidth();
        int offsetDeltaY = diameter - layoutModel.getHeight();
        this.offset(layoutModel, offsetDeltaX / 2, offsetDeltaY / 2);
        layoutModel.setSize(diameter, diameter);
    }

    protected void offset(LayoutModel<V> layoutModel, int deltax, int deltay) {
        layoutModel.getGraph().vertexSet().forEach(v -> {
            Point p = layoutModel.get(v);
            p = p.add(deltax, deltay);
            layoutModel.set(v, p);
        });
    }

    @Override
    public int diameter(LayoutModel<V> layoutModel) {
        return layoutModel.getGraph().vertexSet().stream().map(vertex -> this.polarLocations.get((Object)vertex).radius * 2.0).mapToInt(Double::intValue).max().orElse(layoutModel.getWidth());
    }

    protected int getInitialPosition(int initialPosition, int layoutHeight, int treeHeight) {
        return 0;
    }

    protected void putRadialPointsInModel(LayoutModel<V> layoutModel) {
        this.polarLocations.forEach((key, value) -> layoutModel.set(key, this.getCartesian(layoutModel, key)));
    }

    @Override
    public Map<V, PolarPoint> getPolarLocations() {
        return this.polarLocations;
    }

    protected Point getCartesian(LayoutModel<V> layoutModel, V vertex) {
        PolarPoint pp = this.polarLocations.get(vertex);
        double centerX = layoutModel.getWidth() / 2;
        double centerY = layoutModel.getHeight() / 2;
        Point cartesian = PolarPoint.polarToCartesian(pp);
        cartesian = cartesian.add(centerX, centerY);
        return cartesian;
    }

    protected Point getMaxXY(LayoutModel<V> layoutModel) {
        double maxx = 0.0;
        double maxy = 0.0;
        Set<V> vertices = layoutModel.getGraph().vertexSet();
        for (Object vertex : vertices) {
            Point location = (Point)layoutModel.apply(vertex);
            maxx = Math.max(maxx, location.x);
            maxy = Math.max(maxy, location.y);
        }
        return Point.of(maxx, maxy);
    }

    protected void setRadialLocations(List<V> roots, LayoutModel<V> layoutModel) {
        int width = layoutModel.getWidth();
        Point max = this.getMaxXY(layoutModel);
        double maxx = max.x + (double)this.verticalVertexSpacing;
        maxx = Math.max(maxx, (double)width);
        double theta = Math.PI * 2 / maxx;
        double deltaRadius = 1.0;
        double offset = 0.0;
        if (roots.size() > 0) {
            offset = this.verticalVertexSpacing;
        }
        for (V vertex : layoutModel.getGraph().vertexSet()) {
            Point p = layoutModel.get(vertex);
            PolarPoint polarPoint = PolarPoint.of(p.x * theta, (offset + p.y - (double)this.verticalVertexSpacing) * deltaRadius);
            this.polarLocations.put((PolarPoint)vertex, polarPoint);
        }
    }

    @Override
    public Point getCenter(LayoutModel<V> layoutModel) {
        return Point.of(layoutModel.getWidth() / 2, layoutModel.getHeight() / 2);
    }

    @Override
    public boolean constrained() {
        return true;
    }

    public static class Builder<V, E, T extends TidierRadialTreeLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends TidierTreeLayoutAlgorithm.Builder<V, E, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        @Override
        public T build() {
            return (T)new TidierRadialTreeLayoutAlgorithm(this);
        }
    }
}

