/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.sugiyama.AverageMedian;
import org.jungrapht.visualization.layout.algorithms.sugiyama.HorizontalCompaction;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.VerticalAlignment;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.synthetics.Synthetic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalCoordinateAssignment<V, E> {
    private static Logger log = LoggerFactory.getLogger(HorizontalCoordinateAssignment.class);
    protected Graph<LV<V>, LE<V, E>> svGraph;
    protected NeighborCache<LV<V>, LE<V, E>> neighborCache;
    protected Set<LE<V, E>> markedSegments;
    protected LV<V>[][] layers;
    protected int horizontalOffset;
    protected int verticalOffset;
    protected boolean horizontalBalancing;

    public HorizontalCoordinateAssignment(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments, int horizontalOffset, int verticalOffset) {
        this.svGraph = svGraph;
        this.neighborCache = new NeighborCache<LV<LV<V>>, LE<LV<V>, LE<V, E>>>(svGraph);
        this.markedSegments = markedSegments;
        this.layers = layers;
        this.horizontalOffset = horizontalOffset;
        this.verticalOffset = verticalOffset;
    }

    protected LV<V> pred(LV<V> v) {
        int layerOfV = v.getRank();
        int indexOfV = v.getIndex();
        if (indexOfV < 1) {
            return null;
        }
        LV<V>[] list = this.layers[layerOfV];
        return list[indexOfV - 1];
    }

    protected LV<V> succ(LV<V> v) {
        int layerOfV = v.getRank();
        int indexOfV = v.getIndex();
        if (indexOfV > this.layers[layerOfV].length - 2) {
            return null;
        }
        LV<V>[] list = this.layers[layerOfV];
        return list[indexOfV + 1];
    }

    public void horizontalCoordinateAssignment() {
        this.preprocessing();
        if (log.isTraceEnabled()) {
            log.trace("marked segments:{}", (Object)this.markedSegments);
        }
        VerticalAlignment.LeftmostUpper<V, E> upLeft = new VerticalAlignment.LeftmostUpper<V, E>(this.layers, this.svGraph, this.markedSegments);
        upLeft.align();
        HorizontalCompaction<V> upLeftCompaction = new HorizontalCompaction<V>(this.layers, upLeft.getRootMap(), upLeft.getAlignMap(), this.horizontalOffset, this.verticalOffset);
        upLeftCompaction.horizontalCompaction();
        VerticalAlignment.RightmostUpper<V, E> upRight = new VerticalAlignment.RightmostUpper<V, E>(this.layers, this.svGraph, this.markedSegments);
        upRight.align();
        HorizontalCompaction<V> upRightCompaction = new HorizontalCompaction<V>(this.layers, upRight.getRootMap(), upRight.getAlignMap(), this.horizontalOffset, this.verticalOffset);
        upRightCompaction.horizontalCompaction();
        VerticalAlignment.LeftmostLower<V, E> downLeft = new VerticalAlignment.LeftmostLower<V, E>(this.layers, this.svGraph, this.markedSegments);
        downLeft.align();
        HorizontalCompaction<V> downLeftCompaction = new HorizontalCompaction<V>(this.layers, downLeft.getRootMap(), downLeft.getAlignMap(), this.horizontalOffset, this.verticalOffset);
        downLeftCompaction.horizontalCompaction();
        VerticalAlignment.RightmostLower<V, E> downRight = new VerticalAlignment.RightmostLower<V, E>(this.layers, this.svGraph, this.markedSegments);
        downRight.align();
        HorizontalCompaction<V> downRightCompaction = new HorizontalCompaction<V>(this.layers, downRight.getRootMap(), downRight.getAlignMap(), this.horizontalOffset, this.verticalOffset);
        downRightCompaction.horizontalCompaction();
        this.horizontalBalancing(upLeftCompaction, upRightCompaction, downLeftCompaction, downRightCompaction);
        for (int i = 0; i < this.layers.length; ++i) {
            for (int j = 0; j < this.layers[i].length; ++j) {
                LV<V> v = this.layers[i][j];
                Point upLeftPoint = upLeftCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset);
                Point upRightPoint = upRightCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset);
                Point downLeftPoint = downLeftCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset);
                Point downRightPoint = downRightCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset);
                Point balancedPoint = AverageMedian.averageMedianPoint(upLeftPoint, upRightPoint, downLeftPoint, downRightPoint);
                v.setPoint(balancedPoint);
            }
        }
    }

    protected void horizontalBalancing(HorizontalCompaction<V> ... compactions) {
        int i;
        int leastWidthIndex = -1;
        int[] a = new int[4];
        int[] b = new int[4];
        int leastWidth = Integer.MAX_VALUE;
        for (i = 0; i < 4; ++i) {
            int[] bounds = this.bounds(compactions[i].x.values());
            a[i] = bounds[0];
            b[i] = bounds[1];
            int w = b[i] - a[i];
            if (w >= leastWidth) continue;
            leastWidthIndex = i;
            leastWidth = w;
        }
        for (i = 0; i < 4; ++i) {
            int delta = i == 0 || i == 2 ? a[leastWidthIndex] - a[i] : b[leastWidthIndex] - b[i];
            if (delta == 0) continue;
            compactions[i].x.entrySet().forEach(entry -> entry.setValue((Integer)entry.getValue() + delta));
        }
    }

    protected int[] bounds(Collection<Integer> xValues) {
        int min;
        if (xValues.size() == 0) {
            return new int[]{0, 0};
        }
        int max = min = xValues.stream().findFirst().get().intValue();
        for (Integer i : xValues) {
            if (i < min) {
                min = i;
                continue;
            }
            if (i <= max) continue;
            max = i;
        }
        return new int[]{min, max};
    }

    protected int pos(LV<V> v) {
        return v.getIndex();
    }

    protected LV<V> upperNeighborFor(LV<V> v) {
        return (LV)this.neighborCache.predecessorsOf(v).stream().findFirst().get();
    }

    protected boolean incidentToInnerSegment(LV<V> v) {
        Set<LV<V>> predecessors;
        if (v instanceof Synthetic && (predecessors = this.neighborCache.predecessorsOf(v)).size() > 0) {
            LV pv = (LV)predecessors.stream().findFirst().get();
            return pv instanceof Synthetic;
        }
        return false;
    }

    protected void preprocessing() {
        int h = this.layers.length;
        for (int i = 1; i <= h - 2 - 1; ++i) {
            int k0 = 0;
            int el = 0;
            LV<V>[] Li = this.layers[i];
            LV<V>[] Liplus1 = this.layers[i + 1];
            for (int el1 = 0; el1 <= Liplus1.length - 1; ++el1) {
                LV<V> velOneOfIplusOne = Liplus1[el1];
                boolean incidentToInnerSegment = this.incidentToInnerSegment(velOneOfIplusOne);
                if (el1 != Liplus1.length - 1 && !incidentToInnerSegment) continue;
                int k1 = Li.length - 1;
                if (incidentToInnerSegment) {
                    k1 = this.pos(this.upperNeighborFor(velOneOfIplusOne));
                }
                while (el <= el1) {
                    LV<V> velOfIplusOne = Liplus1[el];
                    for (LV<V> vkOfI : this.getUpperNeighbors(velOfIplusOne)) {
                        int k = this.pos(vkOfI);
                        if (k >= k0 && k <= k1) continue;
                        this.markedSegments.add(this.svGraph.getEdge(vkOfI, velOfIplusOne));
                    }
                    ++el;
                }
                k0 = k1;
            }
        }
    }

    protected List<LV<V>> getUpperNeighbors(LV<V> v) {
        return this.neighborCache.predecessorsOf(v).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
    }
}

