/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.alg.spanning.PrimMinimumSpanningTree;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkSimplexDevelopment<V, E> {
    private static final Logger log = LoggerFactory.getLogger(NetworkSimplexDevelopment.class);
    Graph<V, E> dag;
    Graph<V, E> spanningTree;

    public NetworkSimplexDevelopment(Graph<V, E> dag, Graph<V, E> spanningTree) {
        this.dag = dag;
        this.spanningTree = spanningTree;
    }

    public NetworkSimplexDevelopment(Graph<V, E> dag) {
        this(dag, NetworkSimplexDevelopment.getSpanningTree(dag));
    }

    public Graph<V, E> getTheBestSpanningTree() {
        Map<E, Integer> cutValueMap = this.getEdgeCutValues(this.spanningTree);
        Object edgeToCut = cutValueMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() < 0).findFirst().map(Map.Entry::getKey).orElse(null);
        while (edgeToCut != null) {
            Pair<Set<V>> headAndTail = this.getHeadAndTailComponents(this.spanningTree, edgeToCut);
            this.spanningTree.removeEdge(edgeToCut);
            Set<E> crossComponentEdges = this.getCrossComponentEdges(this.spanningTree, headAndTail);
            Object loser = edgeToCut;
            if (crossComponentEdges.size() > 0) {
                Object edgeToAdd = crossComponentEdges.stream().filter(e -> e != loser).findFirst().get();
                V source = this.dag.getEdgeSource(edgeToAdd);
                V target = this.dag.getEdgeTarget(edgeToAdd);
                this.spanningTree.addEdge(source, target, edgeToAdd);
            }
            cutValueMap = this.getEdgeCutValues(this.spanningTree);
            log.info("cutValueMap: {}", (Object)cutValueMap);
            edgeToCut = cutValueMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() < 0).findFirst().map(Map.Entry::getKey).orElse(null);
            log.info("edgeToCut: {}", (Object)edgeToCut);
        }
        return this.spanningTree;
    }

    static <V, E> Graph<V, E> getDirectedGraphFromSpanningTree(Graph<V, E> spanningTree, Graph<V, E> dag) {
        Graph<V, E> newGraph = GraphTypeBuilder.forGraphType(DefaultGraphType.dag()).buildGraph();
        for (E edge : spanningTree.edgeSet()) {
            newGraph.addVertex(dag.getEdgeSource(edge));
            newGraph.addVertex(dag.getEdgeTarget(edge));
            newGraph.addEdge(dag.getEdgeSource(edge), dag.getEdgeTarget(edge), edge);
        }
        return newGraph;
    }

    public Set<E> getCrossComponentEdges(Graph<V, E> spanningTree, Pair<Set<V>> headAndTail) {
        return this.dag.edgeSet().stream().filter(e -> !spanningTree.containsEdge(e)).filter(e -> {
            V target;
            V source = this.dag.getEdgeSource(e);
            List<V> endpoints = List.of(source, target = this.dag.getEdgeTarget(e));
            return !((Set)headAndTail.first).containsAll(endpoints) && !((Set)headAndTail.second).containsAll(endpoints);
        }).collect(Collectors.toSet());
    }

    public Map<E, Integer> getEdgeCutValues(Graph<V, E> spanningTree) {
        log.info("cutValues");
        HashMap<E, Integer> map = new HashMap<E, Integer>();
        for (E edge : new ArrayList<E>(spanningTree.edgeSet())) {
            spanningTree.removeEdge(edge);
            Pair<Set<V>> headAndTail = this.getHeadAndTailComponents(spanningTree, edge);
            int cutValue = this.cutValue(spanningTree, headAndTail);
            log.info("cut value for edge {} is {}", (Object)(edge + "{" + this.dag.getEdgeSource(edge) + "," + this.dag.getEdgeTarget(edge) + "}"), (Object)cutValue);
            map.put(edge, cutValue);
            spanningTree.addEdge(this.dag.getEdgeSource(edge), this.dag.getEdgeTarget(edge), edge);
        }
        return map;
    }

    Pair<Set<V>> getHeadAndTailComponents(Graph<V, E> spanningTree, E edge) {
        V dagSource = this.dag.getEdgeSource(edge);
        V dagTarget = this.dag.getEdgeTarget(edge);
        spanningTree.removeEdge(edge);
        ConnectivityInspector<V, E> connectivityInspector = new ConnectivityInspector<V, E>(spanningTree);
        List<Set<V>> componentVertices = connectivityInspector.connectedSets();
        HashSet<V> headComponent = new HashSet<V>();
        HashSet<V> tailComponent = new HashSet<V>();
        for (Set<V> set : componentVertices) {
            if (set.contains(dagTarget)) {
                headComponent.addAll(set);
                continue;
            }
            if (!set.contains(dagSource)) continue;
            tailComponent.addAll(set);
        }
        return Pair.of(headComponent, tailComponent);
    }

    private int cutValue(Graph<V, E> spanningTree, Pair<Set<V>> headAndTail) {
        Set headComponent = (Set)headAndTail.first;
        Set tailComponent = (Set)headAndTail.second;
        List nonTreeEdges = this.dag.edgeSet().stream().filter(e -> !spanningTree.containsEdge(e)).collect(Collectors.toList());
        int tailToHead = (int)nonTreeEdges.stream().filter(e -> {
            V source = this.dag.getEdgeSource(e);
            V target = this.dag.getEdgeTarget(e);
            return tailComponent.contains(source) && headComponent.contains(target);
        }).count();
        int headToTail = (int)nonTreeEdges.stream().filter(e -> {
            V source = this.dag.getEdgeSource(e);
            V target = this.dag.getEdgeTarget(e);
            return tailComponent.contains(target) && headComponent.contains(source);
        }).count();
        return tailToHead - headToTail;
    }

    public static <V, E> Graph<V, E> getSpanningTree(Graph<V, E> graph) {
        if (graph.getType().isDirected()) {
            graph = new AsUndirectedGraph<V, E>(graph);
        }
        PrimMinimumSpanningTree<V, E> prim = new PrimMinimumSpanningTree<V, E>(graph);
        SpanningTreeAlgorithm.SpanningTree tree = prim.getSpanningTree();
        Graph newGraph = GraphTypeBuilder.forGraphType(DefaultGraphType.dag()).buildGraph();
        for (Object edge : tree.getEdges()) {
            newGraph.addVertex(graph.getEdgeSource(edge));
            newGraph.addVertex(graph.getEdgeTarget(edge));
            newGraph.addEdge(graph.getEdgeSource(edge), graph.getEdgeTarget(edge), edge);
        }
        return newGraph;
    }
}

