/*
 * Decompiled with CFR 0.152.
 */
package tlc2.overrides;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.SemanticNode;
import tlc2.overrides.Evaluation;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.EvalException;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.ValueInputStream;
import tlc2.value.ValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public class IOUtils {
    private static final Value ENV;
    private static final UniqueString EXITVALUE;
    private static final UniqueString STDOUT;
    private static final UniqueString STDERR;
    private static final UniqueString[] EXEC_NAMES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TLAPlusOperator(identifier="IODeserialize", module="IOUtils", warn=false)
    public static final IValue ioDeserialize(StringValue stringValue, BoolValue boolValue) throws IOException {
        try (ValueInputStream valueInputStream = new ValueInputStream(new File(stringValue.val.toString()), boolValue.val);){
            IValue iValue = valueInputStream.read(UniqueString.internTbl.toMap());
            return iValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TLAPlusOperator(identifier="IOSerialize", module="IOUtils", warn=false)
    public static final IValue ioSerialize(IValue iValue, StringValue stringValue, BoolValue boolValue) throws IOException {
        try (ValueOutputStream valueOutputStream = new ValueOutputStream(new File(stringValue.val.toString()), boolValue.val);){
            iValue.write((IValueOutputStream)valueOutputStream);
        }
        return BoolValue.ValTrue;
    }

    @Evaluation(definition="Serialize", module="IOUtils", warn=false, silent=true, priority=50)
    public static synchronized Value textSerialize(Tool tool, ExprOrOpArgNode[] exprOrOpArgNodeArray, Context context, TLCState tLCState, TLCState tLCState2, int n, CostModel costModel) {
        RecordValue recordValue;
        try {
            recordValue = (RecordValue)tool.eval((SemanticNode)exprOrOpArgNodeArray[2], context, tLCState, tLCState2, n, costModel);
        }
        catch (Exception exception) {
            return new RecordValue(EXEC_NAMES, new Value[]{IntValue.ValOne, new StringValue(""), new StringValue("Serialize error invalid parameters: " + exception.toString())}, false);
        }
        StringValue stringValue2 = (StringValue)recordValue.apply((Value)new StringValue("format"), 0);
        if ("TXT".equals(stringValue2.getVal().toString())) {
            StringValue[] stringValueArray;
            StringValue stringValue3;
            StringValue stringValue4;
            StringValue stringValue5;
            try {
                stringValue5 = (StringValue)tool.eval((SemanticNode)exprOrOpArgNodeArray[0], context, tLCState, tLCState2, n, costModel);
                stringValue4 = (StringValue)tool.eval((SemanticNode)exprOrOpArgNodeArray[1], context, tLCState, tLCState2, n, costModel);
                TupleValue tupleValue = (TupleValue)recordValue.apply((Value)new StringValue("openOptions"), 0);
                stringValue3 = (StringValue)recordValue.apply((Value)new StringValue("charset"), 0);
                stringValueArray = (StringValue[])Arrays.asList(tupleValue.getElems()).stream().map(iValue -> (StringValue)iValue).toArray(StringValue[]::new);
            }
            catch (Exception exception) {
                return new RecordValue(EXEC_NAMES, new Value[]{IntValue.ValOne, new StringValue(""), new StringValue("Serialize error invalid parameters: " + exception.toString())}, false);
            }
            try {
                Files.writeString(Paths.get(stringValue4.getVal().toString(), new String[0]), (CharSequence)stringValue5.getVal().toString(), Charset.forName(stringValue3.getVal().toString()), (OpenOption[])Arrays.asList(stringValueArray).stream().map(stringValue -> StandardOpenOption.valueOf(stringValue.getVal().toString())).toArray(StandardOpenOption[]::new));
                return new RecordValue(EXEC_NAMES, new Value[]{IntValue.ValZero, new StringValue("Finish writing to the file with success!"), new StringValue("")}, false);
            }
            catch (Exception exception) {
                StringValue stringValue6 = new StringValue("Serialize error writing to the file: " + exception.toString());
                return new RecordValue(EXEC_NAMES, new Value[]{IntValue.ValOne, new StringValue(""), stringValue6}, false);
            }
        }
        return null;
    }

    @Evaluation(definition="Deserialize", module="IOUtils", warn=false, silent=true, priority=50)
    public static synchronized Value textDeserialize(Tool tool, ExprOrOpArgNode[] exprOrOpArgNodeArray, Context context, TLCState tLCState, TLCState tLCState2, int n, CostModel costModel) {
        RecordValue recordValue;
        try {
            recordValue = (RecordValue)tool.eval((SemanticNode)exprOrOpArgNodeArray[1], context, tLCState, tLCState2, n, costModel);
        }
        catch (Exception exception) {
            return new RecordValue(EXEC_NAMES, new Value[]{IntValue.ValOne, new StringValue(""), new StringValue("Deserialize error invalid parameters: " + exception.toString())}, false);
        }
        StringValue stringValue = (StringValue)recordValue.apply((Value)new StringValue("format"), 0);
        if ("TXT".equals(stringValue.getVal().toString())) {
            StringValue stringValue2;
            StringValue stringValue3;
            try {
                stringValue3 = (StringValue)tool.eval((SemanticNode)exprOrOpArgNodeArray[0], context, tLCState, tLCState2, n, costModel);
                stringValue2 = (StringValue)recordValue.apply((Value)new StringValue("charset"), 0);
            }
            catch (Exception exception) {
                return new RecordValue(EXEC_NAMES, new Value[]{IntValue.ValOne, new StringValue(""), new StringValue("Deserialize error invalid parameters: " + exception.toString())}, false);
            }
            try {
                String string = Files.readString(Paths.get(stringValue3.getVal().toString(), new String[0]), Charset.forName(stringValue2.getVal().toString()));
                return new RecordValue(EXEC_NAMES, new Value[]{IntValue.ValZero, new StringValue(string), new StringValue("")}, false);
            }
            catch (Exception exception) {
                StringValue stringValue4 = new StringValue("Deserialize error reading from the file: " + exception.toString());
                return new RecordValue(EXEC_NAMES, new Value[]{IntValue.ValOne, new StringValue(""), stringValue4}, false);
            }
        }
        return null;
    }

    @TLAPlusOperator(identifier="atoi", module="IOUtils", minLevel=0, warn=false)
    public static Value atoi(Value value) {
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            try {
                int n = Integer.parseInt(stringValue.val.toString());
                return IntValue.gen((int)n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new EvalException(2283, new String[]{"atoi", "string", Values.ppr((String)value.toString())});
    }

    @TLAPlusOperator(identifier="IOEnv", module="IOUtils", minLevel=0, warn=false)
    public static Value ioEnv() throws IOException, InterruptedException {
        return ENV;
    }

    @TLAPlusOperator(identifier="IOExec", module="IOUtils", minLevel=1, warn=false)
    public static Value ioExec(Value value) throws IOException, InterruptedException {
        if (!(value instanceof TupleValue)) {
            throw new EvalException(2283, new String[]{"IOExec", "sequence", Values.ppr((String)value.toString())});
        }
        TupleValue tupleValue = (TupleValue)value;
        String[] stringArray = (String[])Arrays.asList(tupleValue.getElems()).stream().map(IOUtils::convert).toArray(String[]::new);
        return IOUtils.runProcess(stringArray);
    }

    @TLAPlusOperator(identifier="IOEnvExec", module="IOUtils", minLevel=1, warn=false)
    public static Value ioEnvExec(Value value, Value value2) throws IOException, InterruptedException {
        RecordValue recordValue = (RecordValue)value.toRcd();
        if (recordValue == null) {
            throw new EvalException(2283, new String[]{"IOEnvExec", "record", Values.ppr((String)value.toString())});
        }
        if (!(value2 instanceof TupleValue)) {
            throw new EvalException(2283, new String[]{"IOEnvExec", "sequence", Values.ppr((String)value2.toString())});
        }
        TupleValue tupleValue = (TupleValue)value2;
        String[] stringArray = (String[])Arrays.asList(tupleValue.getElems()).stream().map(IOUtils::convert).toArray(String[]::new);
        return IOUtils.runProcess(IOUtils.getEnv(recordValue), stringArray);
    }

    @TLAPlusOperator(identifier="IOExecTemplate", module="IOUtils", minLevel=1, warn=false)
    public static Value ioExecTemplate(Value value, Value value2) throws IOException, InterruptedException {
        if (!(value instanceof TupleValue)) {
            throw new EvalException(2283, new String[]{"IOExecTemplate", "sequence", Values.ppr((String)value.toString())});
        }
        if (!(value2 instanceof TupleValue)) {
            throw new EvalException(2283, new String[]{"IOExecTemplate", "sequence", Values.ppr((String)value2.toString())});
        }
        TupleValue tupleValue = (TupleValue)value;
        TupleValue tupleValue2 = (TupleValue)value2;
        String[] stringArray = (String[])Arrays.asList(tupleValue.getElems()).stream().map(IOUtils::convert).toArray(String[]::new);
        Object[] objectArray = Arrays.asList(tupleValue2.getElems()).stream().map(IOUtils::convert).toArray(Object[]::new);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.format(stringArray[i], objectArray);
        }
        return IOUtils.runProcess(stringArray);
    }

    @TLAPlusOperator(identifier="IOEnvExecTemplate", module="IOUtils", minLevel=1, warn=false)
    public static Value ioEnvExecTemplate(Value value, Value value2, Value value3) throws IOException, InterruptedException {
        RecordValue recordValue = (RecordValue)value.toRcd();
        if (recordValue == null) {
            throw new EvalException(2283, new String[]{"IOEnvExecTemplate", "record", Values.ppr((String)value.toString())});
        }
        if (!(value2 instanceof TupleValue)) {
            throw new EvalException(2283, new String[]{"IOEnvExecTemplate", "sequence", Values.ppr((String)value2.toString())});
        }
        if (!(value3 instanceof TupleValue)) {
            throw new EvalException(2283, new String[]{"IOEnvExecTemplate", "sequence", Values.ppr((String)value3.toString())});
        }
        TupleValue tupleValue = (TupleValue)value2;
        TupleValue tupleValue2 = (TupleValue)value3;
        String[] stringArray = (String[])Arrays.asList(tupleValue.getElems()).stream().map(IOUtils::convert).toArray(String[]::new);
        Object[] objectArray = Arrays.asList(tupleValue2.getElems()).stream().map(IOUtils::convert).toArray(Object[]::new);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.format(stringArray[i], objectArray);
        }
        return IOUtils.runProcess(IOUtils.getEnv(recordValue), stringArray);
    }

    private static Map<String, String> getEnv(RecordValue recordValue) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < recordValue.size(); ++i) {
            UniqueString uniqueString = recordValue.names[i];
            Value value = recordValue.values[i];
            hashMap.put(uniqueString.toString(), value.toUnquotedString());
        }
        return hashMap;
    }

    private static Value runProcess(String[] stringArray) throws IOException, InterruptedException {
        return IOUtils.runProcess(new ProcessBuilder(stringArray));
    }

    private static Value runProcess(Map<String, String> map, String[] stringArray) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.environment().putAll(map);
        return IOUtils.runProcess(processBuilder);
    }

    private static Value runProcess(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        Process process = processBuilder.start();
        StringValue stringValue = new StringValue(IOUtils.stringFromInputStream(process.getInputStream()));
        StringValue stringValue2 = new StringValue(IOUtils.stringFromInputStream(process.getErrorStream()));
        IntValue intValue = IntValue.gen((int)process.waitFor());
        return new RecordValue(EXEC_NAMES, new Value[]{intValue, stringValue, stringValue2}, false);
    }

    private static String stringFromInputStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toString();
    }

    private static String convert(IValue iValue) {
        if (!(iValue instanceof StringValue)) {
            throw new EvalException(2283, new String[]{"IOExec", "sequence", Values.ppr((String)iValue.toString())});
        }
        StringValue stringValue = (StringValue)iValue;
        return stringValue.val.toString();
    }

    static {
        Map<String, String> map = System.getenv();
        UniqueString[] uniqueStringArray = new UniqueString[map.size()];
        StringValue[] stringValueArray = new StringValue[map.size()];
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        for (int i = 0; i < arrayList.size(); ++i) {
            uniqueStringArray[i] = UniqueString.of((String)((String)((Map.Entry)arrayList.get(i)).getKey()));
            stringValueArray[i] = new StringValue((String)((Map.Entry)arrayList.get(i)).getValue());
        }
        ENV = new RecordValue(uniqueStringArray, (Value[])stringValueArray, false).normalize();
        EXITVALUE = UniqueString.uniqueStringOf((String)"exitValue");
        STDOUT = UniqueString.uniqueStringOf((String)"stdout");
        STDERR = UniqueString.uniqueStringOf((String)"stderr");
        EXEC_NAMES = new UniqueString[]{EXITVALUE, STDOUT, STDERR};
    }
}

