/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.ClasspathShortener;
import org.eclipse.jdt.internal.launching.CommandLineShortener;
import org.eclipse.jdt.internal.launching.IProcessTempFileCreator;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.StandardVM;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.osgi.util.NLS;

public class StandardVMRunner
extends AbstractVMRunner {
    public static final String XSTART_ON_FIRST_THREAD = "-XstartOnFirstThread";
    protected IVMInstall fVMInstance;

    public StandardVMRunner(IVMInstall vmInstance) {
        this.fVMInstance = vmInstance;
    }

    protected String renderDebugTarget(String classToRun, int host) {
        String format = LaunchingMessages.StandardVMRunner__0__at_localhost__1__1;
        return NLS.bind((String)format, (Object[])new String[]{classToRun, String.valueOf(host)});
    }

    public static String renderProcessLabel(Process p, String[] commandLine, String timestamp) {
        String processId = StandardVMRunner.getProcessId(p);
        if (processId == null) {
            String format = LaunchingMessages.StandardVMRunner__0____1___2;
            return NLS.bind((String)format, (Object[])new String[]{commandLine[0], timestamp});
        }
        String format = LaunchingMessages.StandardVMRunner__0____1___2_3;
        return NLS.bind((String)format, (Object[])new String[]{commandLine[0], timestamp, processId});
    }

    private static String getProcessId(Process p) {
        try {
            return p != null ? Long.toString(p.pid()) : null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    protected String renderCommandLine(String[] commandLine) {
        return DebugPlugin.renderArguments((String[])commandLine, null);
    }

    protected void addArguments(String[] args, List<String> v) {
        if (args == null) {
            return;
        }
        v.addAll(Arrays.asList(args));
    }

    protected String[] validateCommandLine(ILaunchConfiguration configuration, String[] cmdLine) {
        try {
            return this.wrap(configuration, cmdLine);
        }
        catch (CoreException ce) {
            LaunchingPlugin.log(ce);
            return null;
        }
    }

    private String[] wrap(ILaunchConfiguration config, String[] cmdLine) throws CoreException {
        if (config != null && "macosx".equals(Platform.getOS())) {
            String[] stringArray = cmdLine;
            int n = cmdLine.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if ("-ws".equals(element) || element.contains("swt.jar") || element.contains("org.eclipse.swt")) {
                    return this.createSWTlauncher(cmdLine, cmdLine[0], config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_START_ON_FIRST_THREAD, true));
                }
                ++n2;
            }
        }
        return cmdLine;
    }

    private String[] createSWTlauncher(String[] cmdLine, String vmVersion, boolean startonfirstthread) {
        String java_swt = System.getProperty("org.eclipse.swtlauncher");
        if (java_swt == null) {
            boolean found = false;
            ArrayList<String> args = new ArrayList<String>();
            String[] stringArray = cmdLine;
            int n = cmdLine.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (XSTART_ON_FIRST_THREAD.equals(element)) {
                    found = true;
                }
                args.add(element);
                ++n2;
            }
            if (!found && startonfirstthread) {
                args.add(1, XSTART_ON_FIRST_THREAD);
            }
            return args.toArray(new String[args.size()]);
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/cp", java_swt, "/tmp"});
            process.waitFor();
            java_swt = "/tmp/java_swt";
        }
        catch (IOException | InterruptedException exception) {}
        String[] newCmdLine = new String[cmdLine.length + 1];
        int argCount = 0;
        newCmdLine[argCount++] = java_swt;
        newCmdLine[argCount++] = "-XXvm=" + vmVersion;
        int i = 1;
        while (i < cmdLine.length) {
            newCmdLine[argCount++] = cmdLine[i];
            ++i;
        }
        return newCmdLine;
    }

    protected File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        String path = config.getWorkingDirectory();
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            this.abort(NLS.bind((String)LaunchingMessages.StandardVMRunner_Specified_working_directory_does_not_exist_or_is_not_a_directory___0__3, (Object[])new String[]{path}), null, 108);
        }
        return dir;
    }

    @Override
    protected String getPluginIdentifier() {
        return LaunchingPlugin.getUniqueIdentifier();
    }

    protected String constructProgramString(VMRunnerConfiguration config) throws CoreException {
        String installLocation;
        File exe;
        String command = null;
        Map<String, Object> map = config.getVMSpecificAttributesMap();
        if (map != null) {
            command = (String)map.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
        }
        if (command == null) {
            File exe2 = null;
            exe2 = this.fVMInstance instanceof StandardVM ? ((StandardVM)this.fVMInstance).getJavaExecutable() : StandardVMType.findJavaExecutable(this.fVMInstance.getInstallLocation());
            if (exe2 == null) {
                this.abort(NLS.bind((String)LaunchingMessages.StandardVMRunner_Unable_to_locate_executable_for__0__1, (Object[])new String[]{this.fVMInstance.getName()}), null, 150);
            } else {
                return exe2.getAbsolutePath();
            }
        }
        if (this.fileExists(exe = new File((installLocation = this.fVMInstance.getInstallLocation().getAbsolutePath() + File.separatorChar) + "bin" + File.separatorChar + command))) {
            return exe.getAbsolutePath();
        }
        if (this.fileExists(exe = new File(exe.getAbsolutePath() + ".exe"))) {
            return exe.getAbsolutePath();
        }
        exe = new File(installLocation + "jre" + File.separatorChar + "bin" + File.separatorChar + command);
        if (this.fileExists(exe)) {
            return exe.getAbsolutePath();
        }
        if (this.fileExists(exe = new File(exe.getAbsolutePath() + ".exe"))) {
            return exe.getAbsolutePath();
        }
        this.abort(NLS.bind((String)LaunchingMessages.StandardVMRunner_Specified_executable__0__does_not_exist_for__1__4, (Object[])new String[]{command, this.fVMInstance.getName()}), null, 150);
        return null;
    }

    protected boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    protected String convertClassPath(String[] cp) {
        int pathCount = 0;
        StringBuilder buf = new StringBuilder();
        if (cp.length == 0) {
            return "";
        }
        String[] stringArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (pathCount > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(element);
            ++pathCount;
            ++n2;
        }
        return buf.toString();
    }

    protected String[] ensureEncoding(ILaunch launch, String[] vmargs) {
        String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        vmargs = this.ensureArgument("-Dfile.encoding=", encoding, vmargs);
        vmargs = this.ensureArgument("-Dstdout.encoding=", encoding, vmargs);
        vmargs = this.ensureArgument("-Dstderr.encoding=", encoding, vmargs);
        return vmargs;
    }

    protected String[] ensureArgument(String argument, String value, String[] vmargs) {
        boolean foundArgument = false;
        String[] stringArray = vmargs;
        int n = vmargs.length;
        int n2 = 0;
        while (n2 < n) {
            String vmarg = stringArray[n2];
            if (vmarg.startsWith(argument)) {
                foundArgument = true;
            }
            ++n2;
        }
        if (!foundArgument) {
            if (value == null) {
                return vmargs;
            }
            String[] newargs = new String[vmargs.length + 1];
            System.arraycopy(vmargs, 0, newargs, 0, vmargs.length);
            newargs[newargs.length - 1] = argument + value;
            return newargs;
        }
        return vmargs;
    }

    @Override
    public String showCommandLine(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        CommandDetails cmd = this.getCommandLine(configuration, launch, (IProgressMonitor)subMonitor);
        if (subMonitor.isCanceled() || cmd == null) {
            return "";
        }
        String[] cmdLine = cmd.getCommandLine();
        cmdLine = StandardVMRunner.quoteWindowsArgs(cmdLine);
        return this.getCmdLineAsString(cmdLine);
    }

    private CommandDetails getCommandLine(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String dependencies;
        String[] cp;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.subTask(LaunchingMessages.StandardVMRunner_Constructing_command_line____2);
        String program = this.constructProgramString(config);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program);
        String[] allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(this.ensureEncoding(launch, allVMArgs), arguments);
        this.addBootClassPathArguments(arguments, config);
        String[] mp = config.getModulepath();
        if (mp != null && mp.length > 0) {
            arguments.add("-p");
            arguments.add(this.convertClassPath(mp));
        }
        if ((cp = config.getClassPath()).length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        if (config.isPreviewEnabled()) {
            arguments.add("--enable-preview");
        }
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (this.getJavaVersion(this.fVMInstance) >= 14.0 && launchConfiguration != null && launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SHOW_CODEDETAILS_IN_EXCEPTION_MESSAGES, true)) {
            arguments.add("-XX:+ShowCodeDetailsInExceptionMessages");
        }
        if ((dependencies = config.getOverrideDependencies()) != null && dependencies.length() > 0) {
            arguments.addAll(Arrays.asList(DebugPlugin.parseArguments((String)dependencies)));
        }
        if (this.isModular(config, this.fVMInstance)) {
            arguments.add("-m");
            arguments.add(config.getModuleDescription() + "/" + config.getClassToLaunch());
        } else {
            arguments.add(config.getClassToLaunch());
        }
        int lastVMArgumentIndex = arguments.size() - 1;
        String[] programArgs = config.getProgramArguments();
        this.addArguments(programArgs, arguments);
        String[] envp = this.prependJREPath(config.getEnvironment());
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        File workingDir = this.getWorkingDir(config);
        CommandDetails cmd = new CommandDetails();
        CommandLineShortener commandLineShortener = new CommandLineShortener(this.fVMInstance, launch, cmdLine, workingDir);
        if (commandLineShortener.shouldShortenCommandLine()) {
            cmdLine = commandLineShortener.shortenCommandLine();
            cmd.setCommandLineShortener(commandLineShortener);
        } else {
            ClasspathShortener classpathShortener = new ClasspathShortener(this.fVMInstance, launch, cmdLine, lastVMArgumentIndex, workingDir, envp);
            if (classpathShortener.shortenCommandLineIfNecessary()) {
                cmdLine = classpathShortener.getCmdLine();
                envp = classpathShortener.getEnvp();
            }
            cmd.setCommandLineShortener(classpathShortener);
        }
        String[] newCmdLine = this.validateCommandLine(launchConfiguration, cmdLine);
        if (newCmdLine != null) {
            cmdLine = newCmdLine;
        }
        cmd.setCommandLine(cmdLine);
        cmd.setEnvp(envp);
        cmd.setWorkingDir(workingDir);
        subMonitor.worked(1);
        return cmd;
    }

    @Override
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        List<File> processTempFiles;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        CommandDetails cmdDetails = this.getCommandLine(config, launch, (IProgressMonitor)subMonitor);
        if (subMonitor.isCanceled() || cmdDetails == null) {
            return;
        }
        String[] cmdLine = cmdDetails.getCommandLine();
        subMonitor.beginTask(LaunchingMessages.StandardVMRunner_Launching_VM____1, 2);
        subMonitor.subTask(LaunchingMessages.StandardVMRunner_Starting_virtual_machine____3);
        Process p = null;
        p = this.exec(cmdLine, cmdDetails.getWorkingDir(), cmdDetails.getEnvp(), config.isMergeOutput());
        if (p == null) {
            return;
        }
        if (subMonitor.isCanceled()) {
            p.destroy();
            return;
        }
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        IProcess process = this.newProcess(launch, p, StandardVMRunner.renderProcessLabel(p, cmdLine, timestamp), this.getDefaultProcessMap());
        process.setAttribute("org.eclipse.debug.core.ATTR_PATH", cmdLine[0]);
        process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(cmdLine));
        String ltime = launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
        process.setAttribute("org.eclipse.debug.core.launch.timestamp", ltime != null ? ltime : timestamp);
        if (cmdDetails.getWorkingDir() != null) {
            process.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", cmdDetails.getWorkingDir().getAbsolutePath());
        }
        if (cmdDetails.getEnvp() != null) {
            Object[] envp = cmdDetails.getEnvp();
            Arrays.sort(envp);
            process.setAttribute("org.eclipse.debug.core.ATTR_ENVIRONMENT", String.join((CharSequence)String.valueOf('\n'), (CharSequence[])envp));
        }
        if (!(processTempFiles = cmdDetails.getCommandLineShortener().getProcessTempFiles()).isEmpty()) {
            String tempFiles = processTempFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
            process.setAttribute("tempFiles", tempFiles);
        }
        subMonitor.worked(1);
        subMonitor.done();
    }

    int getCPIndex(String[] env) {
        if (env != null) {
            int i = 0;
            while (i < env.length) {
                if (env[i].regionMatches(true, 0, "CLASSPATH=", 0, 10)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected String[] prependJREPath(String[] env) {
        IVMInstall2 vm;
        String javaVersion;
        if ("macosx".equals(Platform.getOS()) && this.fVMInstance instanceof IVMInstall2 && (javaVersion = (vm = (IVMInstall2)((Object)this.fVMInstance)).getJavaVersion()) != null) {
            if (env == null) {
                Map map = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
                if (map.containsKey("JAVA_JVM_VERSION")) {
                    String[] env2 = new String[map.size()];
                    Iterator iterator = map.entrySet().iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String key = (String)entry.getKey();
                        env2[i] = "JAVA_JVM_VERSION".equals(key) ? key + "=" + javaVersion : key + "=" + (String)entry.getValue();
                        ++i;
                    }
                    env = env2;
                }
            } else {
                int i = 0;
                while (i < env.length) {
                    String string = env[i];
                    if (string.startsWith("JAVA_JVM_VERSION")) {
                        env[i] = "JAVA_JVM_VERSION=" + javaVersion;
                        break;
                    }
                    ++i;
                }
            }
        }
        return env;
    }

    protected void addBootClassPathArguments(List<String> arguments, VMRunnerConfiguration config) {
        String[] prependBootCP = null;
        String[] bootCP = null;
        String[] appendBootCP = null;
        Map<String, Object> map = config.getVMSpecificAttributesMap();
        if (map != null) {
            prependBootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_PREPEND);
            bootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH);
            if (JavaRuntime.isModularJava(this.fVMInstance)) {
                if (prependBootCP != null && prependBootCP.length > 0) {
                    prependBootCP = null;
                    LaunchingPlugin.log(LaunchingMessages.RunnerBootpathPError);
                }
                if (bootCP != null && bootCP.length > 0) {
                    bootCP = null;
                    LaunchingPlugin.log(LaunchingMessages.RunnerBootpathError);
                }
            }
            appendBootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_APPEND);
        }
        if (!JavaRuntime.isModularJava(this.fVMInstance) && prependBootCP == null && bootCP == null && appendBootCP == null) {
            bootCP = config.getBootClassPath();
        }
        if (prependBootCP != null) {
            arguments.add("-Xbootclasspath/p:" + this.convertClassPath(prependBootCP));
        }
        if (bootCP != null && bootCP.length > 0) {
            arguments.add("-Xbootclasspath:" + this.convertClassPath(bootCP));
        }
        if (appendBootCP != null) {
            arguments.add("-Xbootclasspath/a:" + this.convertClassPath(appendBootCP));
        }
    }

    protected double getJavaVersion(IVMInstall fVMInstance) {
        String version = null;
        if (fVMInstance instanceof IVMInstall2) {
            version = ((IVMInstall2)((Object)fVMInstance)).getJavaVersion();
        } else {
            LibraryInfo libInfo = LaunchingPlugin.getLibraryInfo(fVMInstance.getInstallLocation().getAbsolutePath());
            if (libInfo == null) {
                return 0.0;
            }
            version = libInfo.getVersion();
        }
        if (version == null) {
            return 0.0;
        }
        int index = version.indexOf(".");
        int nextIndex = version.indexOf(".", index + 1);
        try {
            if (index > 0 && nextIndex > index) {
                return Double.parseDouble(version.substring(0, nextIndex));
            }
            return Double.parseDouble(version);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    protected static class CommandDetails {
        private String[] commandLine;
        private String[] envp;
        private File workingDir;
        private IProcessTempFileCreator commandLineShortener;
        private int port;

        protected CommandDetails() {
        }

        public String[] getEnvp() {
            return this.envp;
        }

        public void setEnvp(String[] envp) {
            this.envp = envp;
        }

        public String[] getCommandLine() {
            return this.commandLine;
        }

        public void setCommandLine(String[] commandLine) {
            this.commandLine = commandLine;
        }

        public File getWorkingDir() {
            return this.workingDir;
        }

        public void setWorkingDir(File workingDir) {
            this.workingDir = workingDir;
        }

        public IProcessTempFileCreator getCommandLineShortener() {
            return this.commandLineShortener;
        }

        public void setCommandLineShortener(IProcessTempFileCreator commandLineShortener) {
            this.commandLineShortener = commandLineShortener;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

