/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.internal.content;

import com.abstratt.content.ContentSupport;
import com.abstratt.content.IContentProviderRegistry;
import com.abstratt.internal.content.Activator;
import com.abstratt.pluginutils.LogUtils;
import com.abstratt.pluginutils.RegistryReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.MethodUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.viewers.IContentProvider;

public class ContentProviderRegistry
implements IContentProviderRegistry {
    private static final String CONTENT_PROVIDER_XP = String.valueOf(ContentSupport.PLUGIN_ID) + ".contentProvider";
    public List<ContentProviderDescriptor> providerDescriptors = new ArrayList<ContentProviderDescriptor>();

    public ContentProviderRegistry() {
        this.build();
    }

    private void addProvider(IConfigurationElement element) {
        this.providerDescriptors.add(new ContentProviderDescriptor(element));
    }

    private void build() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        new RegistryReader(){

            protected String getNamespace() {
                return ContentSupport.PLUGIN_ID;
            }

            protected boolean readElement(IConfigurationElement element) {
                ContentProviderRegistry.this.addProvider(element);
                return true;
            }
        }.readRegistry(registry, CONTENT_PROVIDER_XP);
    }

    @Override
    public IContentProviderRegistry.IProviderDescription findContentProvider(IContentType target, Class<? extends IContentProvider> minimumProtocol) {
        for (ContentProviderDescriptor descriptor : this.providerDescriptors) {
            for (IContentType contentType : descriptor.getAssociations()) {
                if (!target.isKindOf(contentType) || minimumProtocol == null || !minimumProtocol.isInstance(descriptor.getProvider())) continue;
                return descriptor;
            }
        }
        return null;
    }

    public class ContentProviderDescriptor
    implements IContentProviderRegistry.IProviderDescription {
        private IConfigurationElement configElement;
        private Set<IContentType> associations = new HashSet<IContentType>();
        private List<Object> readers = new ArrayList<Object>();

        public ContentProviderDescriptor(IConfigurationElement configElement) {
            IConfigurationElement[] readerElements;
            this.configElement = configElement;
            IConfigurationElement[] associationElements = configElement.getChildren("association");
            IContentTypeManager pcm = Platform.getContentTypeManager();
            IConfigurationElement[] iConfigurationElementArray = associationElements;
            int n = associationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement associationEl = iConfigurationElementArray[n2];
                this.associations.add(pcm.getContentType(associationEl.getAttribute("contentType")));
                ++n2;
            }
            IConfigurationElement[] iConfigurationElementArray2 = readerElements = configElement.getChildren("reader");
            int n3 = readerElements.length;
            n = 0;
            while (n < n3) {
                IConfigurationElement readerEl = iConfigurationElementArray2[n];
                try {
                    Object reader = readerEl.createExecutableExtension("class");
                    this.readers.add(reader);
                }
                catch (CoreException e) {
                    LogUtils.logError((String)ContentSupport.PLUGIN_ID, (String)("Error processing content provider extension " + configElement.getNamespaceIdentifier()), (Throwable)e);
                }
                ++n;
            }
        }

        public boolean canRead(Class<?> sourceType) {
            return this.findReader(sourceType) != null;
        }

        public Object findReader(Class<?> sourceType) {
            for (Object reader : this.readers) {
                if (this.getReaderMethod(reader, sourceType) == null) continue;
                return reader;
            }
            return null;
        }

        public Set<IContentType> getAssociations() {
            return this.associations;
        }

        @Override
        public IContentProvider getProvider() {
            try {
                return (IContentProvider)this.configElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                LogUtils.logError((String)ContentSupport.PLUGIN_ID, (String)"Could not instantiate content provider", (Throwable)e);
                return null;
            }
        }

        private Method getReaderMethod(Object reader, Class<?> sourceType) {
            Method method = MethodUtils.getMatchingAccessibleMethod(reader.getClass(), (String)"read", (Class[])new Class[]{sourceType});
            return method == null || method.getReturnType() == Void.class ? null : method;
        }

        @Override
        public Object read(Object source) {
            Object reader = this.findReader(source.getClass());
            if (reader == null) {
                throw new IllegalArgumentException("Cannot read " + source);
            }
            Method readerMethod = this.getReaderMethod(reader, source.getClass());
            try {
                return readerMethod.invoke(reader, source);
            }
            catch (IllegalAccessException e) {
                Activator.logUnexpected(null, e);
            }
            catch (InvocationTargetException e) {
                Activator.logUnexpected(null, e);
            }
            return null;
        }
    }
}

