/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.sun;

import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import de.vonloesch.pdf4eclipse.model.IOutlineNode;
import de.vonloesch.pdf4eclipse.model.IPDFDestination;
import de.vonloesch.pdf4eclipse.model.sun.SunPDFDestination;
import java.util.Enumeration;

public class SunOutlineNode
implements IOutlineNode {
    private OutlineNode node;

    public SunOutlineNode(OutlineNode node) {
        assert (node != null);
        this.node = node;
    }

    @Override
    public IOutlineNode[] getChildren() {
        IOutlineNode[] tn = new SunOutlineNode[this.node.getChildCount()];
        Enumeration te = this.node.children();
        int i = 0;
        while (te.hasMoreElements()) {
            tn[i] = new SunOutlineNode((OutlineNode)te.nextElement());
            ++i;
        }
        return tn;
    }

    @Override
    public IPDFDestination getDestination() {
        PDFAction action = this.node.getAction();
        if (action instanceof GoToAction) {
            PDFDestination dest = ((GoToAction)action).getDestination();
            return new SunPDFDestination(dest);
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.node.toString();
    }

    @Override
    public IOutlineNode getParent() {
        OutlineNode n = (OutlineNode)this.node.getParent();
        if (n == null) {
            return null;
        }
        return new SunOutlineNode(n);
    }

    @Override
    public boolean hasChildren() {
        return this.node.getChildCount() > 0;
    }
}

