/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.sun;

import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import de.vonloesch.pdf4eclipse.model.IPDFDestination;
import de.vonloesch.pdf4eclipse.model.IPDFFile;
import de.vonloesch.pdf4eclipse.model.IPDFPage;
import de.vonloesch.pdf4eclipse.model.sun.SunPDFFile;
import de.vonloesch.pdf4eclipse.model.sun.SunPDFPage;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class SunPDFDestination
implements IPDFDestination {
    PDFDestination dest;
    String url;
    int type;

    public SunPDFDestination(PDFDestination dest) {
        this.dest = dest;
        this.type = 2;
    }

    public SunPDFDestination(String url) {
        this.url = url;
        this.type = 1;
    }

    @Override
    public IPDFPage getPage(IPDFFile ipdfFile) {
        if (this.type == 1) {
            return null;
        }
        PDFFile pdfFile = ((SunPDFFile)ipdfFile).pdfFile;
        PDFObject o = this.dest.getPage();
        if (o != null) {
            int pageNr;
            block6: {
                try {
                    pageNr = pdfFile.getPageNumber(o) + 1;
                    if (pageNr >= 1) break block6;
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            if (pageNr > pdfFile.getNumPages()) {
                pageNr = pdfFile.getNumPages();
            }
            PDFPage page = pdfFile.getPage(pageNr);
            return new SunPDFPage(page);
        }
        return null;
    }

    @Override
    public Rectangle2D getPosition() {
        if (this.type == 1) {
            return null;
        }
        return new Rectangle(Math.round(this.dest.getLeft()), Math.round(this.dest.getTop()), 1, 1);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getURL() {
        return this.url;
    }
}

