/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.sun;

import com.sun.pdfview.ImageInfo;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import com.sun.pdfview.RefImage;
import com.sun.pdfview.annotation.PDFAnnotation;
import de.vonloesch.pdf4eclipse.Messages;
import de.vonloesch.pdf4eclipse.model.IPDFLinkAnnotation;
import de.vonloesch.pdf4eclipse.model.IPDFPage;
import de.vonloesch.pdf4eclipse.model.sun.SunPDFLinkAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.List;

public class SunPDFPage
implements IPDFPage {
    PDFPage page;
    AffineTransform currentXform;
    AffineTransform currentTform;

    public SunPDFPage(PDFPage page) {
        this.page = page;
    }

    @Override
    public BufferedImage getImage(int height, int width) {
        Dimension pageSize = this.page.getUnstretchedSize(width, height, null);
        ImageInfo info = new ImageInfo(pageSize.width, pageSize.height, null, Color.WHITE);
        PDFRenderer r = null;
        BufferedImage currentImage = null;
        if (this.page.renderers.containsKey(info)) {
            r = (PDFRenderer)((WeakReference)this.page.renderers.get(info)).get();
        }
        if (r != null) {
            currentImage = r.getImage();
        }
        if (currentImage == null) {
            currentImage = new RefImage(pageSize.width, pageSize.height, 6);
            this.page.renderers.clear();
            r = new PDFRenderer(this.page, info, currentImage);
            this.page.renderers.put(info, new WeakReference<PDFRenderer>(r));
        }
        this.currentTform = this.page.getInitialTransform(pageSize.width, pageSize.height, null);
        try {
            this.currentXform = this.currentTform.createInverse();
        }
        catch (NoninvertibleTransformException nte) {
            System.out.println(Messages.PDFPageViewer_Error1);
            nte.printStackTrace();
        }
        if (r.getStatus() != 6) {
            r.go(true);
            if (r.getStatus() != 6) {
                return null;
            }
        }
        return currentImage;
    }

    @Override
    public Rectangle2D image2PdfCoordinates(Rectangle2D r) {
        r.setFrame(r.getX(), r.getY(), 1.0, 1.0);
        Rectangle2D tr = this.currentXform.createTransformedShape(r).getBounds2D();
        tr.setFrame(tr.getX(), tr.getY(), tr.getWidth(), tr.getHeight());
        return tr;
    }

    @Override
    public Rectangle2D pdf2ImageCoordinates(Rectangle2D r) {
        Rectangle2D tr = this.currentTform.createTransformedShape(r).getBounds2D();
        tr.setFrame(tr.getX(), tr.getY(), tr.getWidth(), tr.getHeight());
        return tr;
    }

    @Override
    public int getPageNumber() {
        return this.page.getPageNumber();
    }

    @Override
    public float getWidth() {
        return this.page.getWidth();
    }

    @Override
    public float getHeight() {
        return this.page.getHeight();
    }

    @Override
    public IPDFLinkAnnotation[] getAnnotations() {
        List annos = this.page.getAnnots(1);
        IPDFLinkAnnotation[] annotations = new SunPDFLinkAnnotation[annos.size()];
        int i = 0;
        while (i < annotations.length) {
            annotations[i] = new SunPDFLinkAnnotation((PDFAnnotation)annos.get(i));
            ++i;
        }
        return annotations;
    }
}

