/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.imageviewer;

import com.abstratt.content.IContentProviderRegistry;
import com.abstratt.content.PlaceholderProviderDescription;
import com.abstratt.imageviewer.AbstractGraphicalContentProvider;
import com.abstratt.imageviewer.GraphicalView;
import com.abstratt.imageviewer.IGraphicalContentProvider;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class SaveToFileAction
implements IViewActionDelegate {
    private GraphicalView view;

    public void init(IViewPart view) {
        this.view = (GraphicalView)view;
    }

    public void run(IAction action) {
        IFile selectedFile;
        IContentProviderRegistry.IProviderDescription providerDefinition = this.view.getContentProviderDescription();
        IGraphicalContentProvider contentProvider = this.view.getContentProvider();
        if (providerDefinition == null) {
            providerDefinition = new PlaceholderProviderDescription(this.view.getInput(), (IContentProvider)contentProvider);
        }
        String suggestedName = (selectedFile = this.view.getSelectedFile()) == null ? "image" : selectedFile.getLocation().removeFileExtension().lastSegment();
        boolean pathIsValid = false;
        IPath path = null;
        IGraphicalContentProvider.GraphicFileFormat fileFormat = null;
        while (!pathIsValid) {
            FileDialog saveDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            saveDialog.setText("Choose a location to save to");
            saveDialog.setFileName(suggestedName);
            saveDialog.setFilterExtensions((String[])contentProvider.getSupportedFormats().stream().map(it -> "*." + it.getExtension()).toArray(String[]::new));
            String pathString = saveDialog.open();
            if (pathString == null) {
                return;
            }
            path = Path.fromOSString((String)pathString);
            if (path.toFile().isDirectory()) {
                MessageDialog.openError(null, (String)"Invalid file path", (String)"Location is already in use by a directory");
                continue;
            }
            fileFormat = IGraphicalContentProvider.GraphicFileFormat.byExtension(path.getFileExtension());
            if (fileFormat == null) {
                MessageDialog.openError(null, (String)"Invalid file extension", (String)("Supported file formats are: " + contentProvider.getSupportedFormats().toString()));
                continue;
            }
            File parentDir = path.toFile().getParentFile();
            parentDir.mkdirs();
            if (parentDir.isDirectory()) {
                pathIsValid = true;
                continue;
            }
            MessageDialog.openError(null, (String)"Invalid file path", (String)"Could not create directory");
        }
        new SaveImageJob(fileFormat, path, providerDefinition).schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private class SaveImageJob
    extends Job {
        private IContentProviderRegistry.IProviderDescription providerDefinition;
        private IPath path;
        private IGraphicalContentProvider.GraphicFileFormat fileFormat;

        public SaveImageJob(IGraphicalContentProvider.GraphicFileFormat fileFormat, IPath path, IContentProviderRegistry.IProviderDescription providerDefinition) {
            super("Image saving job");
            this.fileFormat = fileFormat;
            this.path = path;
            this.providerDefinition = providerDefinition;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("saving image", 100);
            SaveImageJob.getJobManager().beginRule(AbstractGraphicalContentProvider.CONTENT_LOADING_RULE, monitor);
            try {
                try {
                    IGraphicalContentProvider provider = (IGraphicalContentProvider)this.providerDefinition.getProvider();
                    Object input = this.providerDefinition.read((Object)SaveToFileAction.this.view.getSelectedFile());
                    provider.saveImage(Display.getDefault(), new Point(0, 0), input, this.path, this.fileFormat);
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    SaveImageJob.getJobManager().endRule(AbstractGraphicalContentProvider.CONTENT_LOADING_RULE);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                SaveImageJob.getJobManager().endRule(AbstractGraphicalContentProvider.CONTENT_LOADING_RULE);
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

