/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.graphviz;

import com.abstratt.pluginutils.LogUtils;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class GraphVizActivator
implements BundleActivator {
    public static final String DOT_SEARCH_METHOD = "dotSearchMethod";
    public static final String DOT_MANUAL_PATH = "dotManualPath";
    public static final String DOT_FILE_NAME = "dot";
    public static final String COMMAND_LINE = "commandLineExtension";
    public static String ID = GraphVizActivator.class.getPackage().getName();
    private static GraphVizActivator instance;
    private String autodetectedDotLocation;

    public static GraphVizActivator getInstance() {
        return instance;
    }

    public static boolean isExecutable(File file) {
        if (!file.isFile()) {
            return false;
        }
        if (Platform.getOS().equals("win32")) {
            return true;
        }
        return Files.isExecutable(file.toPath());
    }

    public static void logUnexpected(String message, Exception e) {
        LogUtils.logError((String)ID, (String)message, (Throwable)e);
    }

    public GraphVizActivator() {
        instance = this;
    }

    public String autodetectDots() {
        this.autodetectedDotLocation = null;
        String paths = System.getenv("PATH");
        String[] stringArray = paths.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File directory = new File(path);
            File[] matchingFiles = directory.listFiles(new ExecutableFinder(DOT_FILE_NAME));
            if (matchingFiles != null && matchingFiles.length > 0) {
                File found = matchingFiles[0];
                this.autodetectedDotLocation = found.getAbsolutePath();
                break;
            }
            ++n2;
        }
        return this.autodetectedDotLocation;
    }

    public IPath getDotLocation() {
        String manualLocation = this.getManualDotPath();
        DotMethod dotSearchMethod = this.getDotSearchMethod();
        switch (dotSearchMethod) {
            case AUTO: {
                return this.autodetectedDotLocation != null ? new Path(this.autodetectedDotLocation) : null;
            }
            case MANUAL: {
                return manualLocation != null ? new Path(manualLocation) : null;
            }
        }
        throw new IllegalStateException("Unexpected value for dotSearchMethod: " + (Object)((Object)dotSearchMethod));
    }

    public DotMethod getDotSearchMethod() {
        String value = this.getPreference(DOT_SEARCH_METHOD);
        return value != null ? DotMethod.find(value) : DotMethod.AUTO;
    }

    public File getGraphVizDirectory() {
        IPath dotLocation = this.getDotLocation();
        return dotLocation == null ? null : dotLocation.removeLastSegments(1).toFile();
    }

    public String getManualDotPath() {
        return this.getPreference(DOT_MANUAL_PATH);
    }

    public String getCommandLineExtension() {
        return this.getPreference(COMMAND_LINE);
    }

    public void setCommandLineExtension(String commandLineExtension) {
        this.setPreference(COMMAND_LINE, commandLineExtension);
    }

    public String getPreference(String preference_name) {
        Preferences node = Platform.getPreferencesService().getRootNode().node("instance").node(ID);
        return node.get(preference_name, null);
    }

    public void setDotSearchMethod(DotMethod dotMethod) {
        this.setPreference(DOT_SEARCH_METHOD, dotMethod.name());
    }

    public void setManualDotPath(String newLocation) {
        this.setPreference(DOT_MANUAL_PATH, newLocation);
    }

    public void setPreference(String preferenceName, String value) {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences node = root.node("instance").node(ID);
        try {
            node.sync();
            node.put(preferenceName, value);
            node.flush();
        }
        catch (BackingStoreException e) {
            LogUtils.logError((String)ID, (String)"Error updating preferences.", (Throwable)e);
        }
    }

    public void start(BundleContext context) throws Exception {
        this.autodetectDots();
        if (this.autodetectedDotLocation != null) {
            LogUtils.logInfo((String)this.getClass().getPackage().getName(), (String)("Detected dot at " + this.autodetectedDotLocation), null);
        } else if (this.getDotSearchMethod() == DotMethod.AUTO) {
            LogUtils.logWarning((String)ID, (String)"Could not find a suitable dot executable.  Please specify one using Window -> Preferences -> Graphviz.", null);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    public static enum DotMethod {
        AUTO,
        MANUAL;


        public static DotMethod find(String term) {
            DotMethod[] dotMethodArray = DotMethod.values();
            int n = dotMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                DotMethod p = dotMethodArray[n2];
                if (p.name().equals(term)) {
                    return p;
                }
                ++n2;
            }
            return AUTO;
        }
    }

    private static class ExecutableFinder
    implements FileFilter {
        private String nameToMatch;

        public ExecutableFinder(String nameToMatch) {
            this.nameToMatch = nameToMatch;
        }

        @Override
        public boolean accept(File candidate) {
            if (!candidate.getName().equalsIgnoreCase(this.nameToMatch) && !candidate.getName().startsWith(String.valueOf(this.nameToMatch) + '.')) {
                return false;
            }
            boolean executable = GraphVizActivator.isExecutable(candidate);
            return executable;
        }
    }
}

