/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.output;

import java.io.PrintStream;
import tla2sany.output.LogLevel;
import tla2sany.output.SanyOutput;
import tla2sany.output.SilentSanyOutput;

public class SimpleSanyOutput
implements SanyOutput {
    private final PrintStream out;
    private final LogLevel logLevel;

    public SimpleSanyOutput(PrintStream out, LogLevel logLevel) {
        if (null == out) {
            throw new IllegalArgumentException("out stream cannot be null");
        }
        this.out = out;
        this.logLevel = logLevel;
    }

    @Override
    public void log(LogLevel level, String format, Object ... args) {
        this.getStream(level).println(String.format(format, args));
    }

    @Override
    public PrintStream getStream(LogLevel level) {
        return level.ordinal() >= this.logLevel.ordinal() ? this.out : SilentSanyOutput.NullOutputStream;
    }
}

