/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import tla2sany.parser.Operator;
import util.UniqueString;

public class Operators {
    public static final int assocNone = 0;
    public static final int assocLeft = 1;
    public static final int assocRight = 2;
    public static final int nofix = 0;
    public static final int prefix = 1;
    public static final int postfix = 2;
    public static final int infix = 3;
    public static final int nfix = 4;
    private static final Hashtable<UniqueString, Operator> DefinitionTable = new Hashtable();
    private static final Operator[] CanonicalOperators = new Operator[]{new Operator("[", 160, 160, 1, 2), new Operator(".", 170, 170, 1, 3), new Operator("'", 150, 150, 0, 2), new Operator("^", 140, 140, 0, 3), new Operator("/", 130, 130, 0, 3), new Operator("*", 130, 130, 1, 3), new Operator("-", 110, 110, 1, 3), new Operator("-.", 120, 120, 0, 1), new Operator("+", 100, 100, 1, 3), new Operator("=", 50, 50, 0, 3), new Operator("\\lnot", 40, 40, 1, 1), new Operator("\\land", 30, 30, 1, 3), new Operator("\\lor", 30, 30, 1, 3), new Operator("~>", 20, 20, 0, 3), new Operator("=>", 10, 10, 0, 3), new Operator("[]", 40, 150, 0, 1), new Operator("<>", 40, 150, 0, 1), new Operator("ENABLED", 40, 150, 0, 1), new Operator("UNCHANGED", 40, 150, 0, 1), new Operator("SUBSET", 100, 130, 0, 1), new Operator("UNION", 100, 130, 0, 1), new Operator("DOMAIN", 100, 130, 0, 1), new Operator("^+", 150, 150, 0, 2), new Operator("^*", 150, 150, 0, 2), new Operator("^#", 150, 150, 0, 2), new Operator("\\cdot", 50, 140, 1, 3), new Operator("\\equiv", 20, 20, 0, 3), new Operator("-+->", 20, 20, 0, 3), new Operator("/=", 50, 50, 0, 3), new Operator("\\subseteq", 50, 50, 0, 3), new Operator("\\in", 50, 50, 0, 3), new Operator("\\notin", 50, 50, 0, 3), new Operator("<", 50, 50, 0, 3), new Operator("\\leq", 50, 50, 0, 3), new Operator(">", 50, 50, 0, 3), new Operator("\\geq", 50, 50, 0, 3), new Operator("\\times", 100, 130, 1, 4), new Operator("\\", 80, 80, 0, 3), new Operator("\\intersect", 80, 80, 1, 3), new Operator("\\union", 80, 80, 1, 3), new Operator("...", 90, 90, 0, 3), new Operator("..", 90, 90, 0, 3), new Operator("|", 100, 110, 1, 3), new Operator("||", 100, 110, 1, 3), new Operator("&&", 130, 130, 1, 3), new Operator("&", 130, 130, 1, 3), new Operator("$$", 90, 130, 1, 3), new Operator("$", 90, 130, 1, 3), new Operator("??", 90, 130, 1, 3), new Operator("%%", 100, 110, 1, 3), new Operator("%", 100, 110, 0, 3), new Operator("##", 90, 130, 1, 3), new Operator("++", 100, 100, 1, 3), new Operator("--", 110, 110, 1, 3), new Operator("**", 130, 130, 1, 3), new Operator("//", 130, 130, 0, 3), new Operator("^^", 140, 140, 0, 3), new Operator("@@", 60, 60, 1, 3), new Operator("!!", 90, 130, 0, 3), new Operator("|-", 50, 50, 0, 3), new Operator("|=", 50, 50, 0, 3), new Operator("-|", 50, 50, 0, 3), new Operator("=|", 50, 50, 0, 3), new Operator("<:", 70, 70, 0, 3), new Operator(":>", 70, 70, 0, 3), new Operator(":=", 50, 50, 0, 3), new Operator("::=", 50, 50, 0, 3), new Operator("\\oplus", 100, 100, 1, 3), new Operator("\\ominus", 110, 110, 1, 3), new Operator("\\odot", 130, 130, 1, 3), new Operator("\\oslash", 130, 130, 0, 3), new Operator("\\otimes", 130, 130, 1, 3), new Operator("\\uplus", 90, 130, 1, 3), new Operator("\\sqcap", 90, 130, 1, 3), new Operator("\\sqcup", 90, 130, 1, 3), new Operator("\\div", 130, 130, 0, 3), new Operator("\\wr", 90, 140, 0, 3), new Operator("\\star", 130, 130, 1, 3), new Operator("\\o", 130, 130, 1, 3), new Operator("\\bigcirc", 130, 130, 1, 3), new Operator("\\bullet", 130, 130, 1, 3), new Operator("\\prec", 50, 50, 0, 3), new Operator("\\succ", 50, 50, 0, 3), new Operator("\\preceq", 50, 50, 0, 3), new Operator("\\succeq", 50, 50, 0, 3), new Operator("\\sim", 50, 50, 0, 3), new Operator("\\simeq", 50, 50, 0, 3), new Operator("\\ll", 50, 50, 0, 3), new Operator("\\gg", 50, 50, 0, 3), new Operator("\\asymp", 50, 50, 0, 3), new Operator("\\subset", 50, 50, 0, 3), new Operator("\\supset", 50, 50, 0, 3), new Operator("\\supseteq", 50, 50, 0, 3), new Operator("\\approx", 50, 50, 0, 3), new Operator("\\cong", 50, 50, 0, 3), new Operator("\\sqsubset", 50, 50, 0, 3), new Operator("\\sqsubseteq", 50, 50, 0, 3), new Operator("\\sqsupset", 50, 50, 0, 3), new Operator("\\sqsupseteq", 50, 50, 0, 3), new Operator("\\doteq", 50, 50, 0, 3), new Operator("\\propto", 50, 50, 0, 3)};
    private static final String[][] OperatorSynonyms = new String[][]{{"\\lnot", "~", "\\neg", "\u00ac"}, {"[]", "\u25a1"}, {"<>", "\u25c7"}, {"\\land", "/\\", "\u2227"}, {"\\lor", "\\/", "\u2228"}, {"\\equiv", "<=>", "\u2261", "\u21d4"}, {"/=", "#", "\u2260"}, {"\\leq", "<=", "=<", "\u2264"}, {"\\geq", ">=", "\u2265"}, {"\\times", "\\X", "\u00d7"}, {"\\intersect", "\\cap", "\u2229"}, {"\\union", "\\cup", "\u222a"}, {"\\o", "\\circ", "\u2218"}, {"\\oplus", "(+)", "\u2295"}, {"\\ominus", "(-)", "\u2296"}, {"\\odot", "(.)", "\u2299"}, {"\\oslash", "(/)", "\u2298"}, {"\\otimes", "(\\X)", "\u2297"}, {"\\approx", "\u2248"}, {":=", "\u2254"}, {"\\asymp", "\u224d"}, {"\\bigcirc", "\u25ef"}, {"::=", "\u2a74"}, {"\\bullet", "\u25cf"}, {"\\cdot", "\u22c5"}, {"\\cong", "\u2245"}, {"\\div", "\u00f7"}, {"\\doteq", "\u2250"}, {"..", "\u2025"}, {"...", "\u2026"}, {"!!", "\u203c"}, {"\\gg", "\u226b"}, {"=>", "\u21d2"}, {"\\in", "\u2208"}, {"=|", "\u2ae4"}, {"~>", "\u219d"}, {"\\ll", "\u226a"}, {"-|", "\u22a3"}, {"\\notin", "\u2209"}, {"-+->", "\u21f8"}, {"\\prec", "\u227a"}, {"\\preceq", "\u2aaf"}, {"\\propto", "\u221d"}, {"??", "\u2047"}, {"|=", "\u22a8"}, {"|-", "\u22a2"}, {"\\sim", "\u223c"}, {"\\simeq", "\u2243"}, {"\\sqcap", "\u2293"}, {"\\sqcup", "\u2294"}, {"\\sqsubset", "\u228f"}, {"\\sqsubseteq", "\u2291"}, {"\\sqsupset", "\u2290"}, {"\\sqsupseteq", "\u2292"}, {"\\star", "\u22c6"}, {"\\subset", "\u2282"}, {"\\subseteq", "\u2286"}, {"\\succ", "\u227b"}, {"\\succeq", "\u2ab0"}, {"\\supset", "\u2283"}, {"\\supseteq", "\u2287"}, {"\\uplus", "\u228e"}, {"||", "\u2016"}, {"\\wr", "\u2240"}, {"^+", "\u207a"}};

    public static Operator getOperator(UniqueString name) {
        return DefinitionTable.get(name);
    }

    public static Operator getMixfix(Operator op) {
        if (op.isPrefix()) {
            return op;
        }
        UniqueString id = op.getIdentifier().concat(".");
        return DefinitionTable.get(id);
    }

    public static boolean existsOperator(UniqueString name) {
        return DefinitionTable.containsKey(name);
    }

    public static UniqueString resolveSynonym(UniqueString name) {
        Operator op = DefinitionTable.get(name);
        return null == op ? name : op.getIdentifier();
    }

    public static void printTable() {
        System.out.println("printing Operators table");
        Enumeration<UniqueString> Enum2 = DefinitionTable.keys();
        while (Enum2.hasMoreElements()) {
            System.out.println("-> " + Enum2.nextElement().toString());
        }
    }

    static {
        for (Operator operator : CanonicalOperators) {
            DefinitionTable.put(operator.getIdentifier(), operator);
        }
        for (Operator operator : OperatorSynonyms) {
            UniqueString canonical = UniqueString.uniqueStringOf((String)((Object)operator[0]));
            Operator canonicalOp = DefinitionTable.get(canonical);
            if (null == canonicalOp) {
                throw new RuntimeException("Error during static initialization of definitions table: attempted to add synonym for nonexistent canonical operator " + canonical.toString());
            }
            for (int i = 1; i < ((Operator)operator).length; ++i) {
                UniqueString synonym = UniqueString.uniqueStringOf((String)((Object)operator[i]));
                DefinitionTable.put(synonym, canonicalOp);
            }
        }
    }
}

