/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import tla2sany.parser.Token;
import tla2sany.semantic.ASTConstants;
import tla2sany.st.Location;
import tla2sany.st.SyntaxTreeConstants;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import util.UniqueString;

public class SyntaxTreeNode
implements TreeNode,
SyntaxTreeConstants,
ASTConstants {
    private static SyntaxTreeNode[] nullArray = new SyntaxTreeNode[0];
    protected SyntaxTreeNode[] zero;
    protected SyntaxTreeNode[] one;
    int kind = 0;
    public UniqueString image = null;
    public UniqueString originalImage = null;
    int[] location = new int[4];
    private UniqueString fileName = null;
    private static final String[] ns = new String[0];
    private String[] preComment = ns;
    private int proofLevel = -1;
    private int level = -1;
    private TreeNode parent;
    public static SyntaxTreeNode nullSTN = new SyntaxTreeNode(UniqueString.uniqueStringOf("***I do not exist***"));
    private static Token nullToken = new Token();

    void setProofLevel(int proofLevel) {
        this.proofLevel = proofLevel;
    }

    @Override
    public int getProofLevel() {
        return this.proofLevel;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int lvl) {
        int i;
        this.level = lvl;
        for (i = 0; this.zero != null && i < this.zero.length; ++i) {
            this.zero[i].setLevel(lvl + 1);
        }
        for (i = 0; this.one != null && i < this.one.length; ++i) {
            this.one[i].setLevel(lvl + 1);
        }
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent() {
        int i;
        for (i = 0; this.zero != null && i < this.zero.length; ++i) {
            this.zero[i].parent = this;
            this.zero[i].setParent();
        }
        for (i = 0; this.one != null && i < this.one.length; ++i) {
            this.one[i].parent = this;
            this.one[i].setParent();
        }
    }

    public SyntaxTreeNode() {
        this.zero = nullArray;
        this.one = nullArray;
    }

    public SyntaxTreeNode(UniqueString fn) {
        this.kind = 0;
        this.image = fn;
        this.zero = nullArray;
        this.one = nullArray;
        this.location[0] = 0;
        this.location[1] = 0;
        this.location[2] = 0;
        this.location[3] = 0;
        this.fileName = UniqueString.uniqueStringOf("--TLA+ BUILTINS--");
    }

    public SyntaxTreeNode(UniqueString fn, Token t) {
        this.kind = t.kind;
        this.image = UniqueString.uniqueStringOf(t.image);
        this.zero = nullArray;
        this.one = nullArray;
        this.location[0] = t.beginLine;
        this.location[1] = t.beginColumn;
        this.location[2] = t.endLine;
        this.location[3] = t.endColumn;
        this.fileName = fn;
        this.preComment = this.comments(t);
    }

    public SyntaxTreeNode(UniqueString fn, int kind, Token t) {
        this.kind = kind;
        this.image = UniqueString.uniqueStringOf(t.image);
        this.zero = nullArray;
        this.one = nullArray;
        this.location[0] = t.beginLine;
        this.location[1] = t.beginColumn;
        this.location[2] = t.endLine;
        this.location[3] = t.endColumn;
        this.fileName = fn;
        this.preComment = this.comments(t);
    }

    public SyntaxTreeNode(UniqueString fn, int kind, SyntaxTreeNode[] a) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.zero = a;
        this.fileName = fn;
        this.updateLocation();
    }

    public SyntaxTreeNode(int kind, SyntaxTreeNode[] a) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.zero = a;
        this.fileName = a[0].fileName;
        this.updateLocation();
    }

    public SyntaxTreeNode(int kind, SyntaxTreeNode[] a, boolean ignored) {
        this.kind = kind;
        this.zero = a;
    }

    public SyntaxTreeNode(UniqueString fn, int kind, SyntaxTreeNode a, SyntaxTreeNode[] b) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        if (a != null) {
            this.zero = new SyntaxTreeNode[1];
            this.zero[0] = a;
        }
        this.one = b;
        this.fileName = fn;
        this.updateLocation();
    }

    public SyntaxTreeNode(UniqueString fn, int kind, SyntaxTreeNode[] a, SyntaxTreeNode[] b) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.zero = a;
        this.one = b;
        this.fileName = fn;
        this.updateLocation();
    }

    public SyntaxTreeNode(int kind, SyntaxTreeNode a, SyntaxTreeNode b) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.fileName = a.fileName;
        this.zero = new SyntaxTreeNode[2];
        this.zero[0] = a;
        this.zero[1] = b;
        this.updateLocation();
    }

    public SyntaxTreeNode(int kind, SyntaxTreeNode a, SyntaxTreeNode b, SyntaxTreeNode c) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.fileName = a.fileName;
        this.zero = new SyntaxTreeNode[3];
        this.zero[0] = a;
        this.zero[1] = b;
        this.zero[2] = c;
        this.updateLocation();
    }

    @Override
    public final int getKind() {
        return this.kind;
    }

    final void setKind(int k) {
        this.kind = k;
    }

    @Override
    public final boolean isKind(int k) {
        return this.kind == k;
    }

    @Override
    public final String[] getPreComments() {
        return this.preComment;
    }

    public final String[] getAttachedComments() {
        if (this.kind < 327) {
            return this.preComment;
        }
        if (this.heirs().length == 0) {
            String[] res = new String[]{};
            return res;
        }
        return ((SyntaxTreeNode)this.heirs()[0]).getAttachedComments();
    }

    public boolean isGenOp() {
        return this.kind == 362 || this.kind == 360 || this.kind == 359 || this.kind == 361;
    }

    private final String[] comments(Token t) {
        Token nextPre = nullToken;
        int cPre = 0;
        if (t.specialToken == null) {
            return ns;
        }
        Token tmp_t = t.specialToken;
        while (tmp_t != null) {
            ++cPre;
            tmp_t.next = nextPre;
            nextPre = tmp_t;
            tmp_t = tmp_t.specialToken;
        }
        String[] aPre = new String[cPre];
        tmp_t = nextPre;
        cPre = 0;
        while (tmp_t != nullToken) {
            aPre[cPre] = tmp_t.image;
            ++cPre;
            tmp_t = tmp_t.next;
        }
        return aPre;
    }

    public final SyntaxTreeNode[] getHeirs() {
        SyntaxTreeNode[] result;
        if (this.zero == null && this.one == null) {
            return nullArray;
        }
        if (this.zero != null) {
            if (this.one != null) {
                result = new SyntaxTreeNode[this.zero.length + this.one.length];
                System.arraycopy(this.zero, 0, result, 0, this.zero.length);
                System.arraycopy(this.one, 0, result, this.zero.length, this.one.length);
            } else {
                result = new SyntaxTreeNode[this.zero.length];
                System.arraycopy(this.zero, 0, result, 0, this.zero.length);
            }
        } else {
            result = new SyntaxTreeNode[this.one.length];
            System.arraycopy(this.one, 0, result, 0, this.one.length);
        }
        return result;
    }

    @Override
    public final TreeNode[] heirs() {
        TreeNode[] result;
        if (this.zero == null && this.one == null) {
            return nullArray;
        }
        if (this.zero != null) {
            if (this.one != null) {
                result = new SyntaxTreeNode[this.zero.length + this.one.length];
                System.arraycopy(this.zero, 0, result, 0, this.zero.length);
                System.arraycopy(this.one, 0, result, this.zero.length, this.one.length);
            } else {
                result = new SyntaxTreeNode[this.zero.length];
                System.arraycopy(this.zero, 0, result, 0, this.zero.length);
            }
        } else {
            result = new SyntaxTreeNode[this.one.length];
            System.arraycopy(this.one, 0, result, 0, this.one.length);
        }
        return result;
    }

    @Override
    public final String getFilename() {
        return this.fileName.toString();
    }

    public final UniqueString getFN() {
        return this.fileName;
    }

    @Override
    public final Location getLocation() {
        return new Location(this.fileName, this.location[0], this.location[1], this.location[2], this.location[3]);
    }

    @Override
    public final String getImage() {
        return this.image.toString();
    }

    @Override
    public final UniqueString getUS() {
        return this.image;
    }

    public final SyntaxTreeNode first() {
        if (this.zero != null) {
            return this.zero[0];
        }
        return this.one[0];
    }

    @Override
    public String getHumanReadableImage() {
        if (this.zero != null && this.zero.length > 0) {
            StringBuffer buf = new StringBuffer(this.zero.length);
            for (SyntaxTreeNode z : this.zero) {
                buf.append(z.getHumanReadableImage());
            }
            if (this.one != null && this.one.length > 0) {
                for (SyntaxTreeNode o : this.one) {
                    buf.append(o.getHumanReadableImage());
                }
            }
            return buf.toString();
        }
        String string = this.image.toString();
        if (string.startsWith("N_")) {
            return "";
        }
        if (string.startsWith("Not a node")) {
            return "";
        }
        if (string.startsWith("Token")) {
            return "";
        }
        return string;
    }

    private void updateLocation() {
        int lvi = 0;
        this.location[0] = Integer.MAX_VALUE;
        this.location[1] = Integer.MAX_VALUE;
        this.location[2] = Integer.MIN_VALUE;
        this.location[3] = Integer.MIN_VALUE;
        if (this.zero != null) {
            for (lvi = 0; lvi < this.zero.length; ++lvi) {
                if (this.zero[lvi].location[0] < this.location[0] || this.zero[lvi].location[0] == this.location[0] && this.zero[lvi].location[1] < this.location[1]) {
                    this.location[0] = this.zero[lvi].location[0];
                    this.location[1] = this.zero[lvi].location[1];
                }
                if (this.zero[lvi].location[2] <= this.location[2] && (this.zero[lvi].location[2] != this.location[2] || this.zero[lvi].location[3] <= this.location[3])) continue;
                this.location[2] = this.zero[lvi].location[2];
                this.location[3] = this.zero[lvi].location[3];
            }
        }
        if (this.one != null) {
            for (lvi = 0; lvi < this.one.length; ++lvi) {
                if (this.one[lvi].location[0] < this.location[0] || this.one[lvi].location[0] == this.location[0] && this.one[lvi].location[1] < this.location[1]) {
                    this.location[0] = this.one[lvi].location[0];
                    this.location[1] = this.one[lvi].location[1];
                }
                if (this.one[lvi].location[2] <= this.location[2] && (this.one[lvi].location[2] != this.location[2] || this.one[lvi].location[3] <= this.location[3])) continue;
                this.location[2] = this.one[lvi].location[2];
                this.location[3] = this.one[lvi].location[3];
            }
        }
    }

    @Override
    public final TreeNode[] one() {
        return this.one;
    }

    @Override
    public final TreeNode[] zero() {
        return this.zero;
    }

    @Override
    public final boolean local() {
        return this.zero != null;
    }

    @Override
    public void printST(int indentLevel) {
        int i;
        Object operator = "";
        TreeNode[] heirs = this.heirs();
        if (this.image != null && this.image.toString().equals("N_OperatorDefinition")) {
            if (((SyntaxTreeNode)this.heirs()[0]).image.toString().equals("N_IdentLHS")) {
                operator = "*" + ((SyntaxTreeNode)((SyntaxTreeNode)this.heirs()[0]).heirs()[0]).image.toString();
            }
            if (((SyntaxTreeNode)this.heirs()[1]).image.toString().equals("N_IdentLHS")) {
                operator = ((SyntaxTreeNode)((SyntaxTreeNode)this.heirs()[1]).heirs()[0]).image.toString();
            }
            if (((SyntaxTreeNode)this.heirs()[0]).image.toString().equals("N_InfixLHS")) {
                operator = ((SyntaxTreeNode)((SyntaxTreeNode)this.heirs()[0]).heirs()[1]).image.toString();
            }
        }
        for (i = 0; i < indentLevel; ++i) {
            System.out.print(Strings.blanks[2]);
        }
        System.out.print((String)(this.image == null ? "(" + SyntaxNodeImage[this.kind].toString() + ")" : this.image.toString()) + "\t" + (String)(!((String)operator).equals("") ? (String)operator + "\t" : "") + "  #heirs: " + heirs.length + "\t  kind:   " + this.kind + SyntaxTreeNode.PreCommentToString(this.preComment) + "\n");
        for (i = 0; i < heirs.length; ++i) {
            if (heirs[i] != null) {
                ((SyntaxTreeNode)heirs[i]).printST(indentLevel + 1);
                continue;
            }
            for (int j = 0; j <= indentLevel; ++j) {
                System.out.print(Strings.blanks[2]);
            }
            System.out.println("<null>");
        }
    }

    public static String PreCommentToString(String[] pcarray) {
        if (pcarray == null || pcarray.length == 0) {
            return "";
        }
        Object res = "\n preComment: ";
        for (int i = 0; i < pcarray.length; ++i) {
            res = (String)res + (i == 0 ? "" : "\n             ") + i + " " + pcarray[i];
        }
        return res;
    }

    public static String unboxComment(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int startOffset = str.indexOf("(**");
        int endOffset = str.lastIndexOf("**)");
        if (startOffset < 0 || endOffset < 0 || endOffset <= startOffset) {
            return str;
        }
        String[] lines = str.split("\\r?\\n");
        int beginLine = -1;
        int endLine = -1;
        for (int i = 0; i < lines.length; ++i) {
            if (beginLine < 0 && lines[i].contains("(**")) {
                beginLine = i;
            }
            if (!lines[i].contains("**)")) continue;
            endLine = i;
        }
        if (beginLine < 0 || endLine < 0 || beginLine >= endLine) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        for (int i = beginLine + 1; i < endLine; ++i) {
            String currentLine = lines[i];
            int beginTokenIndex = currentLine.indexOf("(*");
            int endTokenIndex = currentLine.indexOf("*)");
            if (beginTokenIndex >= 0 && endTokenIndex > beginTokenIndex) {
                int contentStart = beginTokenIndex + 3;
                if (contentStart <= endTokenIndex) {
                    String content = currentLine.substring(contentStart, endTokenIndex);
                    while (content.length() > 0 && Character.isWhitespace(content.charAt(content.length() - 1))) {
                        content = content.substring(0, content.length() - 1);
                    }
                    result.append(content);
                }
            } else {
                result.append(currentLine);
            }
            if (i >= endLine - 1) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public static String unboxBackslashStarComment(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String[] lines = str.split("\\r?\\n");
        int backslashStarLines = 0;
        for (String line : lines) {
            String trimmed = line.trim();
            if (!trimmed.startsWith("\\*")) continue;
            ++backslashStarLines;
        }
        if (backslashStarLines < lines.length / 2) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String trimmed = line.trim();
            if (trimmed.startsWith("\\*")) {
                int backslashPos = line.indexOf("\\*");
                if (backslashPos >= 0) {
                    int contentStart = backslashPos + 2;
                    if (contentStart < line.length() && line.charAt(contentStart) == ' ') {
                        ++contentStart;
                    }
                    if (contentStart < line.length()) {
                        result.append(line.substring(contentStart));
                    }
                }
            } else {
                result.append(line);
            }
            if (i >= lines.length - 1) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public String toString() {
        return this.getHumanReadableImage();
    }

    public static TreeNode getOperatorDefinition(TreeNode tn) {
        while (tn != null) {
            if (tn.getKind() == 389) {
                return tn;
            }
            tn = tn.getParent();
        }
        return null;
    }
}

