/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import tla2sany.semantic.ExprOrOpArgNode;
import tlc2.overrides.Evaluation;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.EvalException;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public class Json {
    public static final long serialVersionUID = 20210223L;

    @TLAPlusOperator(identifier="ToJson", module="Json", warn=false)
    public static StringValue toJson(IValue value) throws IOException {
        return new StringValue(Json.getNode(value).toString());
    }

    @TLAPlusOperator(identifier="ToJsonArray", module="Json", warn=false)
    public static StringValue toJsonArray(IValue value) throws IOException {
        return new StringValue(Json.getArrayNode(value).toString());
    }

    @TLAPlusOperator(identifier="ToJsonObject", module="Json", warn=false)
    public static StringValue toJsonObject(IValue value) throws IOException {
        return new StringValue(Json.getObjectNode(value).toString());
    }

    @TLAPlusOperator(identifier="ndJsonDeserialize", module="Json", warn=false)
    public static IValue ndDeserialize(StringValue path) throws IOException {
        ArrayList<Value> values = new ArrayList<Value>();
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(path.val.toString())));){
            String line = reader.readLine();
            while (line != null) {
                if (!"".equals(line = line.trim())) {
                    JsonElement node = JsonParser.parseString(line);
                    values.add(Json.getValue(node));
                }
                line = reader.readLine();
            }
        }
        return new TupleValue(values.toArray(new Value[0]));
    }

    @TLAPlusOperator(identifier="JsonDeserialize", module="Json", warn=false)
    public static IValue deserialize(StringValue path) throws IOException {
        JsonElement node = JsonParser.parseReader(new FileReader(new File(path.val.toString())));
        return Json.getValue(node);
    }

    @TLAPlusOperator(identifier="ndJsonSerialize", module="Json", warn=false)
    public static synchronized BoolValue ndSerialize(StringValue path, Value v) throws IOException {
        TupleValue value = (TupleValue)v.toTuple();
        if (value == null) {
            throw new EvalException(2169, new String[]{"second", "ndJsonSerialize", "sequence", Values.ppr(v.toString())});
        }
        File file = new File(path.val.toString());
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(path.val.toString())));){
            for (int i = 0; i < value.elems.length; ++i) {
                writer.write(Json.getNode(value.elems[i]).toString() + "\n");
            }
        }
        return BoolValue.ValTrue;
    }

    @Evaluation(definition="Serialize", module="IOUtils", warn=false, silent=true, priority=25)
    public static synchronized Value textSerialize(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Value third = tool.eval(args[2], c, s0, s1, control, cm);
        RecordValue opts = (RecordValue)third.toRcd();
        if (opts == null) {
            throw new EvalException(2169, new String[]{"third", "ndJsonSerialize", "sequence", Values.ppr(third.toString())});
        }
        StringValue serializer = (StringValue)opts.apply(new StringValue("format"), 0);
        if ("NDJSON".equals(serializer.getVal().toString())) {
            BoolValue boolValue;
            block13: {
                Value first = tool.eval(args[0], c, s0, s1, control, cm);
                TupleValue payload = (TupleValue)first.toTuple();
                if (payload == null) {
                    throw new EvalException(2169, new String[]{"first", "Serialize", "sequence", Values.ppr(first.toString())});
                }
                Value second = tool.eval(args[1], c, s0, s1, control, cm);
                if (!(second instanceof StringValue)) {
                    throw new EvalException(2169, new String[]{"second", "ndJsonSerialize", "sequence", Values.ppr(second.toString())});
                }
                StringValue filepath = (StringValue)second;
                TupleValue openOptionstv = (TupleValue)opts.apply(new StringValue("openOptions"), 0);
                StringValue charset = (StringValue)opts.apply(new StringValue("charset"), 0);
                StringValue[] openOptions = (StringValue[])Arrays.asList(openOptionstv.getElems()).stream().map(e -> (StringValue)e).toArray(StringValue[]::new);
                BufferedWriter writer = Files.newBufferedWriter(Paths.get(filepath.getVal().toString(), new String[0]), Charset.forName(charset.getVal().toString()), (OpenOption[])Arrays.asList(openOptions).stream().map(e -> StandardOpenOption.valueOf(e.getVal().toString())).toArray(StandardOpenOption[]::new));
                try {
                    for (int i = 0; i < payload.elems.length; ++i) {
                        writer.write(Json.getNode(payload.elems[i]).toString() + "\n");
                    }
                    boolValue = BoolValue.ValTrue;
                    if (writer == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
                writer.close();
            }
            return boolValue;
        }
        return null;
    }

    @TLAPlusOperator(identifier="JsonSerialize", module="Json", warn=false)
    public static synchronized BoolValue serialize(StringValue path, Value v) throws IOException {
        Value value = v.toTuple();
        if (value == null) {
            value = v.toRcd();
        }
        if (value == null) {
            throw new EvalException(2169, new String[]{"second", "JsonSerialize", "sequence or record", Values.ppr(v.toString())});
        }
        File file = new File(path.val.toString());
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(path.val.toString())));){
            writer.write(Json.getNode(v).toString());
        }
        return BoolValue.ValTrue;
    }

    private static JsonElement getNode(IValue value) throws IOException {
        if (value instanceof RecordValue) {
            return Json.getObjectNode((RecordValue)value);
        }
        if (value instanceof TupleValue) {
            return Json.getArrayNode((TupleValue)value);
        }
        if (value instanceof StringValue) {
            return new JsonPrimitive(((StringValue)value).val.toString());
        }
        if (value instanceof ModelValue) {
            return new JsonPrimitive(((ModelValue)value).val.toString());
        }
        if (value instanceof IntValue) {
            return new JsonPrimitive(((IntValue)value).val);
        }
        if (value instanceof BoolValue) {
            return new JsonPrimitive(((BoolValue)value).val);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getObjectNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getObjectNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        if (value instanceof SetEnumValue) {
            return Json.getArrayNode((SetEnumValue)value);
        }
        if (value instanceof EnumerableValue) {
            return Json.getArrayNode((SetEnumValue)((EnumerableValue)value).toSetEnum());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static boolean isValidSequence(FcnRcdValue value) {
        Value[] domain;
        for (Value d : domain = value.getDomainAsValues()) {
            if (d instanceof IntValue) continue;
            return false;
        }
        value.normalize();
        for (int i = 0; i < domain.length; ++i) {
            if (((IntValue)domain[i]).val == i + 1) continue;
            return false;
        }
        return true;
    }

    private static JsonElement getObjectNode(IValue value) throws IOException {
        if (value instanceof RecordValue) {
            return Json.getObjectNode((RecordValue)value);
        }
        if (value instanceof TupleValue) {
            return Json.getObjectNode((TupleValue)value);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getObjectNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getObjectNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static JsonElement getObjectNode(FcnRcdValue value) throws IOException {
        if (Json.isValidSequence(value)) {
            return Json.getArrayNode(value);
        }
        Value[] domain = value.getDomainAsValues();
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < domain.length; ++i) {
            Value domainValue = domain[i];
            if (domainValue instanceof StringValue) {
                jsonObject.add(((StringValue)domainValue).val.toString(), Json.getNode(value.values[i]));
                continue;
            }
            jsonObject.add(domainValue.toString(), Json.getNode(value.values[i]));
        }
        return jsonObject;
    }

    private static JsonElement getObjectNode(RecordValue value) throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < value.names.length; ++i) {
            jsonObject.add(value.names[i].toString(), Json.getNode(value.values[i]));
        }
        return jsonObject;
    }

    private static JsonElement getObjectNode(TupleValue value) throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < value.elems.length; ++i) {
            jsonObject.add(String.valueOf(i), Json.getNode(value.elems[i]));
        }
        return jsonObject;
    }

    private static JsonElement getArrayNode(IValue value) throws IOException {
        if (value instanceof TupleValue) {
            return Json.getArrayNode((TupleValue)value);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getArrayNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getArrayNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        if (value instanceof SetEnumValue) {
            return Json.getArrayNode((SetEnumValue)value);
        }
        if (value instanceof EnumerableValue) {
            return Json.getArrayNode((SetEnumValue)((EnumerableValue)value).toSetEnum());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static JsonElement getArrayNode(TupleValue value) throws IOException {
        JsonArray jsonArray = new JsonArray(value.elems.length);
        for (int i = 0; i < value.elems.length; ++i) {
            jsonArray.add(Json.getNode(value.elems[i]));
        }
        return jsonArray;
    }

    private static JsonElement getArrayNode(FcnRcdValue value) throws IOException {
        if (!Json.isValidSequence(value)) {
            return Json.getObjectNode(value);
        }
        value.normalize();
        JsonArray jsonArray = new JsonArray(value.values.length);
        for (int i = 0; i < value.values.length; ++i) {
            jsonArray.add(Json.getNode(value.values[i]));
        }
        return jsonArray;
    }

    private static JsonElement getArrayNode(SetEnumValue value) throws IOException {
        value.normalize();
        Value[] values = value.elems.toArray();
        JsonArray jsonArray = new JsonArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            jsonArray.add(Json.getNode(values[i]));
        }
        return jsonArray;
    }

    private static Value getValue(JsonElement node) throws IOException {
        if (node.isJsonArray()) {
            return Json.getTupleValue(node);
        }
        if (node.isJsonObject()) {
            return Json.getRecordValue(node);
        }
        if (node.isJsonPrimitive()) {
            JsonPrimitive primitive = node.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return IntValue.gen(primitive.getAsInt());
            }
            if (primitive.isBoolean()) {
                return new BoolValue(primitive.getAsBoolean());
            }
            if (primitive.isString()) {
                return new StringValue(primitive.getAsString());
            }
        }
        throw new IOException("Cannot convert value: unsupported JSON value " + node.toString());
    }

    private static TupleValue getTupleValue(JsonElement node) throws IOException {
        ArrayList<Value> values = new ArrayList<Value>();
        JsonArray jsonArray = node.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            values.add(Json.getValue(jsonArray.get(i)));
        }
        return new TupleValue(values.toArray(new Value[0]));
    }

    private static RecordValue getRecordValue(JsonElement node) throws IOException {
        ArrayList<UniqueString> keys = new ArrayList<UniqueString>();
        ArrayList<Value> values = new ArrayList<Value>();
        for (Map.Entry<String, JsonElement> entry : node.getAsJsonObject().entrySet()) {
            keys.add(UniqueString.uniqueStringOf(entry.getKey()));
            values.add(Json.getValue(entry.getValue()));
        }
        return new RecordValue(keys.toArray(new UniqueString[0]), values.toArray(new Value[0]), false);
    }
}

