/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tlc2.model.Assignment;
import tlc2.model.Formula;
import tlc2.model.MCState;
import tlc2.model.MCVariable;
import tlc2.model.TraceExpressionInformationHolder;
import tlc2.output.AbstractSpecWriter;
import tlc2.output.SpecWriterUtilities;
import tlc2.tool.impl.ModelConfig;

public class SpecTraceExpressionWriter
extends AbstractSpecWriter {
    private static final String TRACE_EXPRESSION_VARIABLE = "TraceExp";
    private static final String TRI_INDENT = "            ";

    public static String[] addInitNextToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, List<MCState> trace, TraceExpressionInformationHolder[] expressionData) {
        String initId = SpecWriterUtilities.getValidIdentifier("init");
        String nextId = SpecWriterUtilities.getValidIdentifier("next");
        String actionConstraintId = SpecWriterUtilities.getValidIdentifier("action_constr");
        SpecTraceExpressionWriter.addInitNextToBuffers(tlaBuffer, cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId);
        return new String[]{initId, nextId, actionConstraintId};
    }

    public static void addInitNextToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId) {
        SpecTraceExpressionWriter.addInitNextToBuffers(tlaBuffer, cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId, "next", false);
    }

    public static void addInitNextToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId, String nextSubActionBasename, boolean leaveStubsForTraceExpression) {
        StringBuilder[] tlaBuffers = SpecTraceExpressionWriter.addInitNextToBuffers(cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId, nextSubActionBasename, leaveStubsForTraceExpression);
        tlaBuffer.append(tlaBuffers[0].toString());
        tlaBuffer.append(tlaBuffers[1].toString());
    }

    public static StringBuilder[] addInitNextToBuffers(StringBuilder cfgBuffer, List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId, String nextSubActionBasename, boolean leaveStubsForTraceExpression) {
        if (trace.size() > 0) {
            String firstIndent;
            boolean isSingleState;
            MCState nextState;
            int i;
            Iterator<MCState> it = trace.iterator();
            MCState currentState = it.next();
            StringBuilder subActionsAndConstraint = new StringBuilder();
            StringBuilder initAndNext = new StringBuilder();
            if (cfgBuffer != null) {
                cfgBuffer.append("\n");
                cfgBuffer.append("\n").append("INIT").append("\n");
                cfgBuffer.append(initId).append("\n");
            }
            if (leaveStubsForTraceExpression) {
                initAndNext.append("\\* ").append("VARIABLE").append(' ');
                initAndNext.append(TRACE_EXPRESSION_VARIABLE).append("\n").append("\n");
            }
            initAndNext.append("\\* ").append("TRACE INIT definition ");
            initAndNext.append("traceExploreInit").append("\n");
            initAndNext.append(initId).append(" ==\n");
            MCVariable[] vars = currentState.getVariables();
            for (i = 0; i < vars.length; ++i) {
                MCVariable var = vars[i];
                initAndNext.append("    /\\ ");
                initAndNext.append(var.getName()).append(" = ").append("(");
                initAndNext.append("\n");
                initAndNext.append(var.getValueAsStringReIndentedAs(TRI_INDENT)).append("\n");
                initAndNext.append("    ").append("    ");
                initAndNext.append(")").append("\n");
            }
            if (expressionData != null) {
                for (i = 0; i < expressionData.length; ++i) {
                    TraceExpressionInformationHolder expressionInfo = expressionData[i];
                    initAndNext.append("    /\\ ");
                    initAndNext.append(expressionInfo.getVariableName()).append(" = ");
                    initAndNext.append("(").append("\n");
                    initAndNext.append(TRI_INDENT);
                    if (expressionInfo.getLevel() == 2) {
                        initAndNext.append("\"--\"");
                    } else {
                        initAndNext.append(expressionInfo.getIdentifier());
                    }
                    initAndNext.append("\n").append("    ").append("    ");
                    initAndNext.append(")").append("\n");
                }
            }
            if (leaveStubsForTraceExpression) {
                initAndNext.append("\\* ").append("    /\\ ");
                initAndNext.append(TRACE_EXPRESSION_VARIABLE).append(" = ");
                initAndNext.append("TRUE").append("\n");
            }
            initAndNext.append("\n----\n").append("\n");
            if (cfgBuffer != null) {
                cfgBuffer.append("\\* ").append("NEXT").append(" definition");
                cfgBuffer.append("\n").append("NEXT").append("\n");
                cfgBuffer.append(nextId).append("\n");
            }
            if (it.hasNext()) {
                nextState = it.next();
                isSingleState = false;
            } else {
                nextState = currentState;
                isSingleState = true;
            }
            StringBuilder nextDisjunctBuffer = new StringBuilder();
            nextDisjunctBuffer.append(nextId).append(" ==\n");
            if (leaveStubsForTraceExpression) {
                nextDisjunctBuffer.append("/\\").append(' ');
                firstIndent = " ";
            } else {
                firstIndent = "    ";
            }
            StringBuilder actionConstraintBuffer = new StringBuilder();
            actionConstraintBuffer.append(actionConstraintId).append(" ==\n");
            actionConstraintBuffer.append("<<").append("\n");
            if (cfgBuffer != null) {
                cfgBuffer.append("\\* ").append("Action Constraint definition").append("\n");
                cfgBuffer.append("\\* ").append("ACTION_CONSTRAINT").append("\n");
                cfgBuffer.append("\\* ").append(actionConstraintId).append("\n");
            }
            int subActionIndex = 0;
            while (nextState != null) {
                int i2;
                String nextDisjunct = String.format("%s_sa_%d", nextSubActionBasename, subActionIndex);
                nextDisjunctBuffer.append(subActionIndex == 0 ? firstIndent : "    ");
                nextDisjunctBuffer.append("\\/").append(' ').append(nextDisjunct).append("\n");
                actionConstraintBuffer.append(nextDisjunct);
                subActionsAndConstraint.append("\\* ").append("TRACE Sub-Action definition ");
                subActionsAndConstraint.append(subActionIndex++).append("\n");
                subActionsAndConstraint.append(nextDisjunct).append(" ==\n");
                if (nextState.isBackToState()) {
                    nextState = trace.get(nextState.getStateNumber() - 1);
                } else if (nextState.isStuttering()) {
                    nextState = currentState;
                }
                subActionsAndConstraint.append("    ").append("(").append("\n");
                MCVariable[] currentStateVars = currentState.getVariables();
                MCVariable[] nextStateVars = nextState.getVariables();
                for (i2 = 0; i2 < currentStateVars.length; ++i2) {
                    MCVariable currentStateVar = currentStateVars[i2];
                    subActionsAndConstraint.append("    ").append("    /\\ ");
                    subActionsAndConstraint.append(currentStateVar.getName()).append(" = ");
                    subActionsAndConstraint.append("(").append("\n");
                    subActionsAndConstraint.append(currentStateVar.getValueAsStringReIndentedAs("                "));
                    subActionsAndConstraint.append("\n");
                    subActionsAndConstraint.append(TRI_INDENT).append(")").append("\n");
                }
                if (isSingleState) {
                    subActionsAndConstraint.append("    ").append("    /\\ ");
                    subActionsAndConstraint.append("FALSE").append("\n");
                }
                for (i2 = 0; i2 < currentStateVars.length; ++i2) {
                    MCVariable nextStateVar = nextStateVars[i2];
                    subActionsAndConstraint.append("    ").append("    /\\ ");
                    subActionsAndConstraint.append(nextStateVar.getName()).append("'");
                    subActionsAndConstraint.append(" = ").append("(").append("\n");
                    subActionsAndConstraint.append(nextStateVar.getValueAsStringReIndentedAs("                "));
                    subActionsAndConstraint.append("\n");
                    subActionsAndConstraint.append(TRI_INDENT).append(")").append("\n");
                }
                if (expressionData != null) {
                    for (i2 = 0; i2 < expressionData.length; ++i2) {
                        TraceExpressionInformationHolder expressionInfo = expressionData[i2];
                        subActionsAndConstraint.append("    ").append("    /\\ ");
                        subActionsAndConstraint.append(expressionInfo.getVariableName()).append("'");
                        subActionsAndConstraint.append(" = ").append("(").append("\n");
                        subActionsAndConstraint.append(TRI_INDENT);
                        subActionsAndConstraint.append(expressionInfo.getIdentifier()).append("\n");
                        subActionsAndConstraint.append(TRI_INDENT).append(")");
                        if (expressionInfo.getLevel() < 2) {
                            subActionsAndConstraint.append("'");
                        }
                        subActionsAndConstraint.append("\n");
                    }
                }
                subActionsAndConstraint.append("    ").append(")");
                subActionsAndConstraint.append("\n").append("\n");
                if (it.hasNext()) {
                    actionConstraintBuffer.append(",");
                }
                actionConstraintBuffer.append("\n");
                currentState = nextState;
                if (it.hasNext()) {
                    nextState = it.next();
                    continue;
                }
                nextState = null;
            }
            initAndNext.append("\\* ").append("TRACE NEXT definition ");
            initAndNext.append("traceExploreNext").append("\n");
            initAndNext.append(nextDisjunctBuffer.toString());
            if (leaveStubsForTraceExpression) {
                initAndNext.append("\\* ").append("/\\").append(' ');
                initAndNext.append(TRACE_EXPRESSION_VARIABLE).append("'").append(" = ");
                initAndNext.append(TRACE_EXPRESSION_VARIABLE).append("\n");
            }
            initAndNext.append("\n").append("\n");
            subActionsAndConstraint.append("\\* ").append("TRACE Action Constraint definition ");
            subActionsAndConstraint.append("traceExploreActionConstraint");
            subActionsAndConstraint.append("\n").append(actionConstraintBuffer.toString());
            subActionsAndConstraint.append(">>").append("[TLCGet(\"level\")]");
            subActionsAndConstraint.append("\n----\n").append("\n");
            return new StringBuilder[]{subActionsAndConstraint, initAndNext};
        }
        return new StringBuilder[]{new StringBuilder(), new StringBuilder()};
    }

    public static String addTraceFunctionToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, List<MCState> input, String id, String configId) {
        List trace = input.stream().filter(state -> !state.isBackToState() && !state.isStuttering()).collect(Collectors.toList());
        if (trace.isEmpty()) {
            return SpecTraceExpressionWriter.addArrowAssignmentIdToBuffers(tlaBuffer, cfgBuffer, new Assignment("_TETrace", new String[0], "<<>>"), id, configId);
        }
        StringBuilder traceFunctionDef = new StringBuilder();
        traceFunctionDef.append("    ").append("<<").append("\n");
        for (int j = 0; j < trace.size(); ++j) {
            MCState state2 = (MCState)trace.get(j);
            traceFunctionDef.append("    ").append("(").append(state2.asSimpleRecord()).append(")");
            if (j >= trace.size() - 1) continue;
            traceFunctionDef.append(",").append("\n");
        }
        traceFunctionDef.append("\n").append("    ").append(">>");
        traceFunctionDef.append("\n----\n").append("\n");
        return SpecTraceExpressionWriter.addArrowAssignmentIdToBuffers(tlaBuffer, cfgBuffer, new Assignment("_TETrace", new String[0], traceFunctionDef.toString()), id, configId);
    }

    public SpecTraceExpressionWriter() {
        super(true);
    }

    public TraceExpressionInformationHolder[] createAndAddVariablesAndDefinitions(List<Formula> expressions, String attributeName) {
        TraceExpressionInformationHolder[] expressionData = TraceExpressionInformationHolder.createHolders(expressions, attributeName);
        this.addVariablesAndDefinitions(expressionData, attributeName, true);
        return expressionData;
    }

    @Override
    public void addPrimer(String moduleFilename, String extendedModuleName) {
        this.addPrimer(moduleFilename, extendedModuleName, new HashSet<String>());
    }

    public void addPrimer(String moduleFilename, String extendedModuleName, Set<String> extraExtendedModules) {
        if (extendedModuleName != null) {
            extraExtendedModules.add(extendedModuleName);
        }
        this.tlaBuffer.append((CharSequence)SpecWriterUtilities.getExtendingModuleContent(moduleFilename, extraExtendedModules.toArray(new String[extraExtendedModules.size()])));
    }

    public void addTraceExpressionStub(String moduleName, String teName, List<String> variables) {
        this.tlaBuffer.append(teName + " == \n");
        this.tlaBuffer.append("    [\n");
        StringBuilder localBuffer = new StringBuilder();
        localBuffer.append("\\* ").append(String.format("To hide variables of the `%s` spec from the error trace,", moduleName)).append("\n");
        localBuffer.append("\\* ").append("remove the variables below.  The trace will be written in the order").append("\n");
        localBuffer.append("\\* ").append("of the fields of this record.").append("\n");
        localBuffer.append(variables.stream().map(var -> var + " |-> " + var).collect(Collectors.joining("\n,"))).append("\n").append("\n");
        localBuffer.append("\\* ").append("Put additional constant-, state-, and action-level expressions here:").append("\n");
        localBuffer.append("\\* ").append(",_stateNumber |-> _TEPosition").append("\n");
        if (variables.size() > 0) {
            String someVar = variables.get(0);
            localBuffer.append("\\* ").append(String.format(",_%sUnchanged |-> %s = %s'", someVar, someVar, someVar)).append("\n").append("\n");
            localBuffer.append("\\* ").append(String.format("Format the `%s` variable as Json value.", someVar)).append("\n");
            localBuffer.append("\\* ").append(String.format(",_%sJson |->", someVar)).append("\n");
            localBuffer.append("\\*     ").append("LET J == INSTANCE Json").append("\n");
            localBuffer.append("\\*     ").append(String.format("IN J!ToJson(%s)", someVar)).append("\n").append("\n");
            localBuffer.append("\\* ").append("Lastly, you may build expressions over arbitrary sets of states by").append("\n");
            localBuffer.append("\\* ").append("leveraging the _TETrace operator.  For example, this is how to").append("\n");
            localBuffer.append("\\* ").append("count the number of times a spec variable changed up to the current").append("\n");
            localBuffer.append("\\* ").append("state in the trace.").append("\n");
            localBuffer.append("\\* ").append(String.format(",_%sModCount |->", someVar)).append("\n");
            localBuffer.append("\\*     ").append("LET F[s \\in DOMAIN _TETrace] ==").append("\n");
            localBuffer.append("\\*         ").append("IF s = 1 THEN 0").append("\n");
            localBuffer.append("\\*         ").append(String.format("ELSE IF _TETrace[s].%s # _TETrace[s-1].%s", someVar, someVar)).append("\n");
            localBuffer.append("\\*             ").append("THEN 1 + F[s-1] ELSE F[s-1]").append("\n");
            localBuffer.append("\\*     ").append("IN F[_TEPosition - 1]").append("\n");
        }
        this.tlaBuffer.append(SpecTraceExpressionWriter.indentString(localBuffer.toString(), 2));
        this.tlaBuffer.append("\n    ]\n\n");
    }

    public void addViewConfig(String view) {
        this.cfgBuffer.append("\n").append("VIEW").append("\n");
        this.cfgBuffer.append("    ").append(view).append("\n");
    }

    public void addView(String vars) {
        this.addViewConfig("_view");
        this.tlaBuffer.append("\n").append("_view").append(" ==\n");
        this.tlaBuffer.append("    ").append("<<").append(vars + ", IF TLCGet(\"level\") = _TTraceLassoEnd + 1 THEN _TTraceLassoStart ELSE TLCGet(\"level\")").append(">>");
        this.tlaBuffer.append("\n");
    }

    public void addFooter() {
        this.tlaBuffer.append(this.getTLAModuleClosingTag());
    }

    public void addVariablesAndDefinitions(TraceExpressionInformationHolder[] traceExpressionData, String attributeName, boolean addDefinitions) {
        if (traceExpressionData.length == 0) {
            return;
        }
        StringBuilder variableDecls = new StringBuilder();
        StringBuilder definitions = new StringBuilder();
        for (int i = 0; i < traceExpressionData.length; ++i) {
            TraceExpressionInformationHolder expressionInfo = traceExpressionData[i];
            variableDecls.append(expressionInfo.getVariableName());
            if (i != traceExpressionData.length - 1) {
                variableDecls.append(",");
            }
            if (!addDefinitions) continue;
            definitions.append("\\* ").append("TRACE EXPLORER identifier definition ");
            definitions.append("@").append(attributeName).append(":");
            definitions.append(i).append("\n");
            definitions.append(expressionInfo.getIdentifier()).append(" ==\n");
            definitions.append(expressionInfo.getExpression()).append("\n----\n").append("\n");
        }
        this.tlaBuffer.append("\\* ").append("TRACE EXPLORER variable declaration ");
        this.tlaBuffer.append("@").append(attributeName).append("\n");
        this.tlaBuffer.append("VARIABLES ").append(variableDecls.toString()).append("\n----\n").append("\n");
        if (addDefinitions) {
            this.tlaBuffer.append(definitions.toString());
        }
    }

    private void addInvariant(MCState finalState) {
        String id = SpecWriterUtilities.getValidIdentifierNoTimestamp("inv");
        this.cfgBuffer.append("\n").append("INVARIANT").append("\n");
        this.cfgBuffer.append("    ").append(id).append("\n");
        this.tlaBuffer.append("\n").append(id).append(" ==\n");
        this.tlaBuffer.append("    ").append("~").append("(").append("\n");
        this.tlaBuffer.append(SpecTraceExpressionWriter.getStateConjunction(finalState, "TLCGet(\"level\") = Len(_TETrace)")).append("\n");
        this.tlaBuffer.append("    ").append(")");
    }

    public void addProperties(List<MCState> trace) {
        this.addProperties(trace, null);
    }

    public void addProperties(List<MCState> trace, String specName) {
        MCState finalState = trace.get(trace.size() - 1);
        boolean isBackToState = finalState.isBackToState();
        boolean isStuttering = finalState.isStuttering();
        if (isStuttering) {
            this.addStutteringProperty(trace.get(trace.size() - 2));
        } else if (isBackToState) {
            this.addBackToStateProperty(trace.get(trace.size() - 2), trace.get(finalState.getStateNumber() - 1));
        } else {
            this.addInvariant(finalState);
        }
        this.tlaBuffer.append("\n----\n").append("\n");
        this.cfgBuffer.append("\n").append("CHECK_DEADLOCK").append("\n");
        this.cfgBuffer.append("    \\* ").append("CHECK_DEADLOCK").append(" off because of PROPERTY or INVARIANT above.").append("\n");
        this.cfgBuffer.append("    ").append("FALSE");
    }

    private void addStutteringProperty(MCState finalState) {
        String id = SpecWriterUtilities.getValidIdentifierNoTimestamp("prop");
        this.cfgBuffer.append("\n").append("PROPERTY").append("\n");
        this.cfgBuffer.append("    ").append(id).append("\n");
        this.tlaBuffer.append("\n").append(id).append(" ==\n");
        this.tlaBuffer.append("    ~").append("<>[]");
        this.tlaBuffer.append("(").append("\n").append(SpecTraceExpressionWriter.getStateConjunction(finalState));
        this.tlaBuffer.append("\n").append("    )");
    }

    private void addBackToStateProperty(MCState finalState, MCState backToState) {
        String id = SpecWriterUtilities.getValidIdentifierNoTimestamp("prop");
        this.cfgBuffer.append("\n").append("PROPERTY").append("\n");
        this.cfgBuffer.append("    ").append(id).append("\n");
        this.tlaBuffer.append("\n").append(id).append(" ==\n");
        StringBuilder localBuffer = new StringBuilder();
        localBuffer.append("~").append("(").append("(");
        localBuffer.append("[]<>").append("(").append("\n");
        localBuffer.append(SpecTraceExpressionWriter.getStateConjunction(finalState)).append("\n").append(")");
        localBuffer.append(")").append("/\\").append("(");
        localBuffer.append("[]<>").append("(").append("\n");
        localBuffer.append(SpecTraceExpressionWriter.getStateConjunction(backToState)).append("\n").append(")");
        localBuffer.append(")").append(")");
        this.tlaBuffer.append(SpecTraceExpressionWriter.indentString(localBuffer.toString(), 1));
    }

    public void addInfoComments(TraceExpressionInformationHolder[] traceExpressionData) {
        for (TraceExpressionInformationHolder expressionData : traceExpressionData) {
            this.tlaBuffer.append("\\* ").append(":").append(expressionData.getLevel());
            this.tlaBuffer.append(":").append(expressionData.getVariableName()).append(":");
            this.tlaBuffer.append(expressionData.getExpression()).append("\"$!@$!@$!@$!@$!\"");
            this.tlaBuffer.append("\n");
        }
    }

    public String[] addInitNext(List<MCState> trace) {
        return SpecTraceExpressionWriter.addInitNextToBuffers(this.tlaBuffer, this.cfgBuffer, trace, null);
    }

    public void addInitNext(List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId) {
        SpecTraceExpressionWriter.addInitNextToBuffers(this.tlaBuffer, this.cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId);
    }

    public void addInitNext(List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId, String nextSubActionBasename) {
        SpecTraceExpressionWriter.addInitNextToBuffers(this.tlaBuffer, this.cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId, nextSubActionBasename, true);
    }

    public void addInitNext(List<MCState> trace, String initId, String nextId, String actionConstraintId, String nextSubActionBasename) {
        this.addInitNext(trace, null, initId, nextId, actionConstraintId, nextSubActionBasename);
    }

    public void addInitNextTraceFunction(List<MCState> trace, String teSpecModuleName, List<String> vars, ModelConfig modelConfig) {
        if (this.cfgBuffer != null) {
            this.cfgBuffer.append("\n");
            this.cfgBuffer.append("\n").append("INIT").append("\n");
            this.cfgBuffer.append("    ").append("_init").append("\n");
        }
        this.tlaBuffer.append("_init").append(" ==\n");
        for (String var : vars) {
            this.tlaBuffer.append("    /\\ ");
            this.tlaBuffer.append(var).append(" = ").append("_TETrace[1].").append(var);
            this.tlaBuffer.append("\n");
        }
        this.tlaBuffer.append("----").append("\n").append("\n");
        MCState finalState = trace.get(trace.size() - 1);
        String nextId = "_next";
        if (this.cfgBuffer != null) {
            this.cfgBuffer.append("\n").append("NEXT").append("\n");
            this.cfgBuffer.append("    ").append("_next").append("\n");
        }
        this.tlaBuffer.append("_next").append(" ==\n");
        if (trace.size() == 1) {
            this.tlaBuffer.append("    ").append("    /\\ ");
            this.tlaBuffer.append("FALSE").append("\n");
        } else {
            this.tlaBuffer.append("    /\\ ").append("\\E i,j \\in DOMAIN _TETrace:").append("\n");
            this.tlaBuffer.append("    ").append("    /\\ ").append("\\/").append(" ").append("/\\").append(" j = i + 1").append("\n");
            this.tlaBuffer.append("    ").append("    ").append(" ").append(" ").append("    /\\ ").append("i = TLCGet(\"level\")").append("\n");
            if (finalState.isBackToState()) {
                this.tlaBuffer.append("    ").append("    ").append("   ").append("\\/").append(" ").append("/\\").append(" i = ").append("_TTraceLassoEnd").append("\n");
                this.tlaBuffer.append("    ").append("    ").append("  ").append("    /\\ ").append("j = ").append("_TTraceLassoStart").append("\n");
            }
            for (String var : vars) {
                this.tlaBuffer.append("    ").append("    /\\ ");
                this.tlaBuffer.append(var).append(" ").append(" = ").append("_TETrace[i].").append(var);
                this.tlaBuffer.append("\n");
                this.tlaBuffer.append("    ").append("    /\\ ");
                this.tlaBuffer.append(var).append("'");
                this.tlaBuffer.append(" = ").append("_TETrace[j].").append(var);
                this.tlaBuffer.append("\n");
            }
        }
        String jsonComment = "    \\* ";
        if (System.getProperty("TLC_TRACE_EXPLORER_JSON_UNCOMMENTED") != null) {
            jsonComment = "";
        }
        this.tlaBuffer.append("\n").append("\\* ").append("Uncomment the ASSUME below to write the states of the error trace").append("\n");
        this.tlaBuffer.append("\\* ").append("to the given file in Json format. Note that you can pass any tuple").append("\n");
        this.tlaBuffer.append("\\* ").append("to `JsonSerialize`. For example, a sub-sequence of _TETrace.").append("\n");
        this.tlaBuffer.append(jsonComment).append("ASSUME").append("\n");
        this.tlaBuffer.append(jsonComment + "    ").append("LET J == INSTANCE Json").append("\n");
        this.tlaBuffer.append(jsonComment + "        ").append(String.format("IN J!JsonSerialize(\"%s.json\", _TETrace)", teSpecModuleName)).append("\n");
        this.tlaBuffer.append("\n");
    }

    public String addTraceFunction(List<MCState> input) {
        String identifier = SpecWriterUtilities.getValidIdentifier("def_ov");
        return SpecTraceExpressionWriter.addTraceFunctionToBuffers(this.tlaBuffer, this.cfgBuffer, input, identifier, identifier);
    }

    public String addTraceFunction(List<MCState> input, String id, String configId) {
        return SpecTraceExpressionWriter.addTraceFunctionToBuffers(this.tlaBuffer, this.cfgBuffer, input, id, configId);
    }

    public void addTraceFunctionInstance(String moduleName) {
        this.tlaBuffer.append(String.format("%s ==%s%sLET %s == INSTANCE %s%s%sIN %s!%s", "_trace", "\n", "    ", moduleName, moduleName, "\n", "    ", moduleName, "trace")).append("\n").append("----").append("\n");
    }

    public void addTraceExpressionInstance(String moduleName) {
        this.tlaBuffer.append(String.format("%s ==%s%sLET %s == INSTANCE %s%s%sIN %s!%s", "_expression", "\n", "    ", moduleName, moduleName, "\n", "    ", moduleName, "expression")).append("\n").append("----").append("\n").append("\n");
    }

    private static String getStateConjunction(MCState state) {
        return SpecTraceExpressionWriter.getStateConjunction(state, null);
    }

    private static String getStateConjunction(MCState state, String prefixConjunct) {
        if (state.isBackToState()) {
            return null;
        }
        if (state.isStuttering()) {
            return null;
        }
        StringBuilder formula = new StringBuilder();
        if (prefixConjunct != null) {
            formula.append(prefixConjunct).append("\n").append("/\\").append("\n");
        }
        MCVariable[] vars = state.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            MCVariable var = vars[i];
            formula.append(var.getName()).append(" = ").append("(");
            formula.append(var.getValueAsString()).append(")");
            if (i == vars.length - 1) continue;
            formula.append("\n").append("/\\").append("\n");
        }
        return SpecTraceExpressionWriter.indentString(formula.toString(), 2);
    }

    public StringBuilder append(String str) {
        return this.tlaBuffer.append(str);
    }

    public String toString() {
        return this.tlaBuffer.toString();
    }

    public String getComment() {
        return this.tlaBuffer.toString().replaceFirst("^", "\\\\*").replaceAll("\n", "\n\\\\*");
    }

    public static String indentString(String s, int n) {
        String idnt = new String(new char[n]).replace("\u0000", "    ");
        return idnt + String.join((CharSequence)("\n" + idnt), s.split("\n"));
    }

    public void wrapConfig(String moduleFilename) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n").append("----").append(' ').append("CONFIG").append(' ');
        buffer.append(moduleFilename).append(' ').append("----").append('\n');
        this.cfgBuffer.insert(0, buffer);
        this.cfgBuffer.append(this.getTLAModuleClosingTag());
    }
}

