/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import util.FileUtil;
import util.NamedInputStream;

public class MonolithSpecExtractor {
    public static String getConfig(String configFile) {
        if (configFile.endsWith(".tla")) {
            return configFile;
        }
        return configFile + ".cfg";
    }

    public static InputStream config(InputStream in, String configName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            Object config = "";
            String line = "";
            while ((line = reader.readLine()) != null && (((String)config).isEmpty() || !line.matches("====.*"))) {
                if (((String)config).isEmpty() && line.matches("-----*\\s*CONFIG\\s+" + Pattern.quote(configName) + "\\s*-----*")) {
                    config = (String)config + " ";
                    continue;
                }
                if (((String)config).isEmpty()) continue;
                config = (String)config + line + "\n";
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)config).trim().getBytes(Charset.forName("UTF-8")));
            return byteArrayInputStream;
        }
    }

    public static NamedInputStream module(File in, String moduleName) throws IOException {
        File out = FileUtil.createTempFile(moduleName + ".tla");
        PrintWriter pw = new PrintWriter(new FileWriter(out));
        try (BufferedReader reader = new BufferedReader(new FileReader(in));){
            boolean active = false;
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (active && line.matches("====.*")) {
                    pw.println(line);
                    break;
                }
                if (!active && line.matches("-----*\\s*MODULE\\s+" + Pattern.quote(moduleName) + "\\s*----*")) {
                    active = true;
                    pw.println(line);
                    continue;
                }
                if (!active) continue;
                pw.println(line);
            }
            pw.close();
            if (!active) {
                NamedInputStream namedInputStream = null;
                return namedInputStream;
            }
            NamedInputStream namedInputStream = new NamedInputStream(out.getName(), moduleName, out);
            return namedInputStream;
        }
    }
}

