/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.PrintStream;
import util.FilenameToStream;
import util.SimpleFilenameToStream;
import util.ToolPrintStream;

public class ToolIO {
    public static final int SYSTEM = 0;
    public static final int TOOL = 1;
    private static int mode = 0;
    private static FilenameToStream defaultResolver;
    private static String userDir;
    public static PrintStream out;
    public static PrintStream err;
    private static final int InitialMaxLength = 1;
    static String[] messages;
    static int length;
    static String nextMessage;

    public static String getUserDir() {
        return userDir;
    }

    public static void setUserDir(String dir) {
        userDir = dir;
    }

    public static int getMode() {
        return mode;
    }

    public static boolean setMode(int m) {
        if (m == 0) {
            mode = m;
            out = System.out;
            err = System.err;
            return true;
        }
        if (m == 1) {
            mode = m;
            out = new ToolPrintStream();
            err = new ToolPrintStream();
            return true;
        }
        return false;
    }

    public static synchronized void reset() {
        messages = new String[1];
        length = 0;
        nextMessage = "";
    }

    public static synchronized String[] getAllMessages() {
        int retLen = length;
        if (!nextMessage.equals("")) {
            ++retLen;
        }
        String[] ret = new String[retLen];
        System.arraycopy(messages, 0, ret, 0, retLen);
        if (!nextMessage.equals("")) {
            ret[ToolIO.length] = nextMessage;
        }
        return ret;
    }

    public static synchronized void printAllMessages() {
        System.out.println("---- Begin all messages");
        String[] msgs = ToolIO.getAllMessages();
        for (int i = 0; i < msgs.length; ++i) {
            System.out.println("Msg " + i + ":");
            System.out.println(msgs[i]);
        }
        System.out.println("---- End all messages");
    }

    public static FilenameToStream getDefaultResolver() {
        if (defaultResolver == null) {
            ToolIO.setDefaultResolver(null);
        }
        return defaultResolver;
    }

    public static void setDefaultResolver(FilenameToStream resolver) {
        if (resolver == null) {
            resolver = new SimpleFilenameToStream();
        }
        defaultResolver = resolver;
    }

    static {
        userDir = null;
        out = System.out;
        err = System.err;
        messages = new String[1];
        length = 0;
        nextMessage = "";
    }
}

