/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.pluginutils;

import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class LogUtils {
    public static void log(int severity, String pluginId, Supplier<String> message, Throwable exception) {
        LogUtils.log(() -> new Status(severity, pluginId, (String)message.get(), exception));
    }

    public static void log(int severity, String pluginId, String message, Throwable exception) {
        LogUtils.log(() -> new Status(severity, pluginId, message, exception));
    }

    public static void log(IStatus status) {
        LogUtils.log(() -> status);
    }

    public static void log(Supplier<IStatus> statusSupplier) {
        IStatus status = statusSupplier.get();
        if (!Platform.isRunning()) {
            System.err.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    LogUtils.log(child);
                    ++n2;
                }
            }
            return;
        }
        Bundle bundle = Platform.getBundle((String)status.getPlugin());
        if (bundle == null) {
            String thisPluginId = LogUtils.class.getPackage().getName();
            bundle = Platform.getBundle((String)thisPluginId);
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(2, thisPluginId, "Could not find a plugin " + status.getPlugin() + " for logging as"));
        }
        Platform.getLog((Bundle)bundle).log(status);
    }

    public static void logError(String pluginId, String message, Throwable e) {
        LogUtils.log(4, pluginId, message, e);
    }

    public static void logWarning(String pluginId, String message, Throwable e) {
        LogUtils.log(2, pluginId, message, e);
    }

    public static void logInfo(String pluginId, String message, Throwable e) {
        LogUtils.log(1, pluginId, message, e);
    }

    public static void debug(String pluginId, String message) {
        LogUtils.debug(pluginId, () -> message);
    }

    public static void debug(String pluginId, Supplier<String> message) {
        if (Boolean.getBoolean(String.valueOf(pluginId) + ".debug")) {
            LogUtils.log(1, pluginId, message.get(), null);
        }
    }

    public static void logError(Class pluginClass, String message, Throwable e) {
        LogUtils.logError(pluginClass.getPackage().getName(), message, e);
    }

    public static void logWarning(Class pluginClass, String message, Throwable e) {
        LogUtils.logWarning(pluginClass.getPackage().getName(), message, e);
    }

    public static void logInfo(Class pluginClass, String message, Throwable e) {
        LogUtils.logInfo(pluginClass.getPackage().getName(), message, e);
    }

    public static void debug(Class pluginClass, String message) {
        LogUtils.debug(pluginClass.getName(), () -> message);
    }

    public static void debug(Class pluginClass, Supplier<String> message) {
        LogUtils.debug(pluginClass.getName(), message);
    }

    public static void log(int severity, Class pluginClass, Supplier<String> message, Throwable exception) {
        LogUtils.log(severity, pluginClass.getPackage().getName(), message, exception);
    }

    public static void log(int severity, Class pluginClass, String message, Throwable exception) {
        LogUtils.log(severity, pluginClass.getPackage().getName(), message, exception);
    }
}

