/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.intro;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.IntroPart;
import org.lamport.tla.toolbox.StandaloneActivator;
import org.lamport.tla.toolbox.util.ZipUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ToolboxIntroPart
extends IntroPart
implements IIntroPart {
    public static final String PERSPECTIVE_ID = "org.lamport.tla.toolbox.ui.perspective.initial";
    private Composite container;
    private static final String specKey = "tla-spec";
    private static final String zipKey = "tla-zip";
    private static SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent se) {
            String spec = (String)se.widget.getData(ToolboxIntroPart.specKey);
            String zip = (String)se.widget.getData(ToolboxIntroPart.zipKey);
            URL resource = StandaloneActivator.getDefault().getBundle().getResource(zip);
            Location instanceLocation = Platform.getInstanceLocation();
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("org.lamport.tla.toolbox.doc.contents.param", "/org.lamport.tla.toolbox.doc/html/gettingstarted/gettingstarted.html");
                this.runCommand("org.lamport.tla.toolbox.doc.contents", params);
                File destDir = ZipUtil.unzip(resource.openStream(), new File(instanceLocation.getURL().getFile() + File.separator + spec.replaceFirst(".tla$", "")), true);
                params.clear();
                params.put("toolbox.command.spec.new.param", destDir.getAbsolutePath() + File.separator + spec);
                this.runCommand("toolbox.command.spec.new", params);
            }
            catch (IOException ex) {
                StandaloneActivator.getDefault().logError(ex.getMessage(), ex);
            }
        }

        private Object runCommand(String commandId, Map<String, String> parameters) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            if (handlerService == null || commandService == null) {
                StandaloneActivator.getDefault().logInfo("No IHandlerService|ICommandService available while trying to execute a command");
                return null;
            }
            try {
                Command command = commandService.getCommand(commandId);
                ParameterizedCommand pCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
                return handlerService.executeCommand(pCommand, null);
            }
            catch (NotDefinedException e) {
                StandaloneActivator.getDefault().logError(e.getMessage(), e);
            }
            catch (NotEnabledException e) {
                StandaloneActivator.getDefault().logError(e.getMessage(), e);
            }
            catch (NotHandledException e) {
                StandaloneActivator.getDefault().logError(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Failed to execute.", (String)e.getMessage());
                StandaloneActivator.getDefault().logError(e.getMessage(), e);
            }
            return null;
        }
    };

    public void createPartControl(Composite container) {
        this.container = container;
        ToolboxIntroPart.createControl(container);
    }

    public static void createControl(Composite container) {
        Composite outerContainer = new Composite(container, 0);
        LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)outerContainer);
        Color backgroundColor = localResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(255, 255, 228)));
        outerContainer.setBackground(backgroundColor);
        outerContainer.setLayout((Layout)new GridLayout(2, false));
        Label lblImage = new Label(outerContainer, 0);
        lblImage.setText("Invisible text");
        Bundle bundle = FrameworkUtil.getBundle(ToolboxIntroPart.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("images/splash_small.bmp"), null);
        ImageDescriptor logoImage = ImageDescriptor.createFromURL((URL)url);
        lblImage.setImage(localResourceManager.createImage(logoImage));
        Label lblHeader = new Label(outerContainer, 64);
        lblHeader.setLayoutData((Object)new GridData(16384, 1024, true, false, 1, 1));
        FontDescriptor headerFontDescriptor = JFaceResources.getHeaderFontDescriptor();
        FontData fontData = headerFontDescriptor.getFontData()[0];
        lblHeader.setFont(localResourceManager.createFont(headerFontDescriptor.setHeight(fontData.getHeight() * 2)));
        lblHeader.setForeground(localResourceManager.createColor(new RGB(0, 0, 192)));
        lblHeader.setText("Welcome to the TLA\u207a Toolbox");
        lblHeader.setBackground(backgroundColor);
        Label lblSeparator = new Label(outerContainer, 0);
        lblSeparator.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        final StyledText styledWhatIsNext = new StyledText(outerContainer, 0x1000040);
        styledWhatIsNext.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        styledWhatIsNext.setBackground(backgroundColor);
        String whatIsnext = "There is no specification open. Click on Help if you're not sure what you should do next.";
        final int indexOfHelp = "There is no specification open. Click on Help if you're not sure what you should do next.".indexOf("Help");
        final int lengthOfHelp = "Help".length();
        styledWhatIsNext.setText("There is no specification open. Click on Help if you're not sure what you should do next.");
        StyleRange winStyle = new StyleRange();
        winStyle.underline = true;
        winStyle.underlineStyle = 4;
        int[] winRange = new int[]{indexOfHelp, lengthOfHelp};
        StyleRange[] winStyles = new StyleRange[]{winStyle};
        styledWhatIsNext.setStyleRanges(winRange, winStyles);
        styledWhatIsNext.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                int oap = styledWhatIsNext.getOffsetAtPoint(new Point(event.x, event.y));
                if (indexOfHelp <= oap && oap <= indexOfHelp + lengthOfHelp) {
                    IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
                    helpSystem.displayHelpResource("/org.lamport.tla.toolbox.doc/html/contents.html");
                }
            }
        });
        final StyledText styledGettingStarted = new StyledText(outerContainer, 0x1000040);
        styledGettingStarted.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        styledGettingStarted.setBackground(backgroundColor);
        String lblString = "If this is the first time you have used the Toolbox, please read the Getting Started guide.";
        final int indexOfGettingStarted = "If this is the first time you have used the Toolbox, please read the Getting Started guide.".indexOf("Getting Started");
        final int lengthGettingStarted = "Getting Started".length();
        styledGettingStarted.setText("If this is the first time you have used the Toolbox, please read the Getting Started guide.");
        StyleRange style = new StyleRange();
        style.underline = true;
        style.underlineStyle = 4;
        int[] range = new int[]{indexOfGettingStarted, lengthGettingStarted};
        StyleRange[] styles = new StyleRange[]{style};
        styledGettingStarted.setStyleRanges(range, styles);
        styledGettingStarted.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                int oap = styledGettingStarted.getOffsetAtPoint(new Point(event.x, event.y));
                if (indexOfGettingStarted <= oap && oap <= indexOfGettingStarted + lengthGettingStarted) {
                    IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
                    helpSystem.displayHelpResource("/org.lamport.tla.toolbox.doc/html/gettingstarted/gettingstarted.html");
                }
            }
        });
        Label verticalFillUp = new Label(outerContainer, 0);
        verticalFillUp.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 2, 1));
        verticalFillUp.setBackground(backgroundColor);
        final StyledText styledExamples = new StyledText(outerContainer, 16448);
        styledExamples.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 2, 1));
        styledExamples.setBackground(backgroundColor);
        String exampleText = "Clicking on one of the buttons below imports an introductory example into the Toolbox.  More examples can be found in the TLA+ examples repository.\nTo run the TLC model checker on an example spec, open one of its models by double-clicking on it in the Spec Explorer on the left.";
        final int indexOfExamples = exampleText.indexOf("TLA+ examples repository");
        final int lengthOfExamples = "TLA+ examples repository".length();
        styledExamples.setText(exampleText);
        int[] exampleRange = new int[]{indexOfExamples, lengthOfExamples};
        styledExamples.setStyleRanges(exampleRange, styles);
        styledExamples.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                int oap = styledExamples.getOffsetAtPoint(new Point(event.x, event.y));
                if (indexOfExamples <= oap && oap <= indexOfExamples + lengthOfExamples) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://github.com/tlaplus/Examples"));
                    }
                    catch (MalformedURLException | PartInitException e) {
                        StandaloneActivator.getDefault().getLog().log((IStatus)new Status(4, "org.lamport.tla.toolbox.product.standalone", e.getMessage(), e));
                    }
                }
            }
        });
        new Label(outerContainer, 0);
        Composite examples = new Composite(outerContainer, 0);
        examples.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        examples.setLayout((Layout)new GridLayout(7, true));
        examples.setBackground(backgroundColor);
        Label lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true));
        backgroundColor = localResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(255, 255, 245)));
        Button btnNewButton = new Button(examples, 0x800040);
        btnNewButton.setBackground(backgroundColor);
        btnNewButton.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton.setAlignment(0x1000000);
        btnNewButton.setText("Missionaries and Cannibals\n(TLA+)");
        btnNewButton.setData(specKey, (Object)"MissionariesAndCannibals.tla");
        btnNewButton.setData(zipKey, (Object)"examples/MissionariesAndCannibals.zip");
        btnNewButton.addSelectionListener((SelectionListener)selectionAdapter);
        btnNewButton.setToolTipText("Three missionaries and three cannibals must cross a river using a boat which can carry at most two people, under the constraint that, for both banks, if there are missionaries present on the bank, they cannot be outnumbered by cannibals (if they were, the cannibals would eat the missionaries). The boat cannot cross the river by itself with no people on board.");
        lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton = new Button(examples, 0x800040);
        btnNewButton.setBackground(backgroundColor);
        btnNewButton.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton.setAlignment(0x1000000);
        btnNewButton.setText("N Queens\n(TLA+)");
        btnNewButton.setData(specKey, (Object)"Queens.tla");
        btnNewButton.setData(zipKey, (Object)"examples/Queens.zip");
        btnNewButton.addSelectionListener((SelectionListener)selectionAdapter);
        btnNewButton.setToolTipText("The N queens puzzle is the problem of placing N chess queens on an N\u00d7N chessboard so that no two queens threaten each other.");
        lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton = new Button(examples, 0x800040);
        btnNewButton.setBackground(backgroundColor);
        btnNewButton.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton.setAlignment(0x1000000);
        btnNewButton.setData(specKey, (Object)"QueensPluscal.tla");
        btnNewButton.setData(zipKey, (Object)"examples/Queens.zip");
        btnNewButton.addSelectionListener((SelectionListener)selectionAdapter);
        btnNewButton.setText("N Queens\n(PlusCal)");
        btnNewButton.setToolTipText("The N queens puzzle is the problem of placing N chess queens on an N\u00d7N chessboard so that no two queens threaten each other.");
        lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true));
        lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true, 7, 1));
        lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton = new Button(examples, 0x800040);
        btnNewButton.setBackground(backgroundColor);
        btnNewButton.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton.setAlignment(0x1000000);
        btnNewButton.setText("Termination Detection\n(TLA+)");
        btnNewButton.setData(specKey, (Object)"EWD840.tla");
        btnNewButton.setData(zipKey, (Object)"examples/EWD840.zip");
        btnNewButton.addSelectionListener((SelectionListener)selectionAdapter);
        btnNewButton.setToolTipText("A specification of Dijkstra's algorithm for termination detection in a ring. The algorithm was published as Edsger W. Dijkstra: Derivation of a termination detection algorithm for distributed computations. Inf. Proc. Letters 16:217-219 (1983).");
        lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton = new Button(examples, 0x800040);
        btnNewButton.setBackground(backgroundColor);
        btnNewButton.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton.setAlignment(0x1000000);
        btnNewButton.setText("Termination Detection\n(TLAPS)");
        btnNewButton.setData(specKey, (Object)"EWD840_proof.tla");
        btnNewButton.setData(zipKey, (Object)"examples/EWD840.zip");
        btnNewButton.addSelectionListener((SelectionListener)selectionAdapter);
        btnNewButton.setToolTipText("A specification of Dijkstra's algorithm for termination detection in a ring. The algorithm was published as Edsger W. Dijkstra: Derivation of a termination detection algorithm for distributed computations. Inf. Proc. Letters 16:217-219 (1983).");
        lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton = new Button(examples, 0x800040);
        btnNewButton.setBackground(backgroundColor);
        btnNewButton.setLayoutData((Object)new GridData(4, 4, true, true));
        btnNewButton.setAlignment(0x1000000);
        btnNewButton.setText("Dijkstra Mutex\n(PlusCal)");
        btnNewButton.setData(specKey, (Object)"DijkstraMutex.tla");
        btnNewButton.setData(zipKey, (Object)"examples/DijkstraMutex.zip");
        btnNewButton.addSelectionListener((SelectionListener)selectionAdapter);
        btnNewButton.setToolTipText("This is a PlusCal version of the first published mutual exclusion algorithm, which appeared in\n\nE. W. Dijkstra\n\"Solution of a Problem in Concurrent Programming Control\"  \nCommunications of the ACM 8, 9 (September 1965) page 569");
        lbl = new Label(examples, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(outerContainer, 0);
        new Label(outerContainer, 0);
        Label horizontalLine = new Label(outerContainer, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label lblVersion = new Label(outerContainer, 64);
        lblVersion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        lblVersion.setText("Version 1.8.0 of Day Month Year");
        lblVersion.setBackground(backgroundColor);
    }

    public void standbyStateChanged(boolean standby) {
    }

    public void setFocus() {
        this.container.setFocus();
    }
}

