/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.dialog;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.lamport.org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;

public class TLAFilteredItemsSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SHOW_CONSTANTS = "ShowConstants";
    private static final String SHOW_CLOSED_SPECS = "ShowClosedSpecs";
    private static final String SASH_RATIO_TOP = "SashRatioTop";
    private static final String SASH_RATIO_BOTTOM = "SashRatioBottom";
    private static final String EMPTY_STRING = "";
    private static final Image ModelImage = TLCUIActivator.getImageDescriptor("/icons/full/choice_sc_obj.gif").createImage();
    private final FilteredItemsSelectionDialog.ItemsListSeparator modulesSep = new FilteredItemsSelectionDialog.ItemsListSeparator("Modules");
    private final FilteredItemsSelectionDialog.ItemsListSeparator specsSep = new FilteredItemsSelectionDialog.ItemsListSeparator("Closed Specs");
    private final ToggleShowAction toggleShowConstantsAction = new ToggleShowAction("Show spec constants", this.getDialogSettings().getBoolean("ShowConstants"));
    private final ToggleShowAction toggleShowSpecAction = new ToggleShowAction("Show closed specs", this.getDialogSettings().getBoolean("ShowClosedSpecs"));
    private SourceViewer sourceViewer;
    private SashForm sashForm;

    public TLAFilteredItemsSelectionDialog(Shell shell) {
        super(shell, false);
        this.setInitialPattern("?");
        this.setListLabelProvider((ILabelProvider)new TableLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new DetailsLabelProvider());
    }

    protected Point getInitialSize() {
        Point defaultSize = super.getInitialSize();
        if (defaultSize.x == 500 && defaultSize.y == 600) {
            defaultSize.x = (int)Math.round((double)defaultSize.x * 1.9);
            defaultSize.y = (int)Math.round((double)defaultSize.y * 1.75);
        }
        return defaultSize;
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    protected Composite createContentComposite(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        return this.sashForm;
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        Composite content = new Composite(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 200;
        content.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.sourceViewer = new SourceViewer(content, null, 576);
        this.sourceViewer.getTextWidget().setLayoutData((Object)new GridData(1808));
        this.sourceViewer.getTextWidget().setWordWrap(true);
        this.sourceViewer.getTextWidget().setEditable(false);
        this.sourceViewer.getTextWidget().setFont(TLCUIActivator.getDefault().getCourierFont());
        int top = this.getDialogSettings().get(SASH_RATIO_TOP) == null ? 75 : this.getDialogSettings().getInt(SASH_RATIO_TOP);
        int bottom = this.getDialogSettings().get(SASH_RATIO_BOTTOM) == null ? 25 : this.getDialogSettings().getInt(SASH_RATIO_BOTTOM);
        this.sashForm.setWeights(new int[]{top, bottom});
        return content;
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(SHOW_CONSTANTS) == null) {
            settings.put(SHOW_CONSTANTS, true);
        }
        return settings;
    }

    @Override
    protected void storeDialog(IDialogSettings settings) {
        settings.put(SHOW_CONSTANTS, this.toggleShowConstantsAction.isChecked());
        settings.put(SHOW_CLOSED_SPECS, this.toggleShowSpecAction.isChecked());
        settings.put(SASH_RATIO_TOP, this.sashForm.getWeights()[0]);
        settings.put(SASH_RATIO_BOTTOM, this.sashForm.getWeights()[1]);
        super.storeDialog(settings);
    }

    @Override
    protected void fillViewMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.toggleShowConstantsAction);
        menuManager.add((IAction)this.toggleShowSpecAction);
        super.fillViewMenu(menuManager);
    }

    @Override
    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    @Override
    protected void handleSelected(StructuredSelection selection) {
        block16: {
            if (selection != null && selection.size() == 0) {
                this.sourceViewer.setDocument((IDocument)new Document(EMPTY_STRING));
            } else if (selection != null && selection.getFirstElement() instanceof Module) {
                Module module = (Module)selection.getFirstElement();
                try {
                    this.sourceViewer.setDocument((IDocument)new Document(new String(Files.readAllBytes(module.getFile().toPath()))));
                }
                catch (IOException e) {
                    this.sourceViewer.setDocument((IDocument)new Document(EMPTY_STRING));
                }
            } else if (selection != null && selection.getFirstElement() instanceof Model) {
                Model model = (Model)selection.getFirstElement();
                try {
                    ArrayList<String> fallbacksFallback = new ArrayList<String>();
                    fallbacksFallback.add(model.getName());
                    String attribute = model.getComments();
                    if (!EMPTY_STRING.equals(attribute)) {
                        this.sourceViewer.setDocument((IDocument)new Document(attribute));
                        break block16;
                    }
                    this.sourceViewer.setDocument((IDocument)new Document(ModelHelper.prettyPrintConstants((Model)model, (String)"\n", (boolean)true)));
                }
                catch (CoreException ignored) {
                    this.sourceViewer.setDocument((IDocument)new Document(EMPTY_STRING));
                }
            } else if (selection != null && selection.getFirstElement() instanceof Spec) {
                Spec spec = (Spec)selection.getFirstElement();
                Path path = spec.getRootFile().getLocation().makeAbsolute().toFile().toPath();
                try {
                    this.sourceViewer.setDocument((IDocument)new Document(new String(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    this.sourceViewer.setDocument((IDocument)new Document(EMPTY_STRING));
                }
            } else if (selection != null && selection.getFirstElement() instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                this.sourceViewer.setDocument((IDocument)new Document(EMPTY_STRING));
            }
        }
        super.handleSelected(selection);
    }

    @Override
    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new TLCItemFilter();
    }

    @Override
    protected Comparator<Object> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof Model && o2 instanceof Model) {
                    Model c1 = (Model)o1;
                    Model c2 = (Model)o2;
                    return c1.getName().compareTo(c2.getName());
                }
                if (o1 instanceof Module && o2 instanceof Module) {
                    Module m1 = (Module)o1;
                    Module m2 = (Module)o2;
                    return m1.getModuleName().compareTo(m2.getModuleName());
                }
                if (o1 instanceof FilteredItemsSelectionDialog.ItemsListSeparator && o1 == TLAFilteredItemsSelectionDialog.this.modulesSep && o2 instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                    return -1;
                }
                if (o1 instanceof FilteredItemsSelectionDialog.ItemsListSeparator && o1 == TLAFilteredItemsSelectionDialog.this.specsSep && o2 instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                    return 1;
                }
                if (o1 instanceof Spec && o2 instanceof Spec) {
                    return ((Spec)o1).getName().compareTo(((Spec)o2).getName());
                }
                if (o1 instanceof Model && o2 instanceof Module) {
                    return -1;
                }
                if (o1 instanceof Model && o2 instanceof Spec) {
                    return -1;
                }
                if (o1 instanceof Model && o2 instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                    return -1;
                }
                if (o1 instanceof Module && o2 instanceof Model) {
                    return 1;
                }
                if (o1 instanceof Module && o2 instanceof Spec) {
                    return -1;
                }
                if (o1 instanceof Module && o2 instanceof FilteredItemsSelectionDialog.ItemsListSeparator && o2 == TLAFilteredItemsSelectionDialog.this.modulesSep) {
                    return 1;
                }
                if (o1 instanceof Module && o2 instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                    return -1;
                }
                if (o1 instanceof Spec && o2 instanceof Model) {
                    return 1;
                }
                if (o1 instanceof Spec && o2 instanceof Module) {
                    return 1;
                }
                if (o1 instanceof Spec && o2 instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                    return 1;
                }
                if (o1 instanceof FilteredItemsSelectionDialog.ItemsListSeparator && o2 instanceof Model) {
                    return 1;
                }
                if (o1 instanceof FilteredItemsSelectionDialog.ItemsListSeparator && o1 == TLAFilteredItemsSelectionDialog.this.modulesSep && o2 instanceof Module) {
                    return -1;
                }
                if (o1 instanceof FilteredItemsSelectionDialog.ItemsListSeparator && o2 instanceof Module) {
                    return 1;
                }
                if (o1 instanceof FilteredItemsSelectionDialog.ItemsListSeparator && o2 instanceof Spec) {
                    return -1;
                }
                return 1;
            }
        };
    }

    @Override
    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        Spec[] specs;
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        if (spec != null) {
            Collection models = ((TLCSpec)spec.getAdapter(TLCSpec.class)).getModels().values();
            for (Model model : models) {
                if (!itemsFilter.isConsistentItem(model)) continue;
                contentProvider.add(model, itemsFilter);
            }
            List modules = spec.getModules();
            if (modules.size() > 0) {
                contentProvider.add(this.modulesSep, itemsFilter);
                for (Module module : modules) {
                    if (!itemsFilter.isConsistentItem(module)) continue;
                    contentProvider.add(module, itemsFilter);
                }
            }
        }
        if (this.toggleShowSpecAction.isChecked() && (specs = Activator.getSpecManager().getRecentlyOpened()).length > 0) {
            contentProvider.add(this.specsSep, itemsFilter);
            int i = 0;
            while (i < specs.length) {
                Spec aSpec = specs[i];
                if (!aSpec.equals(spec) && itemsFilter.isConsistentItem(aSpec)) {
                    contentProvider.add(aSpec, itemsFilter);
                }
                ++i;
            }
        }
    }

    @Override
    public String getElementName(Object item) {
        return EMPTY_STRING;
    }

    private class DetailsLabelProvider
    extends LabelProvider {
        private DetailsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Module) {
                Module module = (Module)element;
                return module.getModuleName();
            }
            if (element instanceof Model) {
                ((Model)element).getName();
            } else {
                if (element instanceof Spec) {
                    Spec spec = (Spec)element;
                    return spec.getName();
                }
                if (element instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                    return TLAFilteredItemsSelectionDialog.EMPTY_STRING;
                }
            }
            return super.getText(element);
        }
    }

    public class TLCItemFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private final TableLabelProvider labelProvider;

        public TLCItemFilter() {
            this.labelProvider = new TableLabelProvider();
        }

        @Override
        public boolean isConsistentItem(Object item) {
            return true;
        }

        @Override
        public boolean matchItem(Object item) {
            if (this.getPattern() == null || this.getPattern().length() == 0) {
                return true;
            }
            return this.patternMatcher.matches(this.labelProvider.getText(item));
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements IDescriptionProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final String DELIM = ":";

        private TableLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return null;
            }
            if (element instanceof Spec) {
                Spec spec = (Spec)element;
                IFile root = spec.getRootFile();
                if (root == null) {
                    return null;
                }
                return spec.getName() + " [ " + root.getName() + " ]";
            }
            if (element instanceof Module) {
                return ((Module)element).getModuleName();
            }
            if (element instanceof Model) {
                Model model = (Model)element;
                try {
                    String attribute = model.getComments();
                    if (TLAFilteredItemsSelectionDialog.this.toggleShowConstantsAction.isChecked() && TLAFilteredItemsSelectionDialog.EMPTY_STRING.equals(attribute)) {
                        attribute = ModelHelper.prettyPrintConstants((Model)model, (String)", ");
                    }
                    if (!TLAFilteredItemsSelectionDialog.EMPTY_STRING.equals(attribute)) {
                        if (attribute.contains("\n")) {
                            attribute = attribute.split("\n")[0];
                        }
                        return model.getName() + ": " + attribute;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return model.getName();
            }
            if (element instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                FilteredItemsSelectionDialog.ItemsListSeparator ils = (FilteredItemsSelectionDialog.ItemsListSeparator)element;
                return ils.getName();
            }
            return null;
        }

        public String getDescription(Object element) {
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element == null) {
                return null;
            }
            if (element instanceof Spec) {
                if (Activator.getSpecManager().isSpecLoaded((Spec)element)) {
                    return Activator.getDefault().getImageRegistry().get("img_spec_open");
                }
                return Activator.getDefault().getImageRegistry().get("img_spec_closed");
            }
            if (element instanceof Module) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            if (element instanceof Model) {
                return ModelImage;
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            String text = this.getText(element);
            if (text == null || TLAFilteredItemsSelectionDialog.EMPTY_STRING.equals(text)) {
                return new StyledString();
            }
            StyledString string = new StyledString(text);
            if (element instanceof Spec) {
                string.setStyle(0, string.length(), StyledString.QUALIFIER_STYLER);
            } else if (element instanceof Model && text.indexOf(DELIM) != -1) {
                int index = text.indexOf(DELIM);
                string.setStyle(index, text.length() - index, StyledString.DECORATIONS_STYLER);
            } else if (element instanceof FilteredItemsSelectionDialog.ItemsListSeparator) {
                string.setStyle(0, string.length(), StyledString.QUALIFIER_STYLER);
            }
            return string;
        }
    }

    private class ToggleShowAction
    extends Action {
        public ToggleShowAction(String label, boolean checked) {
            super(label, 2);
            this.setChecked(checked);
        }

        public void run() {
        }
    }
}

