/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.Balloon;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.algorithms.TreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.PolarPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalloonLayoutAlgorithm<V>
extends TreeLayoutAlgorithm<V>
implements TreeLayout<V>,
Balloon {
    private static final Logger log = LoggerFactory.getLogger(BalloonLayoutAlgorithm.class);
    protected Map<V, PolarPoint> polarLocations = new ConcurrentHashMap<V, PolarPoint>();
    private Function<V, PolarPoint> initializer = v -> PolarPoint.ORIGIN;
    protected Map<V, Double> radii = new HashMap<V, Double>();

    public static <V> Builder<V, ?, ?> builder() {
        return (Builder)new Builder().expandLayout(false);
    }

    public BalloonLayoutAlgorithm() {
        this(BalloonLayoutAlgorithm.builder());
    }

    protected BalloonLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        super.visit(layoutModel);
        if (log.isTraceEnabled()) {
            log.trace("visit {}", (Object)layoutModel);
        }
        this.setRootPolars(layoutModel);
    }

    protected void setRootPolars(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        Set roots = graph.vertexSet().stream().filter(vertex -> this.neighborCache.predecessorsOf(vertex).isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        log.trace("roots: {}", (Object)roots);
        int width = layoutModel.getWidth();
        if (roots.size() == 1) {
            Object root = roots.stream().findFirst().get();
            this.setRootPolar(layoutModel, root);
            this.setPolars(layoutModel, this.neighborCache.successorsOf(root), this.getCenter(layoutModel), 0.0, width / 2, new HashSet());
        } else if (roots.size() > 1) {
            this.setPolars(layoutModel, roots, this.getCenter(layoutModel), 0.0, width / 2, new HashSet());
        }
    }

    protected void setRootPolar(LayoutModel<V> layoutModel, V root) {
        PolarPoint pp = PolarPoint.ORIGIN;
        Point p = this.getCenter(layoutModel);
        this.polarLocations.put((PolarPoint)root, pp);
        log.trace("putting the root at {} in model of size {},{}", p, layoutModel.getWidth(), layoutModel.getHeight());
        layoutModel.set(root, p);
    }

    protected void setPolars(LayoutModel<V> layoutModel, Collection<V> kids, Point parentLocation, double angleToParent, double parentRadius, Set<V> seen) {
        int childCount = kids.size();
        if (childCount == 0) {
            return;
        }
        double angle = Math.max(0.0, 1.5707963267948966 * (1.0 - 2.0 / (double)childCount));
        double childRadius = parentRadius * Math.cos(angle) / (1.0 + Math.cos(angle));
        double radius = parentRadius - childRadius;
        double angleBetweenKids = Math.PI * 2 / (double)childCount;
        double offset = angleBetweenKids / 2.0 - angleToParent;
        int i = 0;
        for (V child : kids) {
            double theta = (double)i++ * angleBetweenKids + offset;
            this.radii.put((Double)child, childRadius);
            PolarPoint pp = PolarPoint.of(theta, radius);
            this.polarLocations.put((PolarPoint)child, pp);
            Point p = PolarPoint.polarToCartesian(pp);
            p = p.add(parentLocation.x, parentLocation.y);
            layoutModel.set(child, p);
            double newAngleToParent = Math.atan2(p.y - parentLocation.y, parentLocation.x - p.x);
            HashSet<V> successors = new HashSet<V>(this.neighborCache.successorsOf(child));
            successors.removeIf(seen::contains);
            seen.addAll(successors);
            this.setPolars(layoutModel, successors, p, newAngleToParent, childRadius, seen);
        }
    }

    public Point getCenter(LayoutModel<V> layoutModel, V vertex) {
        Graph graph = layoutModel.getGraph();
        Object parent = this.neighborCache.predecessorsOf(vertex).stream().findFirst().orElse(null);
        if (parent == null) {
            return this.getCenter(layoutModel);
        }
        return layoutModel.get(parent);
    }

    private Point getCartesian(LayoutModel<V> layoutModel, V vertex) {
        PolarPoint pp = this.polarLocations.computeIfAbsent((PolarPoint)vertex, (Function<PolarPoint, PolarPoint>)this.initializer);
        double centerX = layoutModel.getWidth() / 2;
        double centerY = layoutModel.getHeight() / 2;
        Point cartesian = PolarPoint.polarToCartesian(pp);
        cartesian = cartesian.add(centerX, centerY);
        return cartesian;
    }

    public Map<V, Double> getRadii() {
        return this.radii;
    }

    @Override
    public boolean constrained() {
        return true;
    }

    public static class Builder<V, T extends BalloonLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends TreeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        @Override
        public T build() {
            return (T)new BalloonLayoutAlgorithm(this);
        }
    }
}

