/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jungrapht.visualization.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.IterativeContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.RadiusVertexAccessor;
import org.jungrapht.visualization.layout.util.RandomLocationTransformer;
import org.jungrapht.visualization.layout.util.VertexAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISOMLayoutAlgorithm<V>
extends AbstractIterativeLayoutAlgorithm<V>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(ISOMLayoutAlgorithm.class);
    private Map<V, ISOMVertexData> isomVertexData = new ConcurrentHashMap<V, ISOMVertexData>();
    private Function<V, ISOMVertexData> initializer = v -> new ISOMVertexData();
    protected int maxEpoch;
    protected int epoch;
    protected int radiusConstantTime;
    protected int radius;
    protected int minRadius;
    protected double adaption;
    protected double initialAdaption;
    protected double minAdaption;
    private VertexAccessor<V> elementAccessor;
    protected double coolingFactor;
    protected List<V> queue = new ArrayList<V>();
    protected String status = null;

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public ISOMLayoutAlgorithm() {
        this(ISOMLayoutAlgorithm.builder());
    }

    protected ISOMLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        Graph graph;
        super.visit(layoutModel);
        if (log.isTraceEnabled()) {
            log.trace("visiting {}", (Object)layoutModel);
        }
        if ((graph = layoutModel.getGraph()) == null || graph.vertexSet().isEmpty()) {
            return;
        }
        this.elementAccessor = new RadiusVertexAccessor();
        this.initialize();
    }

    public void initialize() {
        this.layoutModel.setInitializer(new RandomLocationTransformer(this.layoutModel.getWidth(), this.layoutModel.getHeight()));
        this.maxEpoch = 2000;
        this.epoch = 1;
        this.radiusConstantTime = 100;
        this.radius = 5;
        this.minRadius = 1;
        this.adaption = this.initialAdaption = 0.9;
        this.minAdaption = 0.0;
        this.coolingFactor = 2.0;
    }

    @Override
    public void step() {
        this.status = "epoch: " + this.epoch + "; ";
        if (this.epoch < this.maxEpoch) {
            this.adjust();
            this.updateParameters();
            this.status = this.status + " status: running";
        } else {
            this.status = this.status + "adaption: " + this.adaption + "; ";
            this.status = this.status + "status: done";
        }
    }

    private synchronized void adjust() {
        double width = this.layoutModel.getWidth();
        double height = this.layoutModel.getHeight();
        Point tempXYD = Point.of(10.0 + Math.random() * width, 10.0 + Math.random() * height);
        V winner = this.elementAccessor.getVertex(this.layoutModel, tempXYD.x, tempXYD.y);
        while (true) {
            try {
                for (Object vertex : this.layoutModel.getGraph().vertexSet()) {
                    ISOMVertexData ivd = this.getISOMVertexData(vertex);
                    ivd.distance = 0;
                    ivd.visited = false;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.adjustVertex(winner, tempXYD);
    }

    private synchronized void updateParameters() {
        ++this.epoch;
        double factor = Math.exp(-1.0 * this.coolingFactor * (1.0 * (double)this.epoch / (double)this.maxEpoch));
        this.adaption = Math.max(this.minAdaption, factor * this.initialAdaption);
        if (this.radius > this.minRadius && this.epoch % this.radiusConstantTime == 0) {
            --this.radius;
        }
    }

    private synchronized void adjustVertex(V vertex, Point tempXYD) {
        Graph graph = this.layoutModel.getGraph();
        this.queue.clear();
        ISOMVertexData ivd = this.getISOMVertexData(vertex);
        ivd.distance = 0;
        ivd.visited = true;
        this.queue.add(vertex);
        block2: while (!this.queue.isEmpty() && !this.cancelled) {
            V current = this.queue.remove(0);
            ISOMVertexData currData = this.getISOMVertexData(current);
            Point currXYData = (Point)this.layoutModel.apply(current);
            double dx = tempXYD.x - currXYData.x;
            double dy = tempXYD.y - currXYData.y;
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            this.layoutModel.set(current, currXYData.x + factor * dx, currXYData.y + factor * dy);
            if (currData.distance >= this.radius) continue;
            List s = Graphs.neighborListOf(graph, current);
            while (true) {
                try {
                    for (Object child : s) {
                        ISOMVertexData childData = this.getISOMVertexData(child);
                        if (childData == null || childData.visited) continue;
                        childData.visited = true;
                        childData.distance = currData.distance + 1;
                        this.queue.add(child);
                    }
                    continue block2;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
        }
    }

    private ISOMVertexData getISOMVertexData(V vertex) {
        return this.isomVertexData.computeIfAbsent((ISOMVertexData)vertex, (Function<ISOMVertexData, ISOMVertexData>)this.initializer);
    }

    @Override
    public boolean done() {
        boolean done;
        if (this.cancelled) {
            return true;
        }
        boolean bl = done = this.epoch >= this.maxEpoch;
        if (done) {
            this.runAfter();
        }
        return done;
    }

    public void reset() {
        this.epoch = 0;
    }

    public static class Builder<V, T extends ISOMLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractIterativeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        @Override
        public T build() {
            return (T)new ISOMLayoutAlgorithm(this);
        }
    }

    private static class ISOMVertexData {
        int distance = 0;
        boolean visited = false;

        protected ISOMVertexData() {
        }
    }
}

