/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.Arrays;
import java.util.Map;
import org.jungrapht.visualization.layout.algorithms.sugiyama.HorizontalCompaction;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalCompactionDeprecated<V>
extends HorizontalCompaction<V> {
    private static final Logger log = LoggerFactory.getLogger(HorizontalCompactionDeprecated.class);

    public HorizontalCompactionDeprecated(LV<V>[][] layers, Map<LV<V>, LV<V>> rootMap, Map<LV<V>, LV<V>> alignMap, int deltaX, int deltaY) {
        super(layers, rootMap, alignMap, deltaX, deltaY);
    }

    @Override
    public Point getPoint(LV<V> v) {
        return Point.of(((Integer)this.x.get(v)).intValue(), ((Integer)this.y.get(v)).intValue());
    }

    @Override
    public void horizontalCompaction() {
        if (log.isTraceEnabled()) {
            Arrays.stream(this.layers).flatMap(Arrays::stream).forEach(v -> log.trace("v == {} root(v) == {} they're equal = {}", v, this.root(v), this.root(v) == v));
        }
        Arrays.stream(this.layers).flatMap(Arrays::stream).filter(v -> this.root(v) == v).forEach(v -> {
            log.trace("(v) will placeBlock({})", v);
            this.placeBlock((LV<V>)v);
        });
        for (int i = 0; i < this.layers.length; ++i) {
            LV[] list;
            for (LV v2 : list = this.layers[i]) {
                this.x(v2, this.x(this.root(v2)));
                this.y(v2, i * this.deltaY);
                if (this.shift(this.sink(this.root(v2))) >= Integer.MAX_VALUE) continue;
                this.x(v2, this.x(v2) + this.shift(this.sink(this.root(v2))));
            }
        }
    }

    @Override
    protected void placeBlock(LV<V> v) {
        if (!this.x.containsKey(v)) {
            this.x(v, 0);
            LV<V> w = v;
            do {
                log.trace("looking for predecessor of {}", (Object)w);
                if (!this.hasPredecessor(w)) continue;
                LV<V> pred = this.pred(w);
                LV<V> u = this.root(pred);
                int diff = this.pos(w) - this.pos(pred);
                log.trace("(u) will placeBlock({})", (Object)u);
                this.placeBlock(u);
                if (this.sink(v) == v) {
                    this.sink(v, this.sink(u));
                }
                if (this.sink(v) != this.sink(u)) {
                    this.shift(this.sink(u), Math.min(this.shift(this.sink(u)), this.x(v) - this.x(u) - this.deltaX));
                    continue;
                }
                int localDeltaX = this.deltaX + this.deltaX * (this.pos(v) - this.idx(v));
                this.x(v, Math.max(this.x(v), this.x(u) + localDeltaX));
            } while ((w = this.align(w)) != v);
        }
    }

    @Override
    protected int pos(LV<V> v) {
        return v.getPos();
    }

    @Override
    protected int idx(LV<V> v) {
        return v.getIndex();
    }
}

