/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.DirectedAcyclicGraph;
import org.jgrapht.graph.builder.GraphBuilder;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructiveCycleRemoval<V, E> {
    private static final Logger log = LoggerFactory.getLogger(ConstructiveCycleRemoval.class);
    Collection<E> feedbackArcs = new HashSet();
    Graph<V, E> graph;
    Graph<V, E> dag;
    Comparator<E> comparator;

    public ConstructiveCycleRemoval(Graph<V, E> graph) {
        this(graph, (v1, v2) -> 0);
    }

    public ConstructiveCycleRemoval(Graph<V, E> graph, Comparator<E> comparator) {
        this.graph = graph;
        this.comparator = comparator;
        this.dag = GraphTypeBuilder.forGraphType(DefaultGraphType.dag()).buildGraph();
        GraphBuilder builder = DirectedAcyclicGraph.createBuilder(Object::new);
        Object dag2 = builder.build();
        graph.vertexSet().forEach(this.dag::addVertex);
        graph.vertexSet().forEach(arg_0 -> dag2.addVertex(arg_0));
        ArrayList<E> edgeList = new ArrayList<E>(graph.edgeSet());
        edgeList.sort(comparator);
        for (Object edge : edgeList) {
            V source = graph.getEdgeSource(edge);
            V target = graph.getEdgeTarget(edge);
            try {
                this.dag.addEdge(source, target, edge);
                dag2.addEdge(source, target, edge);
            }
            catch (Exception ex) {
                this.feedbackArcs.add(edge);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("graph is {}", (Object)graph);
            log.trace("dag is {}", (Object)this.dag);
            log.trace("graph vertex sets are the same: {}", (Object)graph.vertexSet().containsAll(this.dag.vertexSet()));
            log.trace("graph edge sets are the same: {}", (Object)graph.edgeSet().containsAll(this.dag.edgeSet()));
        }
    }

    public Collection<E> getFeedbackArcs() {
        return this.feedbackArcs;
    }
}

