/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentGrouping {
    private static final Logger log = LoggerFactory.getLogger(ComponentGrouping.class);

    public static <V, E> List<V> groupByComponents(Graph<V, E> graph, List<V> vertices) {
        ConnectivityInspector<V, E> connectivityInspector = new ConnectivityInspector<V, E>(graph);
        List<Set<V>> componentVertices = connectivityInspector.connectedSets();
        if (log.isTraceEnabled()) {
            log.trace("there are {} components", (Object)componentVertices.size());
        }
        if (componentVertices.size() > 1) {
            vertices = ComponentGrouping.groupByComponentMembership(componentVertices, vertices);
        }
        vertices.sort(Comparator.comparingInt(v -> ComponentGrouping.vertexIsolationScore(graph, v)));
        return vertices;
    }

    public static <V, E> List<Graph<V, E>> getComponentGraphs(Graph<V, E> graph) {
        ArrayList<Graph<V, Graph<V, E>>> graphList = new ArrayList<Graph<V, Graph<V, E>>>();
        ConnectivityInspector<V, E> connectivityInspector = new ConnectivityInspector<V, E>(graph);
        List<Set<V>> componentVertices = connectivityInspector.connectedSets();
        HashSet<E> allEdges = new HashSet<E>(graph.edgeSet());
        for (Set<V> set : componentVertices) {
            Graph<V, E> subGraph = GraphTypeBuilder.forGraphType(graph.getType()).buildGraph();
            set.forEach(subGraph::addVertex);
            for (E edge : graph.edgeSet()) {
                V source = graph.getEdgeSource(edge);
                V target = graph.getEdgeTarget(edge);
                if (!set.contains(source) || !set.contains(target)) continue;
                subGraph.addEdge(source, target, edge);
                allEdges.remove(edge);
            }
            graphList.add(subGraph);
        }
        if (!allEdges.isEmpty()) {
            throw new RuntimeException("edges were left out of subgraphs: " + allEdges);
        }
        return graphList;
    }

    private static <V> List<V> groupByComponentMembership(List<Set<V>> componentVertices, List<V> list) {
        ArrayList groupedRow = new ArrayList();
        for (Set<V> set : componentVertices) {
            groupedRow.addAll(list.stream().filter(set::contains).collect(Collectors.toList()));
        }
        return groupedRow;
    }

    public static <V, E> int vertexIsolationScore(Graph<V, E> graph, V v) {
        if (ComponentGrouping.isZeroDegreeVertex(graph, v)) {
            return 2;
        }
        if (ComponentGrouping.isLoopVertex(graph, v)) {
            return 1;
        }
        return 0;
    }

    public static <V, E> boolean isLoopVertex(Graph<V, E> graph, V v) {
        return graph.outgoingEdgesOf(v).equals(graph.incomingEdgesOf(v));
    }

    public static <V, E> boolean isZeroDegreeVertex(Graph<V, E> graph, V v) {
        return graph.degreeOf(v) == 0;
    }

    public static <V, E> boolean isIsolatedVertex(Graph<V, E> graph, V v) {
        return ComponentGrouping.isLoopVertex(graph, v) || ComponentGrouping.isZeroDegreeVertex(graph, v);
    }
}

