/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.util.synthetics;

import java.util.Objects;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformingGraphView<V, W, E, F> {
    private static final Logger log = LoggerFactory.getLogger(TransformingGraphView.class);
    private Graph<V, E> graph;
    private Function<V, ? extends W> vertexTransformFunction;
    private Function<E, ? extends F> edgeTransformFunction;

    public static <V, W, E, F> Builder<V, W, E, F, ?, ?> builder(Graph<V, E> graph) {
        return new Builder(graph);
    }

    TransformingGraphView(Builder<V, W, E, F, ?, ?> builder) {
        this.graph = builder.graph;
        this.vertexTransformFunction = builder.vertexTransformFunction;
        Objects.requireNonNull(this.vertexTransformFunction);
        this.edgeTransformFunction = builder.edgeTransformFunction;
        Objects.requireNonNull(this.edgeTransformFunction);
    }

    public Graph<W, F> build() {
        Graph<W, F> transformedGraph = GraphTypeBuilder.forGraphType(this.graph.getType()).buildGraph();
        for (V v : this.graph.vertexSet()) {
            W w = this.vertexTransformFunction.apply(v);
            transformedGraph.addVertex(w);
        }
        for (Object e : this.graph.edgeSet()) {
            W target;
            W source = this.vertexTransformFunction.apply(this.graph.getEdgeSource(e));
            if (source.equals(target = this.vertexTransformFunction.apply(this.graph.getEdgeTarget(e)))) continue;
            F edge = this.edgeTransformFunction.apply(e);
            transformedGraph.addEdge(source, target, edge);
        }
        return transformedGraph;
    }

    public static class Builder<V, W, E, F, T extends TransformingGraphView<V, W, E, F>, B extends Builder<V, W, E, F, T, B>> {
        private Graph<V, E> graph;
        private Function<V, W> vertexTransformFunction;
        private Function<E, F> edgeTransformFunction;

        private Builder(Graph<V, E> graph) {
            this.graph = graph;
            Objects.requireNonNull(this.graph);
        }

        protected B self() {
            return (B)this;
        }

        public B vertexTransformFunction(Function<V, W> vertexTransformFunction) {
            this.vertexTransformFunction = vertexTransformFunction;
            return this.self();
        }

        public B edgeTransformFunction(Function<E, F> edgeTransformFunction) {
            this.edgeTransformFunction = edgeTransformFunction;
            return this.self();
        }

        public T build() {
            return (T)new TransformingGraphView(this);
        }
    }
}

