/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.lamport.tla.toolbox.StandaloneActivator;
import org.lamport.tla.toolbox.lifecycle.ToolboxLifecycleParticipant;

public class ToolboxLifecycleParticipantManger {
    private static final String POINT = "org.lamport.tla.toolbox.tool";
    private static final String CLASS_ATTR_NAME = "class";

    private static ToolboxLifecycleParticipant[] getRegisteredTools() {
        IConfigurationElement[] decls = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT);
        ToolboxLifecycleParticipant[] extensions = new ToolboxLifecycleParticipant[decls.length];
        int i = 0;
        while (i < decls.length) {
            try {
                extensions[i] = (ToolboxLifecycleParticipant)decls[i].createExecutableExtension(CLASS_ATTR_NAME);
            }
            catch (CoreException e) {
                StandaloneActivator.getDefault().logError(e.getMessage(), e);
                return new ToolboxLifecycleParticipant[0];
            }
            ++i;
        }
        return extensions;
    }

    public static void initialize() {
        ToolboxLifecycleParticipant[] participants = ToolboxLifecycleParticipantManger.getRegisteredTools();
        Assert.isNotNull((Object)participants);
        int i = 0;
        while (i < participants.length) {
            participants[i].initialize();
            ++i;
        }
    }

    public static void postWorkbenchWindowOpen() {
        ToolboxLifecycleParticipant[] participants = ToolboxLifecycleParticipantManger.getRegisteredTools();
        Assert.isNotNull((Object)participants);
        int i = 0;
        while (i < participants.length) {
            participants[i].postWorkbenchWindowOpen();
            ++i;
        }
    }

    public static void terminate() {
        ToolboxLifecycleParticipant[] participants = ToolboxLifecycleParticipantManger.getRegisteredTools();
        Assert.isNotNull((Object)participants);
        int i = 0;
        while (i < participants.length) {
            participants[i].terminate();
            ++i;
        }
    }
}

