/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tla2tex.handler;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.lamport.tla.toolbox.tool.tla2tex.TLA2TeXActivator;
import org.lamport.tla.toolbox.tool.tla2tex.handler.ProducePDFHandler;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractPDFViewerRunnable
implements EventHandler,
IPartListener,
Runnable {
    protected IFile outputFile;
    protected IProgressMonitor monitor;
    protected String outputFileName;
    private final ProducePDFHandler handler;
    protected final IResource specFile;
    protected IWorkbenchPart part;

    public AbstractPDFViewerRunnable(ProducePDFHandler handler, IWorkbenchPartSite site, IResource aSpecFile) {
        Assert.isNotNull((Object)((Object)handler));
        Assert.isNotNull((Object)site);
        Assert.isNotNull((Object)aSpecFile);
        this.handler = handler;
        this.specFile = aSpecFile;
        boolean autoRegenerate = TLA2TeXActivator.getDefault().getPreferenceStore().getBoolean("autoRegenerateOnSave");
        if (autoRegenerate) {
            IEventBroker eventService = (IEventBroker)site.getService(IEventBroker.class);
            Assert.isTrue((boolean)eventService.subscribe("TLAEditor/save", (EventHandler)this));
            IPartService partService = (IPartService)site.getService(IPartService.class);
            partService.addPartListener((IPartListener)this);
        }
    }

    public void setFile(String outputFileName) throws CoreException {
        this.outputFileName = outputFileName;
        this.outputFile = (IFile)ResourceHelper.getResourceByName((String)outputFileName);
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    protected void preUpdate() {
    }

    public void handleEvent(Event event) {
        Object property;
        if ("TLAEditor/save".equals(event.getTopic()) && (property = event.getProperty("org.eclipse.e4.data")) instanceof IFile && this.specFile.equals(property)) {
            this.preUpdate();
            this.handler.runPDFJob(this, this.specFile);
        }
    }

    public void partClosed(IWorkbenchPart aPart) {
        if (aPart == this.part) {
            IEventBroker service = (IEventBroker)aPart.getSite().getService(IEventBroker.class);
            service.unsubscribe((EventHandler)this);
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

