/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.util.UIHelper;

public class DeleteModelHandler
extends AbstractHandler
implements IHandler {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("MMM dd,yyyy HH:mm:ss");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            boolean userConfirmedDeletion = MessageDialog.openQuestion((Shell)UIHelper.getShell(), (String)"Confirm Delete", (String)this.getLabel(iss));
            if (!userConfirmedDeletion) {
                return null;
            }
            for (Model model : iss) {
                if (!model.isRunning()) continue;
                MessageDialog.openError((Shell)UIHelper.getShell(), (String)"Could not delete a model", (String)("Could not delete the model " + model.getName() + ", because it is being model checked."));
                return null;
            }
            for (Model model : iss) {
                IEditorPart editorWithModelOpened = (IEditorPart)model.getAdapter(ModelEditor.class);
                if (editorWithModelOpened == null) continue;
                UIHelper.getActivePage().closeEditor(editorWithModelOpened, false);
            }
            final Model[] models = iss.toList().toArray(new Model[iss.size()]);
            TLCOutputSourceRegistry.getModelCheckSourceRegistry().removeTLCStatusSource(models);
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    Model[] modelArray = models;
                    int n = models.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Model model = modelArray[n2];
                        model.delete(monitor);
                        ++n2;
                    }
                }
            };
            ProgressMonitorDialog ctxt = new ProgressMonitorDialog(UIHelper.getShell());
            try {
                ctxt.run(true, false, (IRunnableWithProgress)operation);
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private String getLabel(IStructuredSelection iss) {
        if (iss.size() > 1) {
            List list = iss.toList();
            Predicate<Model> p = Model::isSnapshot;
            Set models = list.stream().filter(p.negate()).collect(Collectors.toSet());
            if (models.isEmpty()) {
                return String.format("Are you sure you want to delete the %s selected snapshots?", iss.size());
            }
            Set allSnapshots = list.stream().map(Model::getSnapshots).flatMap(c -> c.stream()).collect(Collectors.toSet());
            if (models.size() > 1 && allSnapshots.isEmpty()) {
                return String.format("Are you sure you want to delete the %s selected models?", iss.size());
            }
            Set selectedSnapshots = list.stream().filter(Model::isSnapshot).collect(Collectors.toSet());
            if (models.size() == 1) {
                allSnapshots.addAll(selectedSnapshots);
                return String.format("Are you sure you want to delete the select model '%s' and %s snapshot%s?", ((Model)models.iterator().next()).getName(), allSnapshots.size(), DeleteModelHandler.isPlural(allSnapshots));
            }
            allSnapshots.addAll(selectedSnapshots);
            return String.format("Are you sure you want to delete %s models and %s snapshot%s?", models.size(), allSnapshots.size(), DeleteModelHandler.isPlural(allSnapshots));
        }
        return this.getLabel((Model)iss.getFirstElement());
    }

    private String getLabel(Model model) {
        Model snapshotFor = model.getSnapshotFor();
        if (snapshotFor != model) {
            return String.format("Are you sure you want to delete the snapshot of %s of model '%s'?", sdf.format(model.getSnapshotTimeStamp()), snapshotFor.getName());
        }
        Collection snapshots = model.getSnapshots();
        if (!snapshots.isEmpty()) {
            return String.format("Are you sure you want to delete the model '%s' and its %s snapshot%s?", model.getName(), snapshots.size(), DeleteModelHandler.isPlural(snapshots));
        }
        return String.format("Are you sure you want to delete the model '%s'?", model.getName());
    }

    private static String isPlural(Collection<?> col) {
        return col.size() > 1 ? "s" : "";
    }
}

