/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.tool.tlc.util.ModelNameValidator;
import org.lamport.tla.toolbox.util.UIHelper;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SubstInNode;
import tlc2.model.Assignment;

public class NewModelHandler
extends AbstractHandler
implements IModelConfigurationConstants {
    public static final String COMMAND_ID = "toolbox.tool.tlc.commands.model.new";
    public static final String PARAM_SPEC_NAME = "toolbox.tool.tlc.commands.model.new.param";

    /*
     * Loose catch block
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String parameter = event.getParameter(PARAM_SPEC_NAME);
        Spec spec = null;
        spec = parameter != null ? ToolboxHandle.getSpecByName((String)parameter) : ToolboxHandle.getCurrentSpec();
        if (spec == null) {
            TLCUIActivator.getDefault().logWarning("BUG: no spec");
            return null;
        }
        IProject specProject = spec.getProject();
        SpecObj specObject = spec.getRootModule();
        if (specObject == null) {
            TLCUIActivator.getDefault().logWarning("BUG: no specObject");
            return null;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.lamport.tla.toolbox.tool.tlc.modelCheck");
        InputDialog dialog = new InputDialog(UIHelper.getShellProvider().getShell(), "New model...", "Please input the name of the model to create", ((TLCSpec)spec.getAdapter(TLCSpec.class)).getModelNameSuggestion(), (IInputValidator)new ModelNameValidator(spec));
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0) {
            return null;
        }
        String modelName = dialog.getValue();
        ModuleNode moduleNode = specObject.getExternalModuleTable().getRootModule();
        List constants = ModelHelper.createConstantsList((ModuleNode)moduleNode);
        Iterator iter = constants.iterator();
        boolean done = false;
        while (!done && iter.hasNext()) {
            Assignment assign = (Assignment)iter.next();
            if (!assign.getLabel().equals("defaultInitValue") || assign.getParams().length != 0) continue;
            assign.setRight("defaultInitValue");
            done = true;
        }
        try {
            ILaunchConfigurationWorkingCopy launchCopy = launchConfigurationType.newInstance((IContainer)specProject, specProject.getName() + "___" + modelName);
            launchCopy.setAttribute("specName", spec.getName());
            launchCopy.setAttribute("configurationName", modelName);
            if (constants.size() == 0) {
                launchCopy.setAttribute("modelParameterConstants", null);
            } else {
                launchCopy.setAttribute("modelParameterConstants", ModelHelper.serializeAssignmentList((List)constants));
            }
            OpDefNode[] defs = moduleNode.getOpDefs();
            boolean foundSpec = false;
            boolean foundInit = false;
            boolean foundNext = false;
            boolean foundTermination = false;
            boolean checkTermination = false;
            int i = 0;
            while (i < defs.length) {
                block43: {
                    if (defs[i].getNumberOfArgs() == 0) {
                        if (defs[i].getName().toString().equals("Spec") && defs[i].getLevel() == 3) {
                            foundSpec = true;
                        } else if (defs[i].getName().toString().equals("Init") && defs[i].getLevel() == 1) {
                            foundInit = true;
                        } else if (defs[i].getName().toString().equals("Next") && defs[i].getLevel() == 2) {
                            foundNext = true;
                        } else if (defs[i].getName().toString().equals("Termination") && defs[i].getLevel() == 3) {
                            foundTermination = true;
                            IFile ifile = spec.getRootFile();
                            FileEditorInput fileEditorInput = new FileEditorInput(ifile);
                            FileDocumentProvider fileDocumentProvider = new FileDocumentProvider();
                            try {
                                fileDocumentProvider.connect((Object)fileEditorInput);
                                IDocument document = fileDocumentProvider.getDocument((Object)fileEditorInput);
                                FindReplaceDocumentAdapter searchAdapter = new FindReplaceDocumentAdapter(document);
                                IRegion matchRegionx = searchAdapter.find(0, "PlusCal[\\s]*options[\\s]*\\([^\\)]*termination", true, true, false, true);
                                if (matchRegionx != null) {
                                    checkTermination = true;
                                    Activator.getDefault().logDebug("Set checkTermination true for " + ifile.getName());
                                } else {
                                    IPreferenceStore projectPreferenceStore = PreferenceStoreHelper.getProjectPreferenceStore((IProject)ifile.getProject());
                                    String paramString = projectPreferenceStore.getString("pCalCallParams");
                                    checkTermination = paramString.indexOf("-termination") != -1;
                                    TLCUIActivator.getDefault().logDebug("checkTermination = " + checkTermination);
                                }
                            }
                            catch (CoreException document) {
                                fileDocumentProvider.disconnect((Object)fileEditorInput);
                                break block43;
                            }
                            catch (BadLocationException document) {
                                fileDocumentProvider.disconnect((Object)fileEditorInput);
                                break block43;
                                catch (Throwable throwable) {
                                    fileDocumentProvider.disconnect((Object)fileEditorInput);
                                    throw throwable;
                                }
                            }
                            fileDocumentProvider.disconnect((Object)fileEditorInput);
                        }
                    }
                }
                ++i;
            }
            if (foundSpec) {
                launchCopy.setAttribute("modelBehaviorSpec", "Spec");
                launchCopy.setAttribute("modelBehaviorSpecType", 1);
                if (foundTermination) {
                    Vector<CallSite> vec = new Vector<CallSite>();
                    vec.add((CallSite)((Object)((checkTermination ? "1" : "0") + "Termination")));
                    launchCopy.setAttribute("modelCorrectnessProperties", vec);
                }
            } else if (foundInit || foundNext) {
                launchCopy.setAttribute("modelBehaviorSpecType", 2);
                if (foundInit) {
                    launchCopy.setAttribute("modelBehaviorInit", "Init");
                }
                if (foundNext) {
                    launchCopy.setAttribute("modelBehaviorNext", "Next");
                }
            }
            Vector<CallSite> overrides = new Vector<CallSite>();
            int i2 = 0;
            while (i2 < defs.length) {
                OpApplNode nodeBodyA;
                OpDefNode node = defs[i2];
                ExprNode nodeBody = node.getBody();
                while (nodeBody instanceof SubstInNode) {
                    nodeBody = ((SubstInNode)nodeBody).getBody();
                }
                if (nodeBody instanceof OpApplNode && (nodeBodyA = (OpApplNode)nodeBody).getOperator().getName().toString().equals("$UnboundedChoose")) {
                    FormalParamNode chooseParam = nodeBodyA.getUnbdedQuantSymbols()[0];
                    ExprOrOpArgNode chooseBody = nodeBodyA.getArgs()[0];
                    if (chooseBody instanceof OpApplNode) {
                        OpApplNode leftArgA;
                        ExprOrOpArgNode leftArg;
                        OpApplNode notArgA;
                        ExprOrOpArgNode notArg;
                        OpApplNode chooseBodyA = (OpApplNode)chooseBody;
                        boolean toOverride = false;
                        String topOpName = chooseBodyA.getOperator().getName().toString();
                        if (topOpName.equals("\\notin")) {
                            OpApplNode leftArgA2;
                            ExprOrOpArgNode leftArg2 = chooseBodyA.getArgs()[0];
                            if (leftArg2 instanceof OpApplNode && (leftArgA2 = (OpApplNode)leftArg2).getOperator() == chooseParam) {
                                toOverride = true;
                            }
                        } else if (topOpName.equals("\\lnot") && (notArg = chooseBodyA.getArgs()[0]) instanceof OpApplNode && (notArgA = (OpApplNode)notArg).getOperator().getName().equals("\\in") && (leftArg = notArgA.getArgs()[0]) instanceof OpApplNode && (leftArgA = (OpApplNode)leftArg).getOperator() == chooseParam) {
                            toOverride = true;
                        }
                        if (toOverride) {
                            String defName = node.getName().toString();
                            overrides.addElement((CallSite)((Object)(defName + ";;" + defName + ";1;0")));
                        }
                    }
                }
                ++i2;
            }
            if (overrides.size() != 0) {
                launchCopy.setAttribute("modelParameterDefinitions", overrides);
            }
            ILaunchConfiguration launchSaved = launchCopy.doSave();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("toolbox.tool.tlc.commands.model.open.param", modelName);
            ArrayList<String> expand = new ArrayList<String>();
            expand.add("__what_is_the_description");
            if (foundSpec && foundTermination) {
                expand.add("__what_to_check_properties");
            }
            if (!constants.isEmpty()) {
                expand.add("__what_is_the_model");
            }
            parameters.put("toolbox.tool.tlc.commands.model.open.param.expand.properties", String.join((CharSequence)",", expand));
            UIHelper.runCommand((String)"toolbox.tool.tlc.commands.model.open", parameters);
            return launchSaved;
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Error creating a model", e);
            return null;
        }
    }
}

