/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.List;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCMultiVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariableValue;

public class TLCSetVariableValue
extends TLCVariableValue
implements TLCMultiVariableValue {
    private static final String[] DELIMETERS = new String[]{"{", ",", "}"};

    TLCSetVariableValue(List values) {
        this.value = values;
    }

    @Override
    public Object getValue() {
        return this.getElements();
    }

    public TLCVariableValue[] getElements() {
        List list = (List)this.value;
        return list.toArray(new TLCVariableValue[list.size()]);
    }

    @Override
    public String toSimpleString() {
        Object[] elements = this.getElements();
        return TLCSetVariableValue.arrayToSimpleStringBuffer(elements, DELIMETERS).toString();
    }

    @Override
    public List<TLCVariableValue> asList() {
        return (List)this.value;
    }

    @Override
    protected void innerDiff(TLCVariableValue other) {
        int j;
        boolean notfound;
        if (!(other instanceof TLCSetVariableValue)) {
            return;
        }
        TLCVariableValue[] firstElts = this.getElements();
        TLCVariableValue[] secondElts = ((TLCSetVariableValue)other).getElements();
        int i = 0;
        while (i < firstElts.length) {
            notfound = true;
            j = 0;
            while (notfound && j < secondElts.length) {
                if (firstElts[i].toSimpleString().equals(secondElts[j].toSimpleString())) {
                    notfound = false;
                }
                ++j;
            }
            if (notfound) {
                firstElts[i].setDeleted();
            }
            ++i;
        }
        i = 0;
        while (i < secondElts.length) {
            notfound = true;
            j = 0;
            while (notfound && j < firstElts.length) {
                if (firstElts[j].toSimpleString().equals(secondElts[i].toSimpleString())) {
                    notfound = false;
                }
                ++j;
            }
            if (notfound) {
                secondElts[i].setAdded();
            }
            ++i;
        }
    }
}

