/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.traceexplorer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCError;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCState;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;

public class TraceExplorerHelper {
    public static TLCError getErrorOfOriginalTrace(Model model) {
        TLCModelLaunchDataProvider originalTraceProvider = TLCOutputSourceRegistry.getModelCheckSourceRegistry().getProvider(model);
        List<TLCError> errors = originalTraceProvider.getErrors();
        if (errors != null) {
            for (TLCError error : errors) {
                if (!error.hasTrace()) continue;
                return error;
            }
        }
        return null;
    }

    public static void serializeTrace(Model model) {
        try {
            List<TLCState> trace = TraceExplorerHelper.getErrorOfOriginalTrace(model).getStates(TLCError.Length.ALL);
            Assert.isNotNull(trace);
            Iterator<TLCState> it = trace.iterator();
            IFile traceSourceFile = model.getTraceSourceFile();
            ModelHelper.createOrClearFiles((IFile[])new IFile[]{traceSourceFile}, (IProgressMonitor)new NullProgressMonitor());
            while (it.hasNext()) {
                traceSourceFile.appendContents((InputStream)new ByteArrayInputStream("@!@!@STARTMSG 0000:4 @!@!@\n".getBytes()), 1, (IProgressMonitor)new NullProgressMonitor());
                TLCState state = it.next();
                StringBuffer toAppend = new StringBuffer();
                toAppend.append(state.getStateNumber()).append(": ").append(state.getLabel()).append("\n").append(state.toString());
                traceSourceFile.appendContents((InputStream)new ByteArrayInputStream(toAppend.toString().getBytes()), 1, (IProgressMonitor)new NullProgressMonitor());
                traceSourceFile.appendContents((InputStream)new ByteArrayInputStream("@!@!@ENDMSG 0000 @!@!@\n".getBytes()), 1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Error writing trace contents to file", e);
        }
    }
}

