/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.console;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.lamport.tla.toolbox.util.UIHelper;

public class ConsoleFactory
implements IConsoleFactory {
    private static final String TLC_ID = "TLC-Console";

    public void openConsole() {
        IWorkbenchPage activePage = UIHelper.getActivePage();
        if (activePage != null) {
            try {
                activePage.showView("org.eclipse.ui.console.ConsoleView", TLC_ID, 1);
            }
            catch (PartInitException e) {
                ConsolePlugin.log((Throwable)e);
            }
        }
    }

    public static IOConsole getTLCConsole() {
        IOConsole console = ConsoleFactory.findConsole(TLC_ID);
        return console;
    }

    private static IOConsole findConsole(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Console name must be not null");
        }
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (IOConsole)existing[i];
            }
            ++i;
        }
        IOConsole myConsole = new IOConsole(name, null);
        consoleManager.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

