/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.modelexplorer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.navigator.CommonViewer;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.model.AbstractModelStateChangeListener;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.ui.provider.IGroup;
import org.lamport.tla.toolbox.util.UIHelper;

public class ModelContentProvider
implements ITreeContentProvider {
    public static final String TLC_NCE = "toolbox.content.ModelContent";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Map<Model, Group> reverse = new HashMap<Model, Group>();
    private final MyStateChangeListener modelChangeListener = new MyStateChangeListener();

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Spec) {
            Spec currentSpec = (Spec)parentElement;
            if (ToolboxHandle.getCurrentSpec() == parentElement) {
                Collection models = ((TLCSpec)currentSpec.getAdapter(TLCSpec.class)).getModels(".*_SnapShot_[0-9]*$", false).values();
                return new Group[]{new Group((Spec)parentElement, models.toArray(new Model[models.size()]))};
            }
        } else {
            if (parentElement instanceof Group) {
                Object[] models;
                Object[] objectArray = models = ((Group)parentElement).getModels();
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    Object model = objectArray[n2];
                    model.add((AbstractModelStateChangeListener)this.modelChangeListener);
                    ++n2;
                }
                return models;
            }
            if (parentElement instanceof Model) {
                Collection snapshots = ((Model)parentElement).getSnapshots();
                for (Model model : snapshots) {
                    model.add((AbstractModelStateChangeListener)this.modelChangeListener);
                }
                return snapshots.toArray(new Model[snapshots.size()]);
            }
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof Model) {
            Model model = (Model)element;
            if (model.isSnapshot()) {
                return model.getSnapshotFor();
            }
            return model.getSpec();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Group) {
            return ((Group)element).getModels().length > 0;
        }
        if (element instanceof Model) {
            return ((Model)element).hasSnapshots();
        }
        return element instanceof Spec && ToolboxHandle.getCurrentSpec() == element;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.reverse.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.modelChangeListener.setViewer((CommonViewer)viewer);
    }

    public static final class Group
    implements IGroup {
        private final Model[] models;
        private final Spec spec;

        public Group(Spec spec, Model[] models) {
            this.spec = spec;
            this.models = models;
        }

        public Model[] getModels() {
            return this.models;
        }

        public Spec getSpec() {
            return this.spec;
        }

        public String toString() {
            return "models";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.spec == null ? 0 : this.spec.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Group other = (Group)obj;
            return !(this.spec == null ? other.spec != null : !this.spec.equals(other.spec));
        }
    }

    private static class MyStateChangeListener
    extends AbstractModelStateChangeListener {
        private CommonViewer viewer;

        private MyStateChangeListener() {
        }

        public void setViewer(CommonViewer viewer) {
            this.viewer = viewer;
        }

        public CommonViewer getViewer() {
            return this.viewer;
        }

        public boolean handleChange(final AbstractModelStateChangeListener.ChangeEvent event) {
            if (event.getState() == AbstractModelStateChangeListener.State.DELETED) {
                UIHelper.runUISync((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Model model = event.getModel();
                        Spec parent = model.getSpec().toSpec();
                        this.getViewer().setSelection((ISelection)new StructuredSelection((Object)parent));
                        this.getViewer().remove((Object)parent, new Object[]{model});
                    }
                });
            } else if (event.getState() == AbstractModelStateChangeListener.State.REMOTE_NOT_RUNNING) {
                UIHelper.runUISync((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.getViewer().refresh((Object)event.getModel(), true);
                    }
                });
            }
            return true;
        }
    }
}

